/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;

public final class CheckEnums
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType DUPLICATE_ENUM_VALUE = DiagnosticType.disabled("JSC_DUPLICATE_ENUM_VALUE", "The value {0} is duplicated in this enum.");
    public static final DiagnosticType COMPUTED_PROP_NAME_IN_ENUM = DiagnosticType.disabled("JSC_COMPUTED_PROP_NAME_IN_ENUM", "Computed property name used in enum.");
    public static final DiagnosticType SHORTHAND_ASSIGNMENT_IN_ENUM = DiagnosticType.disabled("JSC_SHORTHAND_ASSIGNMENT_IN_ENUM", "Shorthand assignment used in enum.");
    public static final DiagnosticType ENUM_PROP_NOT_CONSTANT = DiagnosticType.disabled("JSC_ENUM_PROP_NOT_CONSTANT", "enum key {0} must be in ALL_CAPS.");
    private final AbstractCompiler compiler;

    public CheckEnums(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsdoc;
        if (n.isObjectLit() && (jsdoc = NodeUtil.getBestJSDocInfo(n)) != null && jsdoc.hasEnumParameterType()) {
            this.checkNamingAndAssignmentUsage(t, n);
            this.checkDuplicateEnumValues(t, n);
        }
    }

    private void checkNamingAndAssignmentUsage(NodeTraversal t, Node n) {
        for (Node child : n.children()) {
            this.checkName(t, child);
        }
    }

    private void checkName(NodeTraversal t, Node node) {
        if (node.isComputedProp()) {
            t.report(node, COMPUTED_PROP_NAME_IN_ENUM, new String[0]);
            return;
        }
        if (node.isStringKey() && node.isShorthandProperty()) {
            t.report(node, SHORTHAND_ASSIGNMENT_IN_ENUM, new String[0]);
        }
        if (!this.compiler.getCodingConvention().isValidEnumKey(node.getString())) {
            t.report(node, ENUM_PROP_NOT_CONSTANT, new String[0]);
        }
    }

    private void checkDuplicateEnumValues(NodeTraversal t, Node n) {
        HashSet<String> values = new HashSet<String>();
        for (Node child : n.children()) {
            String value;
            Node valueNode = child.getLastChild();
            if (valueNode == null) {
                return;
            }
            if (valueNode.isString()) {
                value = valueNode.getString();
            } else if (valueNode.isNumber()) {
                value = Double.toString(valueNode.getDouble());
            } else {
                return;
            }
            if (values.add(value)) continue;
            t.report(valueNode, DUPLICATE_ENUM_VALUE, value);
        }
    }
}

