/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ant;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.ant.AntErrorManager;
import com.google.javascript.jscomp.ant.Warning;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public final class CompileTask
extends Task {
    private CompilerOptions.LanguageMode languageIn;
    private CompilerOptions.LanguageMode languageOut;
    private WarningLevel warningLevel;
    private boolean debugOptions = false;
    private String encoding = "UTF-8";
    private Charset outputEncoding = StandardCharsets.UTF_8;
    private CompilationLevel compilationLevel;
    private CompilerOptions.Environment environment;
    private boolean manageDependencies = false;
    private boolean prettyPrint = false;
    private boolean printInputDelimiter = false;
    private boolean preferSingleQuotes = false;
    private boolean generateExports = false;
    private boolean replaceProperties = false;
    private boolean forceRecompile = false;
    private boolean angularPass = false;
    private String replacePropertiesPrefix = "closure.define.";
    private File outputFile;
    private String outputWrapper;
    private File outputWrapperFile;
    private final List<Parameter> defineParams;
    private final List<Parameter> entryPointParams;
    private final List<FileList> externFileLists;
    private final List<FileList> sourceFileLists;
    private final List<Path> sourcePaths;
    private final List<Warning> warnings;
    private String sourceMapFormat;
    private File sourceMapOutputFile;
    private String sourceMapLocationMapping;
    private boolean applyInputSourceMaps;

    public CompileTask() {
        this.languageIn = CompilerOptions.LanguageMode.ECMASCRIPT_2015;
        this.languageOut = CompilerOptions.LanguageMode.ECMASCRIPT3;
        this.warningLevel = WarningLevel.DEFAULT;
        this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        this.environment = CompilerOptions.Environment.BROWSER;
        this.defineParams = new ArrayList<Parameter>();
        this.entryPointParams = new ArrayList<Parameter>();
        this.externFileLists = new ArrayList<FileList>();
        this.sourceFileLists = new ArrayList<FileList>();
        this.sourcePaths = new ArrayList<Path>();
        this.warnings = new ArrayList<Warning>();
    }

    private static CompilerOptions.LanguageMode parseLanguageMode(String value) {
        switch (value) {
            case "ECMASCRIPT6_STRICT": 
            case "ES6_STRICT": 
            case "ECMASCRIPT6": 
            case "ES6": {
                return CompilerOptions.LanguageMode.ECMASCRIPT_2015;
            }
            case "ECMASCRIPT5_STRICT": 
            case "ES5_STRICT": {
                return CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT;
            }
            case "ECMASCRIPT5": 
            case "ES5": {
                return CompilerOptions.LanguageMode.ECMASCRIPT5;
            }
            case "ECMASCRIPT3": 
            case "ES3": {
                return CompilerOptions.LanguageMode.ECMASCRIPT3;
            }
        }
        throw new BuildException("Unrecognized 'languageIn' option value (" + value + ")");
    }

    public void setLanguageIn(String value) {
        this.languageIn = CompileTask.parseLanguageMode(value);
    }

    public void setLanguageOut(String value) {
        this.languageOut = CompileTask.parseLanguageMode(value);
    }

    public void setWarning(String value) {
        if ("default".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.DEFAULT;
        } else if ("quiet".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.QUIET;
        } else if ("verbose".equalsIgnoreCase(value)) {
            this.warningLevel = WarningLevel.VERBOSE;
        } else {
            throw new BuildException("Unrecognized 'warning' option value (" + value + ")");
        }
    }

    public void setEnvironment(String value) {
        switch (value) {
            case "BROWSER": {
                this.environment = CompilerOptions.Environment.BROWSER;
                break;
            }
            case "CUSTOM": {
                this.environment = CompilerOptions.Environment.CUSTOM;
                break;
            }
            default: {
                throw new BuildException("Unrecognized 'environment' option value (" + value + ")");
            }
        }
    }

    public void setDebug(boolean value) {
        this.debugOptions = value;
    }

    public void setCompilationLevel(String value) {
        if ("simple".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        } else if ("advanced".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.ADVANCED_OPTIMIZATIONS;
        } else if ("whitespace".equalsIgnoreCase(value)) {
            this.compilationLevel = CompilationLevel.WHITESPACE_ONLY;
        } else {
            throw new BuildException("Unrecognized 'compilation' option value (" + value + ")");
        }
    }

    public void setManageDependencies(boolean value) {
        this.manageDependencies = value;
    }

    public void setOutput(File value) {
        this.outputFile = value;
    }

    public void setOutputWrapper(String value) {
        this.outputWrapper = value;
    }

    public void setOutputWrapperFile(File value) {
        this.outputWrapperFile = value;
    }

    public void setReplacePropertiesPrefix(String value) {
        this.replacePropertiesPrefix = value;
    }

    public void setReplaceProperties(boolean value) {
        this.replaceProperties = value;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = Charset.forName(outputEncoding);
    }

    public void setPrettyPrint(boolean pretty) {
        this.prettyPrint = pretty;
    }

    public void setPrintInputDelimiter(boolean print) {
        this.printInputDelimiter = print;
    }

    public void setPreferSingleQuotes(boolean singlequotes) {
        this.preferSingleQuotes = singlequotes;
    }

    public void setForceRecompile(boolean forceRecompile) {
        this.forceRecompile = forceRecompile;
    }

    public void setAngularPass(boolean angularPass) {
        this.angularPass = angularPass;
    }

    public void setGenerateExports(boolean generateExports) {
        this.generateExports = generateExports;
    }

    public void addExterns(FileList list) {
        this.externFileLists.add(list);
    }

    public void addWarning(Warning warning) {
        this.warnings.add(warning);
    }

    public void addEntryPoint(Parameter entrypoint) {
        this.entryPointParams.add(entrypoint);
    }

    public void addSources(FileList list) {
        this.sourceFileLists.add(list);
    }

    public void addPath(Path list) {
        this.sourcePaths.add(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute must be set");
        }
        Compiler.setLoggingLevel(Level.OFF);
        CompilerOptions options = this.createCompilerOptions();
        Compiler compiler = this.createCompiler(options);
        List<SourceFile> externs = this.findExternFiles(options);
        List<SourceFile> sources = this.findSourceFiles();
        if (this.isStale() || this.forceRecompile) {
            this.log("Compiling " + sources.size() + " file(s) with " + externs.size() + " extern(s)");
            Result result = compiler.compile(externs, sources, options);
            if (!result.success) throw new BuildException("Compilation failed.");
            StringBuilder source = new StringBuilder(compiler.toSource());
            if (this.outputWrapperFile != null) {
                try {
                    this.outputWrapper = Files.asCharSource((File)this.outputWrapperFile, (Charset)StandardCharsets.UTF_8).read();
                }
                catch (Exception e) {
                    throw new BuildException("Invalid output_wrapper_file specified.");
                }
            }
            if (this.outputWrapper != null) {
                int pos = this.outputWrapper.indexOf("%output%");
                if (pos <= -1) throw new BuildException("Invalid output_wrapper specified. Missing '%output%'.");
                String prefix = this.outputWrapper.substring(0, pos);
                source.insert(0, prefix);
                int suffixStart = pos + "%output%".length();
                String suffix = this.outputWrapper.substring(suffixStart);
                source.append(suffix);
            }
            if (result.sourceMap != null) {
                this.flushSourceMap(result.sourceMap);
            }
            this.writeResult(source.toString());
            return;
        }
        this.log("None of the files changed. Compilation skipped.");
    }

    private void flushSourceMap(SourceMap sourceMap) {
        try (FileWriter out = new FileWriter(this.sourceMapOutputFile);){
            sourceMap.appendTo(out, this.outputFile.getName());
        }
        catch (IOException e) {
            throw new BuildException("Cannot write sourcemap to file.", (Throwable)e);
        }
    }

    private CompilerOptions createCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        this.compilationLevel.setOptionsForCompilationLevel(options);
        if (this.debugOptions) {
            this.compilationLevel.setDebugOptionsForCompilationLevel(options);
        }
        options.setEnvironment(this.environment);
        options.setPrettyPrint(this.prettyPrint);
        options.setPrintInputDelimiter(this.printInputDelimiter);
        options.setPreferSingleQuotes(this.preferSingleQuotes);
        options.setGenerateExports(this.generateExports);
        options.setLanguageIn(this.languageIn);
        options.setLanguageOut(this.languageOut);
        options.setOutputCharset(this.outputEncoding);
        this.warningLevel.setOptionsForWarningLevel(options);
        options.setManageClosureDependencies(this.manageDependencies);
        this.convertEntryPointParameters(options);
        options.setTrustedStrings(true);
        options.setAngularPass(this.angularPass);
        if (this.replaceProperties) {
            this.convertPropertiesMap(options);
        }
        this.convertDefineParameters(options);
        for (Warning warning : this.warnings) {
            CheckLevel level = warning.getLevel();
            String groupName = warning.getGroup();
            DiagnosticGroup group = new DiagnosticGroups().forName(groupName);
            if (group == null) {
                throw new BuildException("Unrecognized 'warning' option value (" + groupName + ")");
            }
            options.setWarningLevel(group, level);
        }
        if (!Strings.isNullOrEmpty((String)this.sourceMapFormat)) {
            options.setSourceMapFormat(SourceMap.Format.valueOf(this.sourceMapFormat));
        }
        if (!Strings.isNullOrEmpty((String)this.sourceMapLocationMapping)) {
            String[] tokens = this.sourceMapLocationMapping.split("\\|", -1);
            SourceMap.PrefixLocationMapping lm = new SourceMap.PrefixLocationMapping(tokens[0], tokens[1]);
            options.setSourceMapLocationMappings(Arrays.asList(lm));
        }
        options.setApplyInputSourceMaps(this.applyInputSourceMaps);
        if (this.sourceMapOutputFile != null) {
            File parentFile = this.sourceMapOutputFile.getParentFile();
            if (parentFile.mkdirs()) {
                this.log("Created missing parent directory " + parentFile, 4);
            }
            options.setSourceMapOutputPath(parentFile.getAbsolutePath());
        }
        return options;
    }

    public Parameter createDefine() {
        Parameter param = new Parameter();
        this.defineParams.add(param);
        return param;
    }

    public Parameter createEntryPoint() {
        Parameter param = new Parameter();
        this.entryPointParams.add(param);
        return param;
    }

    private void convertDefineParameters(CompilerOptions options) {
        for (Parameter p : this.defineParams) {
            String value;
            String key = p.getName();
            if (this.setDefine(options, key, value = p.getValue())) continue;
            this.log("Unexpected @define value for name=" + key + "; value=" + value);
        }
    }

    private void convertEntryPointParameters(CompilerOptions options) {
        ArrayList<String> entryPoints = new ArrayList<String>();
        for (Parameter p : this.entryPointParams) {
            String key = p.getName();
            entryPoints.add(key);
        }
        if (this.manageDependencies) {
            options.setManageClosureDependencies(entryPoints);
        }
    }

    private void convertPropertiesMap(CompilerOptions options) {
        Hashtable props = this.getProject().getProperties();
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith(this.replacePropertiesPrefix) || this.setDefine(options, key = key.substring(this.replacePropertiesPrefix.length()), value)) continue;
            this.log("Unexpected property value for key=" + key + "; value=" + value);
        }
    }

    private boolean setDefine(CompilerOptions options, String key, Object value) {
        boolean success = false;
        if (value instanceof String) {
            boolean isTrue = "true".equals(value);
            boolean isFalse = "false".equals(value);
            if (isTrue || isFalse) {
                options.setDefineToBooleanLiteral(key, isTrue);
            } else {
                try {
                    double dblTemp = Double.parseDouble((String)value);
                    options.setDefineToDoubleLiteral(key, dblTemp);
                }
                catch (NumberFormatException nfe) {
                    options.setDefineToStringLiteral(key, (String)value);
                }
            }
            success = true;
        } else if (value instanceof Boolean) {
            options.setDefineToBooleanLiteral(key, (Boolean)value);
            success = true;
        } else if (value instanceof Integer) {
            options.setDefineToNumberLiteral(key, (Integer)value);
            success = true;
        } else if (value instanceof Double) {
            options.setDefineToDoubleLiteral(key, (Double)value);
            success = true;
        }
        return success;
    }

    private Compiler createCompiler(CompilerOptions options) {
        Compiler compiler = new Compiler();
        MessageFormatter formatter = options.getErrorFormat().toFormatter(compiler, false);
        AntErrorManager errorManager = new AntErrorManager(formatter, this);
        compiler.setErrorManager(errorManager);
        return compiler;
    }

    private List<SourceFile> findExternFiles(CompilerOptions options) {
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        files.addAll(this.getBuiltinExterns(options));
        for (FileList list : this.externFileLists) {
            files.addAll(this.findJavaScriptFiles((ResourceCollection)list));
        }
        return files;
    }

    private List<SourceFile> findSourceFiles() {
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        for (FileList fileList : this.sourceFileLists) {
            files.addAll(this.findJavaScriptFiles((ResourceCollection)fileList));
        }
        for (Path path : this.sourcePaths) {
            files.addAll(this.findJavaScriptFiles((ResourceCollection)path));
        }
        return files;
    }

    private List<SourceFile> findJavaScriptFiles(ResourceCollection rc) {
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        for (FileResource fr : rc) {
            java.nio.file.Path path = Paths.get("", new String[0]).toAbsolutePath().relativize(fr.getFile().toPath());
            files.add(SourceFile.fromPath(path, Charset.forName(this.encoding)));
        }
        return files;
    }

    private List<SourceFile> getBuiltinExterns(CompilerOptions options) {
        try {
            return CommandLineRunner.getBuiltinExterns(options.getEnvironment());
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void writeResult(String source) {
        if (this.outputFile.getParentFile().mkdirs()) {
            this.log("Created missing parent directory " + this.outputFile.getParentFile(), 4);
        }
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.outputEncoding);){
            out.append(source);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Compiled JavaScript written to " + this.outputFile.getAbsolutePath(), 4);
    }

    private boolean isStale() {
        long lastRun = this.outputFile.lastModified();
        long sourcesLastModified = Math.max(this.getLastModifiedTime(this.sourceFileLists), this.getLastModifiedTime(this.sourcePaths));
        long externsLastModified = this.getLastModifiedTime(this.externFileLists);
        return lastRun <= sourcesLastModified || lastRun <= externsLastModified;
    }

    private long getLastModifiedTime(List<?> fileLists) {
        long lastModified = 0L;
        for (Object entry : fileLists) {
            if (entry instanceof FileList) {
                FileList list = (FileList)entry;
                for (String fileName : list.getFiles(this.getProject())) {
                    File path = list.getDir(this.getProject());
                    File file = new File(path, fileName);
                    lastModified = Math.max(CompileTask.getLastModifiedTime(file), lastModified);
                }
                continue;
            }
            if (!(entry instanceof Path)) continue;
            Path path = (Path)entry;
            for (String src : path.list()) {
                File file = new File(src);
                lastModified = Math.max(CompileTask.getLastModifiedTime(file), lastModified);
            }
        }
        return lastModified;
    }

    private static long getLastModifiedTime(File file) {
        long fileLastModified = file.lastModified();
        if (fileLastModified == 0L) {
            fileLastModified = new Date().getTime();
        }
        return fileLastModified;
    }

    public void setSourceMapFormat(String format) {
        this.sourceMapFormat = format;
    }

    public void setSourceMapOutputFile(File sourceMapOutputFile) {
        this.sourceMapOutputFile = sourceMapOutputFile;
    }

    public void setSourceMapLocationMapping(String mapping) {
        this.sourceMapLocationMapping = mapping;
    }
}

