/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;

public class SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private AbstractScope<?, ?> scope;
    private InputId inputId;
    private final boolean isTyped;

    private SyntacticScopeCreator(AbstractCompiler compiler, boolean isTyped) {
        this.compiler = compiler;
        this.isTyped = isTyped;
    }

    @Deprecated
    public static SyntacticScopeCreator makeUntyped(AbstractCompiler compiler) {
        return new SyntacticScopeCreator(compiler, false);
    }

    static SyntacticScopeCreator makeTyped(AbstractCompiler compiler) {
        return new SyntacticScopeCreator(compiler, true);
    }

    @Override
    public AbstractScope<?, ?> createScope(Node n, AbstractScope<?, ?> parent) {
        this.inputId = null;
        this.scope = parent == null ? (this.isTyped ? TypedScope.createGlobalScope(n) : Scope.createGlobalScope(n)) : (this.isTyped ? new TypedScope((TypedScope)parent, n) : Scope.createChildScope((Scope)parent, n));
        this.scanRoot(n);
        this.inputId = null;
        AbstractScope<?, ?> returnedScope = this.scope;
        this.scope = null;
        return returnedScope;
    }

    private void scanRoot(Node n) {
        if (n.isFunction()) {
            if (this.inputId == null) {
                this.inputId = NodeUtil.getInputId(n);
            }
            Node fnNameNode = n.getFirstChild();
            Node args = fnNameNode.getNext();
            Node body = args.getNext();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && NodeUtil.isFunctionExpression(n)) {
                this.declareVar(fnNameNode);
            }
            Preconditions.checkState((boolean)args.isParamList());
            for (Node a = args.getFirstChild(); a != null; a = a.getNext()) {
                Preconditions.checkState((boolean)a.isName());
                this.declareVar(a);
            }
            this.scanVars(body);
        } else {
            Preconditions.checkState((n.isModuleBody() || this.scope.getParent() == null ? 1 : 0) != 0, (String)"Expected %s to be a module body, or %s to be the global scope.", (Object)n, this.scope);
            this.scanVars(n);
        }
    }

    private void scanVars(Node n) {
        switch (n.getToken()) {
            case VAR: {
                Node child = n.getFirstChild();
                while (child != null) {
                    Node next = child.getNext();
                    this.declareVar(child);
                    child = next;
                }
                return;
            }
            case FUNCTION: {
                if (NodeUtil.isFunctionExpression(n)) {
                    return;
                }
                String fnName = n.getFirstChild().getString();
                if (fnName.isEmpty()) {
                    return;
                }
                this.declareVar(n.getFirstChild());
                return;
            }
            case CATCH: {
                Preconditions.checkState((boolean)n.hasTwoChildren(), (Object)n);
                Node var = n.getFirstChild();
                Preconditions.checkState((boolean)var.isName(), (Object)var);
                Node block = var.getNext();
                this.declareVar(var);
                this.scanVars(block);
                return;
            }
            case SCRIPT: {
                this.inputId = n.getInputId();
                Preconditions.checkNotNull((Object)this.inputId);
                break;
            }
        }
        if (NodeUtil.isControlStructure(n) || NodeUtil.isStatementBlock(n)) {
            Node child = n.getFirstChild();
            while (child != null) {
                Node next = child.getNext();
                this.scanVars(child);
                child = next;
            }
        }
    }

    private void declareVar(Node n) {
        Preconditions.checkState((boolean)n.isName(), (Object)n);
        CompilerInput input = this.compiler.getInput(this.inputId);
        String name = n.getString();
        if (!(this.scope.hasOwnSlot(name) || this.scope.isLocal() && name.equals("arguments"))) {
            if (this.isTyped) {
                ((TypedScope)this.scope).declare(name, n, null, input);
            } else {
                ((Scope)this.scope).declare(name, n, input);
            }
        }
    }

    @Override
    public boolean hasBlockScope() {
        return false;
    }
}

