/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;

class ShadowVariables
implements CompilerPass {
    private final Multimap<Node, String> scopeUpRefMap = HashMultimap.create();
    private final Multimap<Var, Reference> varToNameUsage = HashMultimap.create();
    private final AbstractCompiler compiler;
    private final SortedSet<RenameVars.Assignment> varsByFrequency;
    private final Map<String, RenameVars.Assignment> assignments;
    private final Map<Node, String> oldPseudoNameMap;
    private final Map<Node, String> deltaPseudoNameMap;

    ShadowVariables(AbstractCompiler compiler, Map<String, RenameVars.Assignment> assignments, SortedSet<RenameVars.Assignment> varsByFrequency, Map<Node, String> pseudoNameMap) {
        this.compiler = compiler;
        this.assignments = assignments;
        this.varsByFrequency = varsByFrequency;
        this.oldPseudoNameMap = pseudoNameMap;
        this.deltaPseudoNameMap = new LinkedHashMap<Node, String>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherReferenceInfo());
        NodeTraversal.traverse(this.compiler, root, new DoShadowVariables());
        if (this.oldPseudoNameMap != null) {
            this.oldPseudoNameMap.putAll(this.deltaPseudoNameMap);
        }
    }

    private static final class Reference {
        private final Node nameNode;
        private final Scope scope;

        private Reference(Node nameNode, Scope scope) {
            this.nameNode = nameNode;
            this.scope = scope;
        }
    }

    private class DoShadowVariables
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private DoShadowVariables() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Node scopeRoot = t.getScopeRoot();
            if (scopeRoot.isFunction() && NodeUtil.getEnclosingFunction(scopeRoot.getParent()) == null || NodeUtil.isFunctionBlock(scopeRoot) && NodeUtil.getEnclosingFunction(scopeRoot.getGrandparent()) == null) {
                return;
            }
            Scope s = t.getScope();
            for (Var var : s.getVarIterable()) {
                RenameVars.Assignment bestShadow;
                RenameVars.Assignment localAssignment;
                if (var.isBleedingFunction() || var.isCatch() || ShadowVariables.this.compiler.getCodingConvention().isExported(var.name, s.isLocal()) || (localAssignment = (RenameVars.Assignment)ShadowVariables.this.assignments.get(var.getName())) == null || (bestShadow = this.findBestShadow(s, var)) == null || bestShadow.count < localAssignment.count) continue;
                this.doShadow(localAssignment, bestShadow, var);
                if (ShadowVariables.this.oldPseudoNameMap == null) continue;
                String targetPseudoName = (String)ShadowVariables.this.oldPseudoNameMap.get(((Var)s.getVar((String)bestShadow.oldName)).nameNode);
                for (Reference use : ShadowVariables.this.varToNameUsage.get((Object)var)) {
                    ShadowVariables.this.deltaPseudoNameMap.put(use.nameNode, targetPseudoName);
                }
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }

        private RenameVars.Assignment findBestShadow(Scope curScope, Var var) {
            for (RenameVars.Assignment assignment : ShadowVariables.this.varsByFrequency) {
                if (!assignment.isLocal || ShadowVariables.this.scopeUpRefMap.containsEntry((Object)curScope.getRootNode(), (Object)assignment.oldName) || !curScope.hasSlot(assignment.oldName)) continue;
                Var toShadow = (Var)curScope.getVar(assignment.oldName);
                if (var.getScope() == toShadow.getScope()) continue;
                return assignment;
            }
            return null;
        }

        private void doShadow(RenameVars.Assignment original, RenameVars.Assignment toShadow, Var var) {
            Scope s = (Scope)var.getScope();
            Collection references = ShadowVariables.this.varToNameUsage.get((Object)var);
            ShadowVariables.this.varsByFrequency.remove(original);
            ShadowVariables.this.varsByFrequency.remove(toShadow);
            original.count -= references.size();
            toShadow.count += references.size();
            ShadowVariables.this.varsByFrequency.add(original);
            ShadowVariables.this.varsByFrequency.add(toShadow);
            Var shadowed = (Var)s.getVar(toShadow.oldName);
            if (shadowed != null) {
                if (s.isFunctionScope() && s.getRootNode().getLastChild().isBlock()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)s.getRootNode().getLastChild(), (Object)toShadow.oldName);
                    ShadowVariables.this.scopeUpRefMap.remove((Object)s.getRootNode().getLastChild(), (Object)original.oldName);
                }
                for (Scope curScope = s; curScope != shadowed.scope; curScope = (Scope)curScope.getParent()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)curScope.getRootNode(), (Object)toShadow.oldName);
                    ShadowVariables.this.scopeUpRefMap.remove((Object)curScope.getRootNode(), (Object)original.oldName);
                }
            }
            for (Reference ref : references) {
                Node n = ref.nameNode;
                n.setString(toShadow.oldName);
                if (ref.scope.getRootNode() == s.getRootNode()) {
                    if (var.getNameNode() == ref.nameNode) continue;
                    ShadowVariables.this.scopeUpRefMap.put((Object)s.getRootNode(), (Object)toShadow.oldName);
                    ShadowVariables.this.scopeUpRefMap.remove((Object)s.getRootNode(), (Object)original.oldName);
                    continue;
                }
                Scope curScope = ref.scope;
                while (curScope.getRootNode() != s.getRootNode()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)curScope.getRootNode(), (Object)toShadow.oldName);
                    ShadowVariables.this.scopeUpRefMap.remove((Object)curScope.getRootNode(), (Object)original.oldName);
                    curScope = (Scope)curScope.getParent();
                }
            }
        }
    }

    private class GatherReferenceInfo
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherReferenceInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            if (t.inGlobalScope()) {
                return;
            }
            Scope scope = t.getScope();
            Var var = (Var)scope.getVar(n.getString());
            if (var == null) {
                return;
            }
            if (((Scope)var.getScope()).isGlobal()) {
                return;
            }
            if (var.getScope() != scope) {
                for (Scope s = scope; s != var.getScope() && s.isLocal(); s = (Scope)s.getParent()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)s.getRootNode(), (Object)var.name);
                }
            } else {
                ShadowVariables.this.scopeUpRefMap.put((Object)t.getScopeRoot(), (Object)var.name);
            }
            if (scope.isFunctionScope() && var.getScope() == scope) {
                ShadowVariables.this.scopeUpRefMap.put((Object)scope.getRootNode().getLastChild(), (Object)var.name);
            }
            ShadowVariables.this.varToNameUsage.put((Object)var, (Object)new Reference(n, scope));
        }
    }
}

