/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.FunctionToBlockMutator;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class ProcessCommonJSModules
extends NodeTraversal.AbstractPreOrderCallback
implements CompilerPass {
    private static final String EXPORTS = "exports";
    private static final String MODULE = "module";
    private static final String REQUIRE = "require";
    private static final String WEBPACK_REQUIRE = "__webpack_require__";
    private static final String EXPORT_PROPERTY_NAME = "default";
    public static final DiagnosticType UNKNOWN_REQUIRE_ENSURE = DiagnosticType.warning("JSC_COMMONJS_UNKNOWN_REQUIRE_ENSURE_ERROR", "Unrecognized require.ensure call: {0}");
    public static final DiagnosticType SUSPICIOUS_EXPORTS_ASSIGNMENT = DiagnosticType.warning("JSC_COMMONJS_SUSPICIOUS_EXPORTS_ASSIGNMENT", "Suspicious re-assignment of \"exports\" variable. Did you actually intend to export something?");
    private final AbstractCompiler compiler;

    public ProcessCommonJSModules(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isRoot()) {
            return true;
        }
        if (n.isScript()) {
            if (this.compiler.getOptions().getModuleResolutionMode() == ModuleLoader.ResolutionMode.WEBPACK) {
                this.removeWebpackModuleShim(n);
            }
            FindImportsAndExports finder = new FindImportsAndExports();
            ErrorHandler moduleLoaderErrorHandler = this.compiler.getModuleLoader().getErrorHandler();
            this.compiler.getModuleLoader().setErrorHandler(finder);
            NodeTraversal.traverse(this.compiler, n, finder);
            CompilerInput.ModuleType moduleType = this.compiler.getInput(n.getInputId()).getJsModuleType();
            boolean forceModuleDetection = moduleType == CompilerInput.ModuleType.IMPORTED_SCRIPT;
            boolean defaultExportIsConst = true;
            boolean isCommonJsModule = finder.isCommonJsModule();
            ImmutableList.Builder exports = ImmutableList.builder();
            if (isCommonJsModule || forceModuleDetection) {
                if (!finder.umdPatterns.isEmpty()) {
                    boolean needsRetraverse = false;
                    if (finder.replaceUmdPatterns()) {
                        needsRetraverse = true;
                    }
                    if (this.removeIIFEWrapper(n)) {
                        needsRetraverse = true;
                    }
                    if (needsRetraverse) {
                        finder = new FindImportsAndExports();
                        this.compiler.getModuleLoader().setErrorHandler(finder);
                        NodeTraversal.traverse(this.compiler, n, finder);
                    }
                }
                defaultExportIsConst = finder.initializeModule();
                exports.addAll(finder.getModuleExports());
                exports.addAll(finder.getExports());
            }
            finder.reportModuleErrors();
            this.compiler.getModuleLoader().setErrorHandler(moduleLoaderErrorHandler);
            NodeTraversal.traverse(this.compiler, n, new RewriteModule(isCommonJsModule || forceModuleDetection, (ImmutableCollection<ExportInfo>)exports.build(), defaultExportIsConst));
        }
        return false;
    }

    public static String getModuleName(CompilerInput input) {
        ModuleLoader.ModulePath modulePath = input.getPath();
        if (modulePath == null) {
            return null;
        }
        return ProcessCommonJSModules.getModuleName(modulePath);
    }

    public static String getModuleName(ModuleLoader.ModulePath input) {
        return input.toModuleName();
    }

    public String getBasePropertyImport(String moduleName) {
        CompilerInput.ModuleType moduleType = this.compiler.getModuleTypeByName(moduleName);
        if (moduleType != null && moduleType != CompilerInput.ModuleType.COMMONJS) {
            return moduleName;
        }
        return moduleName + "." + EXPORT_PROPERTY_NAME;
    }

    public boolean isCommonJsImport(Node requireCall) {
        return ProcessCommonJSModules.isCommonJsImport(requireCall, this.compiler.getOptions().getModuleResolutionMode());
    }

    public static boolean isCommonJsImport(Node requireCall, ModuleLoader.ResolutionMode resolutionMode) {
        if (requireCall.isCall() && requireCall.hasTwoChildren()) {
            if (resolutionMode == ModuleLoader.ResolutionMode.WEBPACK && requireCall.getFirstChild().matchesQualifiedName(WEBPACK_REQUIRE) && (requireCall.getSecondChild().isNumber() || requireCall.getSecondChild().isString())) {
                return true;
            }
            if (requireCall.getFirstChild().matchesQualifiedName(REQUIRE) && requireCall.getSecondChild().isString()) {
                return true;
            }
        } else if (requireCall.isCall() && requireCall.getChildCount() == 3 && resolutionMode == ModuleLoader.ResolutionMode.WEBPACK && requireCall.getFirstChild().matchesQualifiedName("__webpack_require__.bind") && requireCall.getSecondChild().isNull() && (requireCall.getLastChild().isNumber() || requireCall.getLastChild().isString())) {
            return true;
        }
        return false;
    }

    public String getCommonJsImportPath(Node requireCall) {
        return ProcessCommonJSModules.getCommonJsImportPath(requireCall, this.compiler.getOptions().getModuleResolutionMode());
    }

    public static String getCommonJsImportPath(Node requireCall, ModuleLoader.ResolutionMode resolutionMode) {
        if (resolutionMode == ModuleLoader.ResolutionMode.WEBPACK) {
            Node pathArgument;
            Node node = pathArgument = requireCall.getChildCount() >= 3 ? requireCall.getChildAtIndex(2) : requireCall.getSecondChild();
            if (pathArgument.isNumber()) {
                return String.valueOf((int)pathArgument.getDouble());
            }
            return pathArgument.getString();
        }
        return requireCall.getSecondChild().getString();
    }

    private String getImportedModuleName(NodeTraversal t, Node requireCall) {
        return this.getImportedModuleName(t, requireCall, this.getCommonJsImportPath(requireCall));
    }

    private String getImportedModuleName(NodeTraversal t, Node n, String importPath) {
        ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(importPath, n.getSourceFileName(), n.getLineno(), n.getCharno());
        if (modulePath == null) {
            return ModuleIdentifier.forFile(importPath).getModuleName();
        }
        return modulePath.toModuleName();
    }

    public static boolean isCommonJsExport(NodeTraversal t, Node export, ModuleLoader.ResolutionMode resolutionMode) {
        Var v;
        return export.matchesQualifiedName("module.exports") || export.isGetElem() && export.getFirstChild().matchesQualifiedName(MODULE) && export.getSecondChild().isString() && export.getSecondChild().getString().equals(EXPORTS) ? (v = (Var)t.getScope().getVar(MODULE)) == null || v.isExtern() : export.isName() && EXPORTS.equals(export.getString()) && ((v = (Var)t.getScope().getVar(export.getString())) == null || v.isGlobal());
    }

    private boolean isCommonJsExport(NodeTraversal t, Node export) {
        return ProcessCommonJSModules.isCommonJsExport(t, export, this.compiler.getOptions().getModuleResolutionMode());
    }

    public static boolean isCommonJsDynamicImportCallback(Node n, ModuleLoader.ResolutionMode resolutionMode) {
        if (resolutionMode != ModuleLoader.ResolutionMode.WEBPACK) {
            return false;
        }
        return n.isFunction() && ProcessCommonJSModules.isWebpackRequireEnsureCallback(n);
    }

    private static boolean isWebpackRequireEnsureCallback(Node fnc) {
        Preconditions.checkArgument((boolean)fnc.isFunction());
        if (fnc.getParent() == null) {
            return false;
        }
        Node callParent = fnc.getParent();
        if (!callParent.isCall()) {
            return false;
        }
        return callParent.hasChildren() && callParent.getFirstChild().isGetProp() && callParent.getFirstFirstChild().isCall() && callParent.getFirstFirstChild().getFirstChild().matchesQualifiedName("__webpack_require__.e") && callParent.getFirstChild().getSecondChild().isString() && callParent.getFirstChild().getSecondChild().getString().equals("then");
    }

    private Node getBaseQualifiedNameNode(Node n) {
        Node refParent = n;
        while (refParent.getParent() != null && refParent.getParent().isQualifiedName()) {
            refParent = refParent.getParent();
        }
        return refParent;
    }

    private boolean removeIIFEWrapper(Node root) {
        Node fnc;
        Node call;
        Node n;
        Preconditions.checkState((boolean)root.isScript());
        for (n = root.getFirstChild(); n != null && n.isEmpty(); n = n.getNext()) {
        }
        if (n == null || !n.isExprResult() || n.getNext() != null) {
            return false;
        }
        if (n != null && n.getFirstChild() != null && n.getFirstChild().isNot()) {
            n = n.getFirstChild();
        }
        if ((call = n.getFirstChild()) == null || !call.isCall()) {
            return false;
        }
        if (call.getFirstChild().isFunction()) {
            fnc = n.getFirstFirstChild();
        } else if (call.getFirstChild().isGetProp() && call.getFirstFirstChild().isFunction() && call.getFirstFirstChild().getNext().isString() && call.getFirstFirstChild().getNext().getString().equals("call")) {
            fnc = call.getFirstFirstChild();
            if (call.getSecondChild() == null || !call.getSecondChild().isThis() && !call.getSecondChild().matchesQualifiedName(EXPORTS)) {
                return false;
            }
        } else {
            return false;
        }
        if (NodeUtil.doesFunctionReferenceOwnArgumentsObject(fnc)) {
            return false;
        }
        CompilerInput ci = this.compiler.getInput(root.getInputId());
        ModuleLoader.ModulePath modulePath = ci.getPath();
        if (modulePath == null) {
            return false;
        }
        String iifeLabel = ProcessCommonJSModules.getModuleName(modulePath) + "_iifeWrapper";
        FunctionToBlockMutator mutator = new FunctionToBlockMutator(this.compiler, this.compiler.getUniqueNameIdSupplier());
        Node block = mutator.mutateWithoutRenaming(iifeLabel, fnc, call, null, false, false);
        root.removeChildren();
        root.addChildrenToFront(block.removeChildren());
        this.reportNestedScopesDeleted(fnc);
        this.compiler.reportChangeToEnclosingScope(root);
        return true;
    }

    private void removeWebpackModuleShim(Node root) {
        Node param;
        Node fnc;
        Node n;
        Preconditions.checkState((boolean)root.isScript());
        for (n = root.getFirstChild(); n != null && n.isEmpty(); n = n.getNext()) {
        }
        if (n == null || !n.isExprResult() || n.getNext() != null) {
            return;
        }
        Node call = n.getFirstChild();
        if (call == null || !call.isCall()) {
            return;
        }
        if (call.getFirstChild().isFunction()) {
            fnc = n.getFirstFirstChild();
        } else if (call.getFirstChild().isGetProp() && call.getFirstFirstChild().isFunction() && call.getFirstFirstChild().getNext().matchesQualifiedName("call")) {
            fnc = call.getFirstFirstChild();
        } else {
            return;
        }
        Node params = NodeUtil.getFunctionParameters(fnc);
        Node moduleParam = null;
        int paramNumber = 0;
        for (param = params.getFirstChild(); param != null; param = param.getNext()) {
            ++paramNumber;
            if (!param.isName() || !param.getString().equals(MODULE)) continue;
            moduleParam = param;
            break;
        }
        if (moduleParam == null) {
            return;
        }
        boolean isFreeCall = call.getBooleanProp((byte)50);
        Node arg = call.getChildAtIndex(isFreeCall ? paramNumber : paramNumber + 1);
        if (arg == null) {
            return;
        }
        if (arg.isCall() && arg.getFirstChild().isCall() && this.isCommonJsImport(arg.getFirstChild()) && arg.getSecondChild().isName() && arg.getSecondChild().getString().equals(MODULE)) {
            String importPath = this.getCommonJsImportPath(arg.getFirstChild());
            ModuleLoader.ModulePath modulePath = this.compiler.getInput(root.getInputId()).getPath().resolveJsModule(importPath, arg.getSourceFileName(), arg.getLineno(), arg.getCharno());
            if (modulePath == null) {
                return;
            }
            if (modulePath.toString().contains("/buildin/module.js")) {
                arg.detach();
                param.detach();
                this.compiler.reportChangeToChangeScope(fnc);
                this.compiler.reportChangeToEnclosingScope(fnc);
            }
        }
    }

    private void reportNestedScopesDeleted(Node n) {
        NodeUtil.visitPreOrder(n, new NodeUtil.Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isFunction()) {
                    ProcessCommonJSModules.this.compiler.reportFunctionDeleted(n);
                }
            }
        });
    }

    private void reportNestedScopesChanged(Node n) {
        NodeUtil.visitPreOrder(n, new NodeUtil.Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isFunction()) {
                    ProcessCommonJSModules.this.compiler.reportChangeToChangeScope(n);
                }
            }
        });
    }

    private static UmdPattern findUmdPattern(List<UmdPattern> umdPatterns, Node n) {
        for (UmdPattern umd : umdPatterns) {
            if (umd.ifRoot != n) continue;
            return umd;
        }
        return null;
    }

    private class RewriteModule
    extends NodeTraversal.AbstractPostOrderCallback {
        private final boolean allowFullRewrite;
        private final ImmutableCollection<ExportInfo> exports;
        private final List<Node> imports = new ArrayList<Node>();
        private final List<Node> rewrittenClassExpressions = new ArrayList<Node>();
        private final List<Node> functionsToHoist = new ArrayList<Node>();
        private final boolean defaultExportIsConst;

        public RewriteModule(boolean allowFullRewrite, ImmutableCollection<ExportInfo> exports, boolean defaultExportIsConst) {
            this.allowFullRewrite = allowFullRewrite;
            this.exports = exports;
            this.defaultExportIsConst = defaultExportIsConst;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    int i;
                    for (Node clazz : this.rewrittenClassExpressions) {
                        clazz.replaceChild(clazz.getFirstChild(), IR.empty().useSourceInfoFrom(clazz.getFirstChild()));
                        t.reportCodeChange();
                    }
                    CompilerInput ci = ProcessCommonJSModules.this.compiler.getInput(n.getInputId());
                    String moduleName = ProcessCommonJSModules.getModuleName(ci);
                    for (i = 1; i < this.functionsToHoist.size(); ++i) {
                        if (!this.functionsToHoist.get(i).getFirstFirstChild().matchesQualifiedName(ProcessCommonJSModules.this.getBasePropertyImport(moduleName))) continue;
                        Node fncVar = this.functionsToHoist.get(i);
                        this.functionsToHoist.remove(i);
                        this.functionsToHoist.add(0, fncVar);
                        break;
                    }
                    for (i = this.functionsToHoist.size() - 1; i >= 0; --i) {
                        Node functionExpr = this.functionsToHoist.get(i);
                        Node scopeRoot = t.getClosestHoistScopeRoot();
                        Node insertionPoint = scopeRoot.getFirstChild();
                        if (insertionPoint == null || !insertionPoint.isVar() || !insertionPoint.getFirstChild().getString().equals(moduleName)) {
                            insertionPoint = null;
                        }
                        if (insertionPoint == null) {
                            if (scopeRoot.getFirstChild() == functionExpr) continue;
                            scopeRoot.addChildToFront(functionExpr.detach());
                            continue;
                        }
                        if (insertionPoint == functionExpr || insertionPoint.getNext() == functionExpr) continue;
                        scopeRoot.addChildAfter(functionExpr.detach(), insertionPoint);
                    }
                    for (ExportInfo export : this.exports) {
                        this.visitExport(t, export);
                    }
                    for (Node require : this.imports) {
                        this.visitRequireCall(t, require, require.getParent());
                    }
                    break;
                }
                case CALL: {
                    if (!ProcessCommonJSModules.this.isCommonJsImport(n)) break;
                    this.imports.add(n);
                    break;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    if (n.hasMoreThanOneChild() && !NodeUtil.isAnyFor(parent)) {
                        List<Node> vars = this.splitMultipleDeclarations(n);
                        t.reportCodeChange();
                        for (Node var : vars) {
                            this.visit(t, var.getFirstChild(), var);
                        }
                    }
                    if (!n.getFirstChild().hasChildren() || !n.getFirstFirstChild().isName() || !n.getFirstChild().getString().equals(n.getFirstFirstChild().getString())) break;
                    n.detach();
                    t.reportCodeChange();
                    return;
                }
                case NAME: {
                    String qName;
                    if (NodeUtil.isNameDeclaration(n.getParent()) && n.getParent().hasMoreThanOneChild() && !NodeUtil.isAnyFor(n.getGrandparent()) || (qName = n.getQualifiedName()) == null) break;
                    final Var nameDeclaration = (Var)t.getScope().getVar(qName);
                    if (nameDeclaration != null) {
                        Node enclosingDeclaration;
                        if (NodeUtil.isLhsByDestructuring(n)) {
                            this.maybeUpdateName(t, n, nameDeclaration);
                            break;
                        }
                        if (nameDeclaration.getNode() == null || !Objects.equals(nameDeclaration.getNode().getInputId(), n.getInputId()) || (enclosingDeclaration = NodeUtil.getEnclosingNode(n, new Predicate<Node>(){

                            public boolean apply(Node node) {
                                return node == nameDeclaration.getNameNode();
                            }
                        })) != null && enclosingDeclaration != n && nameDeclaration.getScope() == t.getScope()) break;
                        this.maybeUpdateName(t, n, nameDeclaration);
                        break;
                    }
                    if (!n.getString().equals(ProcessCommonJSModules.MODULE) || n.getParent().isGetProp() || n.getParent().isGetElem() || n.getParent().isTypeOf()) break;
                    Node objectLit = IR.objectlit(new Node[0]).useSourceInfoFrom(n);
                    n.replaceWith(objectLit);
                    t.reportCodeChange(objectLit);
                    break;
                }
                case STRING_KEY: {
                    Var nameDeclaration;
                    if (n.hasChildren() || n.isQuotedString() || NodeUtil.isLhsByDestructuring(n) || (nameDeclaration = (Var)t.getScope().getVar(n.getString())) == null) break;
                    String importedName = this.getModuleImportName(t, nameDeclaration.getNode());
                    if (!nameDeclaration.isGlobal() && importedName == null) break;
                    Node value = IR.name(n.getString()).useSourceInfoFrom(n);
                    n.addChildToBack(value);
                    this.maybeUpdateName(t, value, nameDeclaration);
                    break;
                }
                case GETPROP: {
                    Var v;
                    if (n.matchesQualifiedName("module.id") || n.matchesQualifiedName("module.filename")) {
                        Var v2 = (Var)t.getScope().getVar(ProcessCommonJSModules.MODULE);
                        if (v2 != null && !v2.isExtern()) break;
                        n.replaceWith(IR.string(t.getInput().getPath().toString()).useSourceInfoFrom(n));
                        break;
                    }
                    if (!this.allowFullRewrite || !n.getFirstChild().isName() || !n.getFirstChild().getString().equals(ProcessCommonJSModules.MODULE) || n.matchesQualifiedName("module.exports") || (v = (Var)t.getScope().getVar(ProcessCommonJSModules.MODULE)) != null && !v.isExtern()) break;
                    n.getFirstChild().replaceWith(IR.objectlit(new Node[0]).useSourceInfoFrom(n.getFirstChild()));
                    break;
                }
                case TYPEOF: {
                    Var v;
                    if (!this.allowFullRewrite || !n.getFirstChild().isName() || !n.getFirstChild().getString().equals(ProcessCommonJSModules.MODULE) && !n.getFirstChild().getString().equals(ProcessCommonJSModules.EXPORTS) || (v = (Var)t.getScope().getVar(n.getFirstChild().getString())) != null && !v.isExtern()) break;
                    n.replaceWith(IR.string("object"));
                    break;
                }
            }
            this.fixTypeAnnotationsForNode(t, n);
        }

        private void fixTypeAnnotationsForNode(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String moduleName = ProcessCommonJSModules.this.getImportedModuleName(t, require);
            Node moduleRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, ProcessCommonJSModules.this.getBasePropertyImport(moduleName)).useSourceInfoFromForTree(require);
            parent.replaceChild(require, moduleRef);
            t.reportCodeChange();
        }

        private void visitExport(NodeTraversal t, ExportInfo export) {
            Node root = ProcessCommonJSModules.this.getBaseQualifiedNameNode(export.node);
            Node rValue = NodeUtil.getRValueOfLValue(root);
            if (root.matchesQualifiedName("module.exports") && rValue != null && rValue.isObjectLit() && root.getParent().isAssign() && root.getParent().getParent().isExprResult() && this.expandObjectLitAssignment(t, root, export.scope)) {
                return;
            }
            String moduleName = ProcessCommonJSModules.getModuleName(t.getInput());
            Var moduleInitialization = (Var)t.getScope().getVar(moduleName);
            Var rValueVar = null;
            if (rValue != null && rValue.isQualifiedName()) {
                rValueVar = (Var)export.scope.getVar(rValue.getQualifiedName());
            }
            if (root.getParent().isAssign() && root.getGrandparent().isExprResult() && root.getNext() != null && (root.getNext().isName() || root.getNext().isGetProp()) && root.getParent().getParent().isExprResult() && rValueVar != null && (NodeUtil.getEnclosingScript(rValueVar.nameNode) == null || rValueVar.nameNode.getParent() != null && !rValueVar.isParam()) && export.isInSupportedScope && (rValueVar.getNameNode().getParent() == null || !NodeUtil.isLhsByDestructuring(rValueVar.getNameNode()))) {
                root.getParent().getParent().detach();
                t.reportCodeChange();
                return;
            }
            moduleName = moduleName + "." + ProcessCommonJSModules.EXPORT_PROPERTY_NAME;
            Node updatedExport = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, moduleName, export.node, export.node.getQualifiedName());
            updatedExport.putBooleanProp((byte)97, true);
            boolean exportIsConst = this.defaultExportIsConst && updatedExport.matchesQualifiedName(ProcessCommonJSModules.this.getBasePropertyImport(ProcessCommonJSModules.getModuleName(t.getInput()))) && root == export.node && NodeUtil.isLValue(export.node);
            Node changeScope = null;
            if (root.matchesQualifiedName("module.exports") && rValue != null && export.scope.getVar("module.exports") == null && root.getParent().isAssign() && root.getGrandparent().isExprResult() && moduleInitialization == null) {
                Node parent = root.getParent();
                Node exportName = IR.exprResult(IR.assign(updatedExport, rValue.detach()));
                if (exportIsConst) {
                    JSDocInfoBuilder info = new JSDocInfoBuilder(false);
                    info.recordConstancy();
                    exportName.getFirstChild().setJSDocInfo(info.build());
                }
                parent.getParent().replaceWith(exportName.useSourceInfoFromForTree(root.getParent()));
                changeScope = NodeUtil.getEnclosingChangeScopeRoot(parent);
            } else if (root.getNext() != null && root.getNext().isName() && rValueVar != null && rValueVar.isGlobal() && export.isInSupportedScope && (rValueVar.getNameNode().getParent() == null || !NodeUtil.isLhsByDestructuring(rValueVar.getNameNode()))) {
                Node parent = root.getParent();
                root.detach();
                parent.replaceWith(root);
                if (root == export.node) {
                    root = updatedExport;
                }
                export.node.replaceWith(updatedExport);
                changeScope = NodeUtil.getEnclosingChangeScopeRoot(root);
            } else {
                export.node.replaceWith(updatedExport);
                if (updatedExport.getParent().isAssign() && exportIsConst) {
                    JSDocInfoBuilder infoBuilder = JSDocInfoBuilder.maybeCopyFrom(updatedExport.getParent().getJSDocInfo());
                    infoBuilder.recordConstancy();
                    updatedExport.getParent().setJSDocInfo(infoBuilder.build());
                }
                changeScope = NodeUtil.getEnclosingChangeScopeRoot(updatedExport);
            }
            if (changeScope != null) {
                ProcessCommonJSModules.this.compiler.reportChangeToChangeScope(changeScope);
            }
        }

        private boolean expandObjectLitAssignment(NodeTraversal t, Node export, Scope scope) {
            Preconditions.checkState((boolean)export.getParent().isAssign());
            Node insertionRef = export.getParent().getParent();
            Preconditions.checkState((boolean)insertionRef.isExprResult());
            Node insertionParent = insertionRef.getParent();
            Preconditions.checkNotNull((Object)insertionParent);
            Node rValue = NodeUtil.getRValueOfLValue(export);
            Node key = rValue.getFirstChild();
            boolean removedNodes = false;
            while (key != null) {
                if (!(key.isStringKey() && !key.isQuotedString() || key.isMemberFunctionDef())) {
                    key = key.getNext();
                    continue;
                }
                Node lhs = IR.getprop(export.cloneTree(), IR.string(key.getString()));
                Node value = null;
                if (key.isStringKey()) {
                    value = key.hasChildren() ? key.removeFirstChild() : IR.name(key.getString());
                } else if (key.isMemberFunctionDef()) {
                    value = key.getFirstChild().detach();
                }
                Node expr = null;
                expr = IR.exprResult(IR.assign(lhs, value)).useSourceInfoIfMissingFromForTree(key);
                insertionParent.addChildAfter(expr, insertionRef);
                ExportInfo newExport = new ExportInfo(lhs.getFirstChild(), scope);
                this.visitExport(t, newExport);
                if (expr != null && expr.getParent() != null) {
                    insertionRef = expr;
                }
                Node currentKey = key;
                key = key.getNext();
                currentKey.detach();
                removedNodes = true;
            }
            if (!rValue.hasChildren()) {
                export.getGrandparent().detach();
                return true;
            }
            if (removedNodes) {
                t.reportCodeChange(rValue);
            }
            return false;
        }

        private void maybeUpdateName(NodeTraversal t, Node n, Var var) {
            Preconditions.checkNotNull((Object)var);
            Preconditions.checkState((n.isName() || n.isGetProp() ? 1 : 0) != 0);
            Preconditions.checkState((n.getParent() != null ? 1 : 0) != 0);
            String importedModuleName = this.getModuleImportName(t, var.getNode());
            String name = n.getQualifiedName();
            if (importedModuleName != null && n != var.getNode()) {
                this.updateNameReference(t, n, name, importedModuleName, false, false);
            } else if (this.allowFullRewrite) {
                String exportedName = this.getExportedName(t, n, var);
                if (!(n == var.getNode() && !n.getParent().isClass() || exportedName != null || var != null && var.getNameNode().getParent() != null && NodeUtil.isLhsByDestructuring(var.getNameNode()))) {
                    if (n.getParent().isClass() && n.getParent().getFirstChild() == n) {
                        this.rewrittenClassExpressions.add(n.getParent());
                    }
                    return;
                }
                if (!(importedModuleName != null || exportedName == null || exportedName.equals(name) || var.isParam() || var.getNameNode().getParent() != null && NodeUtil.isLhsByDestructuring(var.getNameNode()))) {
                    boolean exportPropIsConst = this.defaultExportIsConst && ProcessCommonJSModules.this.getBasePropertyImport(ProcessCommonJSModules.getModuleName(t.getInput())).equals(exportedName) && ProcessCommonJSModules.this.getBaseQualifiedNameNode(n) == n && NodeUtil.isLValue(n);
                    this.updateNameReference(t, n, name, exportedName, true, exportPropIsConst);
                } else if (var.isGlobal()) {
                    String currentModuleName = ProcessCommonJSModules.getModuleName(t.getInput());
                    if (currentModuleName.equals(name)) {
                        return;
                    }
                    if (ProcessCommonJSModules.EXPORTS.equals(name)) {
                        return;
                    }
                    if (((ProcessCommonJSModules)ProcessCommonJSModules.this).compiler.getOptions().exportTestFunctions && currentModuleName.startsWith("test")) {
                        return;
                    }
                    String newName = name + "$$" + currentModuleName;
                    this.updateNameReference(t, n, name, newName, false, false);
                }
            }
        }

        private void updateNameReference(NodeTraversal t, Node nameRef, String originalName, String newName, boolean requireFunctionExpressions, boolean qualifiedNameIsConst) {
            Node parent = nameRef.getParent();
            Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)newName);
            boolean newNameIsQualified = newName.indexOf(46) >= 0;
            boolean newNameIsModuleExport = newName.equals(ProcessCommonJSModules.this.getBasePropertyImport(ProcessCommonJSModules.getModuleName(t.getInput())));
            Var newNameDeclaration = (Var)t.getScope().getVar(newName);
            switch (parent.getToken()) {
                case CLASS: {
                    if (parent.getIndexOfChild(nameRef) == 0 && (newNameIsQualified || requireFunctionExpressions)) {
                        Node expr;
                        this.rewrittenClassExpressions.add(parent);
                        Node newNameRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        if (newNameIsModuleExport) {
                            newNameRef.putBooleanProp((byte)97, true);
                        }
                        Node grandparent = parent.getParent();
                        if (!newNameIsQualified && newNameDeclaration == null) {
                            expr = IR.let(newNameRef, IR.nullNode()).useSourceInfoIfMissingFromForTree(nameRef);
                        } else {
                            expr = IR.exprResult(IR.assign(newNameRef, IR.nullNode())).useSourceInfoIfMissingFromForTree(nameRef);
                            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(parent.getJSDocInfo());
                            parent.setJSDocInfo(null);
                            if (qualifiedNameIsConst) {
                                info.recordConstancy();
                            }
                            expr.getFirstChild().setJSDocInfo(info.build());
                            this.fixTypeAnnotationsForNode(t, expr.getFirstChild());
                        }
                        grandparent.replaceChild(parent, expr);
                        if (expr.isLet()) {
                            expr.getFirstChild().replaceChild(expr.getFirstFirstChild(), parent);
                            break;
                        }
                        expr.getFirstChild().replaceChild(expr.getFirstChild().getSecondChild(), parent);
                        break;
                    }
                    if (parent.getIndexOfChild(nameRef) == 1) {
                        Node newNameRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        if (newNameIsModuleExport) {
                            newNameRef.putBooleanProp((byte)97, true);
                        }
                        parent.replaceChild(nameRef, newNameRef);
                        break;
                    }
                    nameRef.setString(newName);
                    nameRef.setOriginalName(originalName);
                    break;
                }
                case FUNCTION: {
                    if (newNameIsQualified || requireFunctionExpressions) {
                        if (NodeUtil.isFunctionExpression(parent)) {
                            return;
                        }
                        Node newNameRef = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        if (newNameIsModuleExport) {
                            newNameRef.putBooleanProp((byte)97, true);
                        }
                        Node grandparent = parent.getParent();
                        nameRef.setString("");
                        Node expr = !newNameIsQualified && newNameDeclaration == null ? IR.var(newNameRef, IR.nullNode()).useSourceInfoIfMissingFromForTree(nameRef) : IR.exprResult(IR.assign(newNameRef, IR.nullNode())).useSourceInfoIfMissingFromForTree(nameRef);
                        grandparent.replaceChild(parent, expr);
                        if (expr.isVar()) {
                            expr.getFirstChild().replaceChild(expr.getFirstFirstChild(), parent);
                        } else {
                            expr.getFirstChild().replaceChild(expr.getFirstChild().getSecondChild(), parent);
                            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(parent.getJSDocInfo());
                            parent.setJSDocInfo(null);
                            if (qualifiedNameIsConst) {
                                info.recordConstancy();
                            }
                            expr.getFirstChild().setJSDocInfo(info.build());
                            this.fixTypeAnnotationsForNode(t, expr.getFirstChild());
                        }
                        this.functionsToHoist.add(expr);
                        break;
                    }
                    nameRef.setString(newName);
                    nameRef.setOriginalName(originalName);
                    break;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    if (parent.hasMoreThanOneChild() && !NodeUtil.isAnyFor(parent.getParent())) {
                        this.splitMultipleDeclarations(parent);
                        parent = nameRef.getParent();
                        newNameDeclaration = (Var)t.getScope().getVar(newName);
                    }
                    if (newNameIsQualified) {
                        if (!nameRef.hasChildren() && parent.getJSDocInfo() == null) {
                            parent.detach();
                            break;
                        }
                        Node getProp = NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        if (newNameIsModuleExport) {
                            getProp.putBooleanProp((byte)97, true);
                        }
                        JSDocInfo info = parent.getJSDocInfo();
                        parent.setJSDocInfo(null);
                        if (nameRef.hasChildren()) {
                            Node assign = IR.assign(getProp, nameRef.removeFirstChild());
                            assign.setJSDocInfo(info);
                            Node expr = IR.exprResult(assign).useSourceInfoIfMissingFromForTree(nameRef);
                            parent.replaceWith(expr);
                            JSDocInfoBuilder infoBuilder = JSDocInfoBuilder.maybeCopyFrom(info);
                            parent.setJSDocInfo(null);
                            if (qualifiedNameIsConst) {
                                infoBuilder.recordConstancy();
                            }
                            assign.setJSDocInfo(infoBuilder.build());
                            this.fixTypeAnnotationsForNode(t, assign);
                            break;
                        }
                        getProp.setJSDocInfo(info);
                        parent.replaceWith(IR.exprResult(getProp).useSourceInfoFrom(getProp));
                        break;
                    }
                    if (newNameDeclaration != null && newNameDeclaration.getNameNode() != nameRef) {
                        if (!nameRef.hasChildren()) {
                            parent.detachFromParent();
                            break;
                        }
                        Node name = NodeUtil.newName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                        Node assign = IR.assign(name, nameRef.removeFirstChild());
                        JSDocInfo info = parent.getJSDocInfo();
                        if (info != null) {
                            parent.setJSDocInfo(null);
                            assign.setJSDocInfo(info);
                        }
                        parent.replaceWith(IR.exprResult(assign).useSourceInfoFromForTree(nameRef));
                        break;
                    }
                    nameRef.setString(newName);
                    nameRef.setOriginalName(originalName);
                    break;
                }
                default: {
                    JSDocInfo info;
                    Node name;
                    if (!newNameIsQualified && nameRef.isName()) {
                        nameRef.setString(newName);
                        nameRef.setOriginalName(originalName);
                        break;
                    }
                    Node node = name = newNameIsQualified ? NodeUtil.newQName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName) : NodeUtil.newName(ProcessCommonJSModules.this.compiler, newName, nameRef, originalName);
                    if (newNameIsModuleExport) {
                        name.putBooleanProp((byte)97, true);
                    }
                    if ((info = nameRef.getJSDocInfo()) != null) {
                        nameRef.setJSDocInfo(null);
                        name.setJSDocInfo(info);
                    }
                    parent.replaceChild(nameRef, name);
                    if (!nameRef.hasChildren()) break;
                    name.addChildrenToFront(nameRef.removeChildren());
                }
            }
            t.reportCodeChange();
        }

        private String getExportedName(NodeTraversal t, Node n, Var var) {
            if (var == null || !Objects.equals(var.getNode().getInputId(), n.getInputId())) {
                return n.getQualifiedName();
            }
            String baseExportName = ProcessCommonJSModules.this.getBasePropertyImport(ProcessCommonJSModules.getModuleName(t.getInput()));
            for (ExportInfo export : this.exports) {
                Node exportBase = ProcessCommonJSModules.this.getBaseQualifiedNameNode(export.node);
                Node exportRValue = NodeUtil.getRValueOfLValue(exportBase);
                if (exportRValue == null) continue;
                Node exportedName = this.getExportedNameNode(export);
                if (export.isInSupportedScope && (exportRValue == n || (NodeUtil.isClassExpression(exportRValue) || NodeUtil.isFunctionExpression(exportRValue)) && exportedName == n)) {
                    return null;
                }
                String exportBaseQName = exportBase.getQualifiedName();
                if (exportRValue.isObjectLit()) {
                    Node key;
                    if (!"module.exports".equals(exportBaseQName)) {
                        return n.getQualifiedName();
                    }
                    boolean keyIsExport = false;
                    for (key = exportRValue.getFirstChild(); key != null; key = key.getNext()) {
                        Var valVar;
                        if (!key.isStringKey() || key.isQuotedString() || !NodeUtil.isValidPropertyName(ProcessCommonJSModules.this.compiler.getOptions().getLanguageIn().toFeatureSet(), key.getString())) continue;
                        if (key.hasChildren()) {
                            if (!key.getFirstChild().isQualifiedName()) continue;
                            if (key.getFirstChild() == n) {
                                return null;
                            }
                            valVar = (Var)t.getScope().getVar(key.getFirstChild().getQualifiedName());
                            if (valVar == null || valVar.getNameNode() != var.getNameNode()) continue;
                            keyIsExport = true;
                            break;
                        }
                        if (key == n) {
                            return null;
                        }
                        valVar = (Var)t.getScope().getVar(key.getString());
                        if (valVar == null || valVar.getNameNode() != var.getNameNode()) continue;
                        keyIsExport = true;
                        break;
                    }
                    if (key == null || !keyIsExport) continue;
                    if (export.isInSupportedScope) {
                        return baseExportName + "." + key.getString();
                    }
                    return n.getQualifiedName();
                }
                if (!export.isInSupportedScope) {
                    return n.getQualifiedName();
                }
                if (var.getNameNode() != exportedName) continue;
                String exportPrefix = exportBaseQName.startsWith(ProcessCommonJSModules.MODULE) ? "module.exports" : ProcessCommonJSModules.EXPORTS;
                if (exportBaseQName.length() == exportPrefix.length()) {
                    return baseExportName;
                }
                return baseExportName + exportBaseQName.substring(exportPrefix.length());
            }
            return n.getQualifiedName();
        }

        private Node getExportedNameNode(ExportInfo info) {
            Node qNameBase = ProcessCommonJSModules.this.getBaseQualifiedNameNode(info.node);
            Node rValue = NodeUtil.getRValueOfLValue(qNameBase);
            if (rValue == null) {
                return null;
            }
            if (NodeUtil.isFunctionExpression(rValue)) {
                return rValue.getFirstChild();
            }
            if (NodeUtil.isClassExpression(rValue) && rValue.getFirstChild() == qNameBase) {
                return rValue.getFirstChild();
            }
            Var var = (Var)info.scope.getVar(rValue.getQualifiedName());
            if (var == null) {
                return null;
            }
            return var.getNameNode();
        }

        private String getModuleImportName(NodeTraversal t, Node n) {
            Node grandparent;
            Node rValue = null;
            String propSuffix = "";
            Node parent = n.getParent();
            if (parent != null && parent.isStringKey() && (grandparent = parent.getParent()).isObjectPattern() && grandparent.getParent().isDestructuringLhs()) {
                rValue = grandparent.getNext();
                propSuffix = "." + parent.getString();
            }
            if (propSuffix.isEmpty() && parent != null) {
                rValue = NodeUtil.getRValueOfLValue(n);
            }
            if (rValue == null) {
                return null;
            }
            if (rValue.isCall() && ProcessCommonJSModules.this.isCommonJsImport(rValue)) {
                return ProcessCommonJSModules.this.getBasePropertyImport(ProcessCommonJSModules.this.getImportedModuleName(t, rValue)) + propSuffix;
            }
            if (rValue.isGetProp() && ProcessCommonJSModules.this.isCommonJsImport(rValue.getFirstChild())) {
                String importName = ProcessCommonJSModules.this.getBasePropertyImport(ProcessCommonJSModules.this.getImportedModuleName(t, rValue.getFirstChild()));
                String suffix = rValue.getSecondChild().isGetProp() ? rValue.getSecondChild().getQualifiedName() : rValue.getSecondChild().getString();
                return importName + "." + suffix + propSuffix;
            }
            return null;
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                int endIndex;
                String name = typeNode.getString();
                if (ModuleLoader.isPathIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    String globalModuleName = ProcessCommonJSModules.this.getImportedModuleName(t, typeNode, moduleName);
                    String baseImportProperty = ProcessCommonJSModules.this.getBasePropertyImport(globalModuleName);
                    typeNode.setString(localTypeName == null ? baseImportProperty : baseImportProperty + localTypeName);
                } else {
                    String baseName;
                    boolean wasRewritten = false;
                    endIndex = -1;
                    while (endIndex < name.length()) {
                        String exportedName;
                        String suffix;
                        if ((endIndex = name.indexOf(46, endIndex + 1)) == -1) {
                            endIndex = name.length();
                        }
                        baseName = name.substring(0, endIndex);
                        String string = suffix = endIndex < name.length() ? name.substring(endIndex) : "";
                        Var typeDeclaration = (Var)t.getScope().getVar(baseName);
                        if (typeDeclaration == null || typeDeclaration.getNode() == null || !Objects.equals(typeDeclaration.getNode().getInputId(), typeNode.getInputId())) continue;
                        String importedModuleName = this.getModuleImportName(t, typeDeclaration.getNode());
                        if (importedModuleName != null) {
                            typeNode.setString(importedModuleName + suffix);
                            typeNode.setOriginalName(name);
                            wasRewritten = true;
                            break;
                        }
                        if (!this.allowFullRewrite || (exportedName = this.getExportedName(t, typeNode, typeDeclaration)) == null || exportedName.equals(name)) continue;
                        typeNode.setString(exportedName + suffix);
                        typeNode.setOriginalName(name);
                        wasRewritten = true;
                        break;
                    }
                    if (!wasRewritten && this.allowFullRewrite) {
                        endIndex = name.indexOf(46);
                        if (endIndex == -1) {
                            endIndex = name.length();
                        }
                        baseName = name.substring(0, endIndex);
                        Var typeDeclaration = (Var)t.getScope().getVar(baseName);
                        if (typeDeclaration != null && typeDeclaration.isGlobal()) {
                            String moduleName = ProcessCommonJSModules.getModuleName(t.getInput());
                            String newName = baseName + "$$" + moduleName;
                            if (endIndex < name.length()) {
                                newName = newName + name.substring(endIndex);
                            }
                            typeNode.setString(newName);
                            typeNode.setOriginalName(name);
                        }
                    }
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }

        private List<Node> splitMultipleDeclarations(Node var) {
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(var));
            ArrayList<Node> vars = new ArrayList<Node>();
            JSDocInfo info = var.getJSDocInfo();
            while (var.getSecondChild() != null) {
                Node newVar = new Node(var.getToken(), var.removeFirstChild());
                if (info != null) {
                    newVar.setJSDocInfo(info.clone());
                }
                newVar.useSourceInfoFrom(var);
                var.getParent().addChildBefore(newVar, var);
                vars.add(newVar);
            }
            vars.add(var);
            return vars;
        }
    }

    class FindImportsAndExports
    implements NodeTraversal.Callback,
    ErrorHandler {
        private boolean hasGoogProvideOrModule = false;
        private Node script = null;
        List<UmdPattern> umdPatterns = new ArrayList<UmdPattern>();
        List<ExportInfo> moduleExports = new ArrayList<ExportInfo>();
        List<ExportInfo> exports = new ArrayList<ExportInfo>();
        List<JSError> errors = new ArrayList<JSError>();

        FindImportsAndExports() {
        }

        boolean isCommonJsModule() {
            return (this.exports.size() > 0 || this.moduleExports.size() > 0) && !this.hasGoogProvideOrModule;
        }

        @Override
        public void report(CheckLevel ignoredLevel, JSError error) {
            this.errors.add(error);
        }

        public List<ExportInfo> getModuleExports() {
            return ImmutableList.copyOf(this.moduleExports);
        }

        public List<ExportInfo> getExports() {
            return ImmutableList.copyOf(this.exports);
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isScript()) {
                Preconditions.checkState((this.script == null ? 1 : 0) != 0);
                this.script = n;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            UmdPattern existingPattern;
            UmdTestInfo umdTestAncestor;
            Node maybeGetProp;
            if (t.inGlobalScope() && (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) && n.isExprResult() && (maybeGetProp = n.getFirstFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                this.hasGoogProvideOrModule = true;
            }
            if (n.isCall() && n.getFirstChild().matchesQualifiedName("require.ensure")) {
                this.visitRequireEnsureCall(t, n);
            }
            if (n.matchesQualifiedName("module.exports") || n.isGetElem() && n.getFirstChild().matchesQualifiedName(ProcessCommonJSModules.MODULE) && n.getSecondChild().isString() && n.getSecondChild().getString().equals(ProcessCommonJSModules.EXPORTS)) {
                if (ProcessCommonJSModules.this.isCommonJsExport(t, n)) {
                    this.moduleExports.add(new ExportInfo(n, t.getScope()));
                    umdTestAncestor = this.getOutermostUmdTest(parent);
                    if (umdTestAncestor != null && !this.isInIfTest(n) && (existingPattern = ProcessCommonJSModules.findUmdPattern(this.umdPatterns, umdTestAncestor.enclosingIf)) == null) {
                        this.umdPatterns.add(new UmdPattern(umdTestAncestor.enclosingIf, umdTestAncestor.activeBranch));
                    }
                }
            } else if ((n.matchesQualifiedName("define.amd") || n.matchesQualifiedName("window.define.amd")) && (umdTestAncestor = this.getOutermostUmdTest(parent)) != null && this.isInIfTest(n) && (existingPattern = ProcessCommonJSModules.findUmdPattern(this.umdPatterns, umdTestAncestor.enclosingIf)) == null && umdTestAncestor.enclosingIf.getChildAtIndex(2) == null) {
                this.umdPatterns.add(new UmdPattern(umdTestAncestor.enclosingIf, null));
            }
            if (n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString())) {
                Var v = (Var)t.getScope().getVar(ProcessCommonJSModules.EXPORTS);
                if (v == null || v.isGlobal()) {
                    Node qNameRoot = ProcessCommonJSModules.this.getBaseQualifiedNameNode(n);
                    if (qNameRoot != null && qNameRoot.matchesQualifiedName(ProcessCommonJSModules.EXPORTS) && NodeUtil.isLValue(qNameRoot)) {
                        if (n.getGrandparent().isExprResult() && n.getNext() != null && (n.getNext().isGetProp() && n.getNext().matchesQualifiedName("module.exports") || n.getNext().isAssign() && n.getNext().getFirstChild().matchesQualifiedName("module.exports"))) {
                            this.exports.add(new ExportInfo(n, t.getScope()));
                        } else if (!this.hasGoogProvideOrModule && (v == null || v.getNameNode() == null && v.getNameNode().getFirstChild() != n)) {
                            this.errors.add(t.makeError(qNameRoot, SUSPICIOUS_EXPORTS_ASSIGNMENT, new String[0]));
                        }
                    } else {
                        UmdPattern existingPattern2;
                        this.exports.add(new ExportInfo(n, t.getScope()));
                        UmdTestInfo umdTestAncestor2 = this.getOutermostUmdTest(parent);
                        if (umdTestAncestor2 != null && !this.isInIfTest(n) && (existingPattern2 = ProcessCommonJSModules.findUmdPattern(this.umdPatterns, umdTestAncestor2.enclosingIf)) == null) {
                            this.umdPatterns.add(new UmdPattern(umdTestAncestor2.enclosingIf, umdTestAncestor2.activeBranch));
                        }
                    }
                }
            } else if (n.isThis() && n.getParent().isGetProp() && t.inGlobalScope()) {
                this.exports.add(new ExportInfo(n, t.getScope()));
            }
            if (ProcessCommonJSModules.this.isCommonJsImport(n)) {
                this.visitRequireCall(t, n, parent);
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            if (!NodeUtil.isExpressionResultUsed(require) && parent.isExprResult() && NodeUtil.isStatementBlock(parent.getParent())) {
                t.getInput().getPath().resolveJsModule(ProcessCommonJSModules.this.getCommonJsImportPath(require), require.getSourceFileName(), require.getLineno(), require.getCharno());
                Node grandparent = parent.getParent();
                parent.detach();
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(grandparent);
            }
        }

        private void visitRequireEnsureCall(NodeTraversal t, Node call) {
            if (call.getChildCount() != 3) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(call, UNKNOWN_REQUIRE_ENSURE, "Expected the function to have 2 arguments but instead found {0}", "" + call.getChildCount()));
                return;
            }
            Node dependencies = call.getSecondChild();
            if (!dependencies.isArrayLit()) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(dependencies, UNKNOWN_REQUIRE_ENSURE, "The first argument must be an array literal of string literals."));
                return;
            }
            for (Node dep : dependencies.children()) {
                if (dep.isString()) continue;
                ProcessCommonJSModules.this.compiler.report(t.makeError(dep, UNKNOWN_REQUIRE_ENSURE, "The first argument must be an array literal of string literals."));
                return;
            }
            Node callback = dependencies.getNext();
            if (!(callback.isFunction() && callback.getSecondChild().getChildCount() == 1 && callback.getSecondChild().getFirstChild().isName() && ProcessCommonJSModules.REQUIRE.equals(callback.getSecondChild().getFirstChild().getString()))) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(callback, UNKNOWN_REQUIRE_ENSURE, "The second argument must be a function whose first argument is named \"require\"."));
                return;
            }
            callback.detach();
            callback.getSecondChild().removeChildren();
            call.removeChildren();
            call.putBooleanProp((byte)50, true);
            call.addChildToFront(callback);
            t.reportCodeChange();
        }

        void reportModuleErrors() {
            for (JSError error : this.errors) {
                ProcessCommonJSModules.this.compiler.report(error);
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean initializeModule() {
            void var6_10;
            CompilerInput ci = ProcessCommonJSModules.this.compiler.getInput(this.script.getInputId());
            ModuleLoader.ModulePath modulePath = ci.getPath();
            if (modulePath == null) {
                return true;
            }
            String moduleName = ProcessCommonJSModules.getModuleName(ci);
            ArrayList<ExportInfo> exportsToRemove = new ArrayList<ExportInfo>();
            for (ExportInfo exportInfo : this.exports) {
                if (NodeUtil.getEnclosingScript(exportInfo.node) == null) {
                    exportsToRemove.add(exportInfo);
                    continue;
                }
                Node qNameBase = ProcessCommonJSModules.this.getBaseQualifiedNameNode(exportInfo.node);
                if (exportInfo.node == qNameBase && exportInfo.node.getParent().isAssign() && exportInfo.node.getGrandparent().isExprResult() && exportInfo.node.getPrevious() == null && exportInfo.node.getNext() != null) {
                    if (exportInfo.node.getNext().isGetProp() && exportInfo.node.getNext().matchesQualifiedName("module.exports")) {
                        for (ExportInfo moduleExport : this.moduleExports) {
                            if (moduleExport.node != exportInfo.node.getNext()) continue;
                            this.moduleExports.remove(moduleExport);
                            break;
                        }
                        Node changeRoot = exportInfo.node.getGrandparent().getParent();
                        exportInfo.node.getGrandparent().detach();
                        exportsToRemove.add(exportInfo);
                        ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(changeRoot);
                        continue;
                    }
                    if (!exportInfo.node.getNext().isAssign() || !exportInfo.node.getNext().getFirstChild().matchesQualifiedName("module.exports")) continue;
                    Node assign = exportInfo.node.getNext();
                    exportInfo.node.getParent().replaceWith(assign.detach());
                    exportsToRemove.add(exportInfo);
                    ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(assign);
                    continue;
                }
                if (!exportInfo.node.getParent().isGetElem() || !exportInfo.node.getNext().isString() || !exportInfo.node.getNext().getString().equals(ProcessCommonJSModules.EXPORT_PROPERTY_NAME) || !exportInfo.node.getGrandparent().isAssign() || exportInfo.node.getParent().getPrevious() == null || !exportInfo.node.getParent().getPrevious().matchesQualifiedName("module.exports")) continue;
                Node parent = exportInfo.node.getParent();
                Node grandparent = parent.getParent();
                Node prop = exportInfo.node.getNext();
                parent.replaceWith(IR.getprop(exportInfo.node.detach(), prop.detach()).useSourceInfoFrom(parent));
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(grandparent);
            }
            this.exports.removeAll(exportsToRemove);
            exportsToRemove.clear();
            HashMap<ExportInfo, ExportInfo> exportsToReplace = new HashMap<ExportInfo, ExportInfo>();
            for (ExportInfo export : this.moduleExports) {
                if (NodeUtil.getEnclosingScript(export.node) == null) {
                    exportsToRemove.add(export);
                    continue;
                }
                if (!export.node.isGetElem()) continue;
                Node prop = export.node.getSecondChild().detach();
                ExportInfo newExport = new ExportInfo(IR.getprop(export.node.getFirstChild().detach(), prop), export.scope);
                export.node.replaceWith(newExport.node);
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(newExport.node);
                exportsToReplace.put(export, newExport);
            }
            this.moduleExports.removeAll(exportsToRemove);
            for (Object oldExport : exportsToReplace.keySet()) {
                int oldIndex = this.moduleExports.indexOf(oldExport);
                this.moduleExports.remove(oldIndex);
                this.moduleExports.add(oldIndex, (ExportInfo)exportsToReplace.get(oldExport));
            }
            boolean bl = false;
            block4: for (ExportInfo export : this.moduleExports) {
                Node base;
                if (NodeUtil.getEnclosingScript(export.node) == null || (base = ProcessCommonJSModules.this.getBaseQualifiedNameNode(export.node)) != export.node || !export.node.getParent().isAssign()) continue;
                Node rValue = NodeUtil.getRValueOfLValue(export.node);
                if (rValue == null || !rValue.isObjectLit()) {
                    ++var6_10;
                    continue;
                }
                if (!rValue.isObjectLit()) continue;
                for (Node key = rValue.getFirstChild(); key != null; key = key.getNext()) {
                    if (key.isStringKey() && !key.isQuotedString() || key.isMemberFunctionDef()) continue;
                    ++var6_10;
                    continue block4;
                }
            }
            Node initModule = IR.var(IR.name(moduleName), IR.objectlit(new Node[0]));
            initModule.getFirstChild().putBooleanProp((byte)97, true);
            JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
            builder.recordConstancy();
            initModule.setJSDocInfo(builder.build());
            if (var6_10 == false || !this.exports.isEmpty() && !this.moduleExports.isEmpty()) {
                Node defaultProp = IR.stringKey(ProcessCommonJSModules.EXPORT_PROPERTY_NAME);
                defaultProp.putBooleanProp((byte)97, true);
                defaultProp.addChildToFront(IR.objectlit(new Node[0]));
                initModule.getFirstFirstChild().addChildToFront(defaultProp);
                if (this.exports.isEmpty() || this.moduleExports.isEmpty()) {
                    builder = new JSDocInfoBuilder(true);
                    builder.recordConstancy();
                    defaultProp.setJSDocInfo(builder.build());
                }
            }
            this.script.addChildToFront(initModule.useSourceInfoFromForTree(this.script));
            ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(this.script);
            return var6_10 < 2 && (this.exports.isEmpty() || this.moduleExports.isEmpty());
        }

        private UmdTestInfo getOutermostUmdTest(Node n) {
            if (n == null || NodeUtil.isTopLevel(n) || n.isFunction()) {
                return null;
            }
            Node parent = n.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.isIf() || parent.isHook()) {
                UmdTestInfo umdTestInfo = this.getOutermostUmdTest(parent);
                if (umdTestInfo != null) {
                    if (parent.isIf() && parent.getSecondChild() == n && parent.getParent() != null && parent.getParent().isBlock() && parent.getNext() == null && umdTestInfo.activeBranch == parent.getParent()) {
                        return new UmdTestInfo(umdTestInfo.enclosingIf, n);
                    }
                    return umdTestInfo;
                }
                final ArrayList<Node> umdTests = new ArrayList<Node>();
                NodeUtil.visitPreOrder(parent.getFirstChild(), new NodeUtil.Visitor(){

                    @Override
                    public void visit(Node node) {
                        if (node.isName() && (node.getString().equals(ProcessCommonJSModules.MODULE) || node.getString().equals("define")) || node.isGetProp() && node.matchesQualifiedName("window.define") || node.isString() && node.getString().equals("amd") && node.getParent().isIn()) {
                            umdTests.add(node);
                        }
                    }
                });
                if (umdTests.isEmpty() && parent.getFirstChild().isTrue()) {
                    umdTests.add(parent.getFirstChild());
                }
                if (!umdTests.isEmpty()) {
                    return new UmdTestInfo(parent, n);
                }
                return null;
            }
            return this.getOutermostUmdTest(parent);
        }

        private boolean isInIfTest(Node n) {
            if (n == null || NodeUtil.isTopLevel(n) || n.isFunction()) {
                return false;
            }
            Node parent = n.getParent();
            if (parent == null) {
                return false;
            }
            if ((parent.isIf() || parent.isHook()) && parent.getFirstChild() == n) {
                return true;
            }
            return this.isInIfTest(parent);
        }

        boolean replaceUmdPatterns() {
            boolean needsRetraverse = false;
            for (UmdPattern umdPattern : this.umdPatterns) {
                Node callRoot;
                CompilerInput ci;
                ModuleLoader.ModulePath modulePath;
                Node block;
                if (NodeUtil.getEnclosingScript(umdPattern.ifRoot) == null) {
                    ProcessCommonJSModules.this.reportNestedScopesDeleted(umdPattern.ifRoot);
                    continue;
                }
                Node parent = umdPattern.ifRoot.getParent();
                Node newNode = umdPattern.activeBranch;
                if (newNode == null) {
                    parent.removeChild(umdPattern.ifRoot);
                    ProcessCommonJSModules.this.reportNestedScopesDeleted(umdPattern.ifRoot);
                    ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(parent);
                    needsRetraverse = true;
                    continue;
                }
                if (umdPattern.activeBranch.isBlock() && umdPattern.activeBranch.getChildCount() == 1) {
                    newNode = umdPattern.activeBranch.removeFirstChild();
                } else {
                    newNode.detach();
                }
                needsRetraverse = true;
                parent.replaceChild(umdPattern.ifRoot, newNode);
                ProcessCommonJSModules.this.reportNestedScopesDeleted(umdPattern.ifRoot);
                Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(newNode);
                if (changeScope != null) {
                    ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(newNode);
                }
                if ((block = parent).isExprResult()) {
                    block = block.getParent();
                }
                if (!block.isBlock() || !block.getParent().isFunction() || !block.getGrandparent().isCall() || !parent.hasOneChild()) continue;
                Node enclosingFnCall = block.getGrandparent();
                Node fn = block.getParent();
                Node enclosingScript = NodeUtil.getEnclosingScript(enclosingFnCall);
                if (enclosingScript == null || (modulePath = (ci = ProcessCommonJSModules.this.compiler.getInput(NodeUtil.getEnclosingScript(enclosingFnCall).getInputId())).getPath()) == null) continue;
                needsRetraverse = true;
                String factoryLabel = modulePath.toModuleName() + "_factory" + (String)ProcessCommonJSModules.this.compiler.getUniqueNameIdSupplier().get();
                FunctionToBlockMutator mutator = new FunctionToBlockMutator(ProcessCommonJSModules.this.compiler, ProcessCommonJSModules.this.compiler.getUniqueNameIdSupplier());
                Node newStatements = mutator.mutateWithoutRenaming(factoryLabel, fn, enclosingFnCall, null, false, false);
                if (newStatements.isBlock() && newStatements.hasTwoChildren() && newStatements.getFirstChild().isVar() && newStatements.getFirstFirstChild().hasOneChild() && newStatements.getFirstFirstChild().getFirstChild().isFunction() && newStatements.getSecondChild().isExprResult()) {
                    Node inlinedFn = newStatements.getFirstFirstChild().getFirstChild();
                    Node expr = newStatements.getSecondChild().getFirstChild();
                    Node call = null;
                    String assignedName = null;
                    if (expr.isAssign() && expr.getSecondChild().isCall()) {
                        call = expr.getSecondChild();
                        assignedName = modulePath.toModuleName() + "_iife" + (String)ProcessCommonJSModules.this.compiler.getUniqueNameIdSupplier().get();
                    } else if (expr.isCall()) {
                        call = expr;
                    }
                    if (call != null) {
                        newStatements = mutator.mutateWithoutRenaming(factoryLabel, inlinedFn, call, assignedName, false, false);
                        if (assignedName != null) {
                            Node newName = IR.var(NodeUtil.newName(ProcessCommonJSModules.this.compiler, assignedName, fn, expr.getFirstChild().getQualifiedName())).useSourceInfoFromForTree(fn);
                            if (newStatements.hasChildren() && newStatements.getFirstChild().isExprResult() && newStatements.getFirstFirstChild().isAssign() && newStatements.getFirstFirstChild().getFirstChild().isName() && newStatements.getFirstFirstChild().getFirstChild().getString().equals(assignedName)) {
                                newName.getFirstChild().addChildToFront(newStatements.getFirstFirstChild().getSecondChild().detach());
                                newStatements.replaceChild(newStatements.getFirstChild(), newName);
                            } else {
                                newStatements.addChildToFront(newName);
                            }
                            expr.replaceChild(expr.getSecondChild(), newName.getFirstChild().cloneNode());
                            newStatements.addChildToBack(expr.getParent().detach());
                        }
                    }
                }
                if ((callRoot = enclosingFnCall.getParent()).isNot()) {
                    callRoot = callRoot.getParent();
                }
                if (callRoot.isExprResult()) {
                    Node callRootParent = callRoot.getParent();
                    callRootParent.addChildrenAfter(newStatements.removeChildren(), callRoot);
                    callRoot.detach();
                    ProcessCommonJSModules.this.reportNestedScopesChanged(callRootParent);
                    ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(callRootParent);
                    ProcessCommonJSModules.this.reportNestedScopesDeleted(enclosingFnCall);
                    continue;
                }
                parent.replaceChild(umdPattern.ifRoot, newNode);
                ProcessCommonJSModules.this.compiler.reportChangeToEnclosingScope(newNode);
                ProcessCommonJSModules.this.reportNestedScopesDeleted(umdPattern.ifRoot);
            }
            return needsRetraverse;
        }

        private class UmdTestInfo {
            public Node enclosingIf;
            public Node activeBranch;

            UmdTestInfo(Node enclosingIf, Node activeBranch) {
                this.enclosingIf = enclosingIf;
                this.activeBranch = activeBranch;
            }
        }
    }

    static class ExportInfo {
        final Node node;
        final Scope scope;
        final boolean isInSupportedScope;

        ExportInfo(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
            Node disqualifyingParent = NodeUtil.getEnclosingNode(node, (Predicate<Node>)((Predicate)n -> n.isIf() || n.isHook() || n.isFunction() || n.isArrowFunction()));
            this.isInSupportedScope = disqualifyingParent == null;
        }
    }

    static class UmdPattern {
        final Node ifRoot;
        final Node activeBranch;

        UmdPattern(Node ifRoot, Node activeBranch) {
            this.ifRoot = ifRoot;
            this.activeBranch = activeBranch;
        }
    }
}

