/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.Map;

class MoveFunctionDeclarations
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final ListMultimap<JSModule, Node> functions;

    MoveFunctionDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functions = ArrayListMultimap.create();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Map.Entry entry : Multimaps.asMap(this.functions).entrySet()) {
            Node addingRoot = this.compiler.getNodeForCodeInsertion((JSModule)entry.getKey());
            List fnNodes = Lists.reverse((List)((List)entry.getValue()));
            if (fnNodes.isEmpty()) continue;
            for (Node n : fnNodes) {
                Node nameNode = n.getFirstChild();
                String name = nameNode.getString();
                nameNode.setString("");
                addingRoot.addChildToFront(IR.var(IR.name(name), n).useSourceInfoIfMissingFromForTree(n));
                this.compiler.reportChangeToEnclosingScope(nameNode);
            }
            this.compiler.reportChangeToEnclosingScope(addingRoot);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        Node grandparent = n.getAncestor(2);
        return grandparent == null || !grandparent.isScript();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent == null || !parent.isScript()) {
            return;
        }
        if (NodeUtil.isFunctionDeclaration(n)) {
            parent.removeChild(n);
            this.compiler.reportChangeToEnclosingScope(parent);
            this.functions.put((Object)t.getModule(), (Object)n);
        }
    }
}

