/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.Instrumentation;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.List;

class InstrumentFunctions
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final FunctionNames functionNames;
    private final String appNameStr;
    private final String initCodeSource;
    private final String definedFunctionName;
    private final String reportFunctionName;
    private final String reportFunctionExitName;
    private final String appNameSetter;
    private final List<String> declarationsToRemove;

    InstrumentFunctions(AbstractCompiler compiler, FunctionNames functionNames, Instrumentation template, String appNameStr) {
        this.compiler = compiler;
        this.functionNames = functionNames;
        this.appNameStr = appNameStr;
        StringBuilder initCodeSourceBuilder = new StringBuilder();
        for (String line : template.getInitList()) {
            initCodeSourceBuilder.append(line).append("\n");
        }
        this.initCodeSource = initCodeSourceBuilder.toString();
        this.definedFunctionName = template.getReportDefined();
        this.reportFunctionName = template.getReportCall();
        this.reportFunctionExitName = template.getReportExit();
        this.appNameSetter = template.getAppNameSetter();
        this.declarationsToRemove = ImmutableList.copyOf(template.getDeclarationToRemoveList());
    }

    @Override
    public void process(Node externs, Node root) {
        Node initCode = null;
        if (!this.initCodeSource.isEmpty()) {
            Node initCodeRoot = this.compiler.parseSyntheticCode("template:init", this.initCodeSource);
            if (initCodeRoot != null && initCodeRoot.getFirstChild() != null) {
                NodeUtil.markNewScopesChanged(initCodeRoot, this.compiler);
                initCode = initCodeRoot.removeChildren();
            } else {
                return;
            }
        }
        NodeTraversal.traverse(this.compiler, root, new RemoveCallback(this.declarationsToRemove));
        NodeTraversal.traverse(this.compiler, root, new InstrumentCallback());
        if (!this.appNameSetter.isEmpty()) {
            Node call = IR.call(IR.name(this.appNameSetter), IR.string(this.appNameStr));
            call.putBooleanProp((byte)50, true);
            Node expr = IR.exprResult(call);
            Node addingRoot = this.compiler.getNodeForCodeInsertion(null);
            addingRoot.addChildToFront(expr.useSourceInfoIfMissingFromForTree(addingRoot));
            this.compiler.reportChangeToEnclosingScope(addingRoot);
        }
        if (initCode != null) {
            Node addingRoot = this.compiler.getNodeForCodeInsertion(null);
            addingRoot.addChildrenToFront(initCode);
            this.compiler.reportChangeToEnclosingScope(addingRoot);
        }
    }

    private class InstrumentCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private InstrumentCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isFunction()) {
                return;
            }
            int id = InstrumentFunctions.this.functionNames.getFunctionId(n);
            if (id < 0) {
                return;
            }
            String name = InstrumentFunctions.this.functionNames.getFunctionName(n);
            if (!InstrumentFunctions.this.reportFunctionName.isEmpty()) {
                Node body = n.getLastChild();
                Node call = IR.call(IR.name(InstrumentFunctions.this.reportFunctionName), IR.number(id), IR.string(name), IR.name("arguments"));
                call.putBooleanProp((byte)50, true);
                Node expr = IR.exprResult(call);
                expr.useSourceInfoFromForTree(n);
                body.addChildToFront(expr);
                t.reportCodeChange();
            }
            if (!InstrumentFunctions.this.reportFunctionExitName.isEmpty()) {
                new InstrumentReturns(id, name).process(n);
            }
            if (!InstrumentFunctions.this.definedFunctionName.isEmpty()) {
                Node call = IR.call(IR.name(InstrumentFunctions.this.definedFunctionName), IR.number(id), IR.string(name));
                call.putBooleanProp((byte)50, true);
                call.useSourceInfoFromForTree(n);
                Node expr = NodeUtil.newExpr(call);
                Node addingRoot = null;
                if (NodeUtil.isFunctionDeclaration(n)) {
                    JSModule module = t.getModule();
                    addingRoot = InstrumentFunctions.this.compiler.getNodeForCodeInsertion(module);
                    addingRoot.addChildToFront(expr);
                } else {
                    Node beforeChild = n;
                    for (Node ancestor : n.getAncestors()) {
                        Token type = ancestor.getToken();
                        if (type == Token.BLOCK || type == Token.SCRIPT) {
                            addingRoot = ancestor;
                            break;
                        }
                        beforeChild = ancestor;
                    }
                    addingRoot.addChildBefore(expr, beforeChild);
                }
                InstrumentFunctions.this.compiler.reportChangeToEnclosingScope(addingRoot);
            }
        }
    }

    private class InstrumentReturns
    implements NodeTraversal.Callback {
        private final int functionId;
        private final String functionName;

        InstrumentReturns(int functionId, String functionName) {
            this.functionId = functionId;
            this.functionName = functionName;
        }

        void process(Node function) {
            Node body = function.getLastChild();
            NodeTraversal.traverse(InstrumentFunctions.this.compiler, body, this);
            if (!this.allPathsReturn(function)) {
                Node call = this.newReportFunctionExitNode(function, null);
                Node expr = IR.exprResult(call).useSourceInfoIfMissingFromForTree(function);
                body.addChildToBack(expr);
                InstrumentFunctions.this.compiler.reportChangeToEnclosingScope(body);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isReturn()) {
                return;
            }
            Node returnRhs = n.removeFirstChild();
            Node call = this.newReportFunctionExitNode(n, returnRhs);
            n.addChildToFront(call);
            t.reportCodeChange();
        }

        private Node newReportFunctionExitNode(Node infoNode, Node returnRhs) {
            Node call = IR.call(IR.name(InstrumentFunctions.this.reportFunctionExitName), IR.number(this.functionId), returnRhs != null ? returnRhs : IR.name("undefined"), IR.string(this.functionName));
            call.putBooleanProp((byte)50, true);
            call.useSourceInfoFromForTree(infoNode);
            return call;
        }

        private boolean allPathsReturn(Node function) {
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(InstrumentFunctions.this.compiler, false, false);
            cfa.process(null, function);
            ControlFlowGraph<Node> cfg = cfa.getCfg();
            Node returnPathsParent = (Node)cfg.getImplicitReturn().getValue();
            for (DiGraph.DiGraphNode pred : cfg.getDirectedPredNodes(returnPathsParent)) {
                Node n = (Node)pred.getValue();
                if (n.isReturn()) continue;
                return false;
            }
            return true;
        }
    }

    private static class RemoveCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final List<String> removable;

        RemoveCallback(List<String> removable) {
            this.removable = removable;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isNameDeclaration(parent) && n.isName() && this.removable.contains(n.getString())) {
                parent.removeChild(n);
                if (!parent.hasChildren()) {
                    parent.detach();
                }
            }
        }
    }
}

