/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ExternExportsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final List<Export> exports = new ArrayList<Export>();
    private final Map<String, Node> definitionMap;
    private final AbstractCompiler compiler;
    private final Node externsRoot;
    private final Map<String, String> mappedPaths;
    private final Set<String> alreadyExportedPaths;
    private List<String> exportSymbolFunctionNames;
    private List<String> exportPropertyFunctionNames;

    ExternExportsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.definitionMap = new HashMap<String, Node>();
        this.externsRoot = IR.script();
        this.alreadyExportedPaths = new HashSet<String>();
        this.mappedPaths = new HashMap<String, String>();
        this.initExportMethods();
    }

    private void initExportMethods() {
        this.exportSymbolFunctionNames = new ArrayList<String>();
        this.exportPropertyFunctionNames = new ArrayList<String>();
        CodingConvention convention = this.compiler.getCodingConvention();
        this.exportSymbolFunctionNames.add(convention.getExportSymbolFunction());
        this.exportPropertyFunctionNames.add(convention.getExportPropertyFunction());
        this.exportSymbolFunctionNames.add("google_exportSymbol");
        this.exportPropertyFunctionNames.add("google_exportProperty");
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TreeSet<Export> sorted = new TreeSet<Export>(new Comparator<Export>(){

            @Override
            public int compare(Export e1, Export e2) {
                return e1.getExportedPath().compareTo(e2.getExportedPath());
            }
        });
        sorted.addAll(this.exports);
        for (Export export : sorted) {
            export.generateExterns();
        }
        this.setGeneratedExternsOnCompiler();
    }

    private void setGeneratedExternsOnCompiler() {
        CodePrinter.Builder builder = new CodePrinter.Builder(this.externsRoot).setPrettyPrint(true).setOutputTypes(true).setTypeRegistry(this.compiler.getTypeRegistry());
        this.compiler.setExternExports(Joiner.on((String)"\n").join((Object)"/**", (Object)" * @fileoverview Generated externs.", new Object[]{" * @externs", " */", builder.build()}));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: 
            case GETPROP: {
                JSDocInfo jsdoc;
                String name = n.getQualifiedName();
                if (name == null) {
                    return;
                }
                if (parent.isAssign() || parent.isVar() || parent.isFunction()) {
                    this.definitionMap.put(name, parent);
                }
                if ((jsdoc = NodeUtil.getBestJSDocInfo(n)) != null && jsdoc.isExport()) {
                    this.handleExportDefinition(t, n);
                }
                if (!parent.isCall()) {
                    return;
                }
                if (this.exportPropertyFunctionNames.contains(name)) {
                    this.handlePropertyExportCall(parent);
                }
                if (!this.exportSymbolFunctionNames.contains(name)) break;
                this.handleSymbolExportCall(parent);
                break;
            }
        }
    }

    private void handleSymbolExportCall(Node parent) {
        if (parent.getChildCount() != 3) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node nameArg = thisNode.getNext();
        Node valueArg = nameArg.getNext();
        if (!nameArg.isString()) {
            return;
        }
        this.exports.add(new SymbolExport(nameArg.getString(), valueArg));
    }

    private void handlePropertyExportCall(Node parent) {
        if (parent.getChildCount() != 4) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node objectArg = thisNode.getNext();
        Node nameArg = objectArg.getNext();
        Node valueArg = nameArg.getNext();
        if (!objectArg.isQualifiedName()) {
            return;
        }
        if (!nameArg.isString()) {
            return;
        }
        this.exports.add(new PropertyExport(objectArg.getQualifiedName(), nameArg.getString(), valueArg));
    }

    private void handleExportDefinition(NodeTraversal t, Node definitionNode) {
        if (!definitionNode.isGetProp() || !definitionNode.getFirstChild().isThis()) {
            return;
        }
        Node constructorNode = t.getEnclosingFunction();
        JSDocInfo constructorJsdoc = NodeUtil.getBestJSDocInfo(constructorNode);
        if (constructorJsdoc == null || !constructorJsdoc.isConstructor()) {
            return;
        }
        String constructorName = NodeUtil.getName(constructorNode);
        String propertyName = definitionNode.getLastChild().getString();
        String prototypeName = constructorName + ".prototype";
        Node propertyNameNode = NodeUtil.newQName(this.compiler, "this." + propertyName);
        this.exports.add(new PropertyExport(prototypeName, propertyName, propertyNameNode));
    }

    private class PropertyExport
    extends Export {
        private final String exportPath;

        public PropertyExport(String exportPath, String symbolName, Node value) {
            super(symbolName, value);
            this.exportPath = (String)Preconditions.checkNotNull((Object)exportPath);
        }

        @Override
        String getExportedPath() {
            List pieces = Splitter.on((char)'.').splitToList((CharSequence)this.exportPath);
            for (int i = pieces.size(); i > 0; --i) {
                String cPath = Joiner.on((String)".").join(Iterables.limit((Iterable)pieces, (int)i));
                if (!ExternExportsPass.this.mappedPaths.containsKey(cPath)) continue;
                String newPath = (String)ExternExportsPass.this.mappedPaths.get(cPath);
                if (i < pieces.size()) {
                    newPath = newPath + "." + Joiner.on((String)".").join(Iterables.skip((Iterable)pieces, (int)i));
                }
                return newPath + "." + this.symbolName;
            }
            return this.exportPath + "." + this.symbolName;
        }
    }

    private class SymbolExport
    extends Export {
        public SymbolExport(String symbolName, Node value) {
            super(symbolName, value);
            String qualifiedName = value.getQualifiedName();
            if (qualifiedName != null) {
                ExternExportsPass.this.mappedPaths.put(qualifiedName, symbolName);
            }
        }

        @Override
        String getExportedPath() {
            return this.symbolName;
        }
    }

    private abstract class Export {
        protected final String symbolName;
        protected final Node value;

        Export(String symbolName, Node value) {
            this.symbolName = (String)Preconditions.checkNotNull((Object)symbolName);
            this.value = (Node)Preconditions.checkNotNull((Object)value);
        }

        void generateExterns() {
            this.appendExtern(this.getExportedPath(), this.getValue());
        }

        abstract String getExportedPath();

        void appendExtern(String path, Node valueToExport) {
            List<String> pathPrefixes = this.computePathPrefixes(path);
            for (int i = 0; i < pathPrefixes.size(); ++i) {
                Node initializer;
                JSDocInfo jsdoc;
                String pathPrefix = pathPrefixes.get(i);
                boolean isCompletePathPrefix = i == pathPrefixes.size() - 1;
                boolean skipPathPrefix = pathPrefix.endsWith(".prototype") || ExternExportsPass.this.alreadyExportedPaths.contains(pathPrefix) && !isCompletePathPrefix;
                boolean exportedValueDefinesNewType = false;
                if (valueToExport != null && (jsdoc = NodeUtil.getBestJSDocInfo(valueToExport)) != null && jsdoc.containsTypeDefinition()) {
                    exportedValueDefinesNewType = true;
                }
                if (skipPathPrefix) continue;
                JSDocInfo jsdoc2 = null;
                if (isCompletePathPrefix && valueToExport != null) {
                    if (valueToExport.isFunction()) {
                        initializer = this.createExternFunction(valueToExport);
                    } else {
                        Preconditions.checkState((boolean)valueToExport.isObjectLit());
                        initializer = this.createExternObjectLit(valueToExport);
                    }
                } else if (!isCompletePathPrefix && exportedValueDefinesNewType) {
                    jsdoc2 = this.buildNamespaceJSDoc();
                    initializer = this.createExternObjectLit(IR.objectlit(new Node[0]));
                    initializer.setJSDocInfo(null);
                } else {
                    initializer = IR.empty();
                }
                this.appendPathDefinition(pathPrefix, initializer, jsdoc2);
            }
        }

        private List<String> computePathPrefixes(String path) {
            List pieces = Splitter.on((char)'.').splitToList((CharSequence)path);
            ArrayList<String> pathPrefixes = new ArrayList<String>();
            for (int i = 0; i < pieces.size(); ++i) {
                pathPrefixes.add(Joiner.on((String)".").join(Iterables.limit((Iterable)pieces, (int)(i + 1))));
            }
            return pathPrefixes;
        }

        private void appendPathDefinition(String path, Node initializer, JSDocInfo jsdoc) {
            Node pathDefinition;
            if (!path.contains(".")) {
                pathDefinition = initializer.isEmpty() ? IR.var(IR.name(path)) : NodeUtil.newVarNode(path, initializer);
            } else {
                Node qualifiedPath = NodeUtil.newQName(ExternExportsPass.this.compiler, path);
                pathDefinition = initializer.isEmpty() ? NodeUtil.newExpr(qualifiedPath) : NodeUtil.newExpr(IR.assign(qualifiedPath, initializer));
            }
            if (jsdoc != null) {
                if (pathDefinition.isExprResult()) {
                    pathDefinition.getFirstChild().setJSDocInfo(jsdoc);
                } else {
                    Preconditions.checkState((boolean)pathDefinition.isVar());
                    pathDefinition.setJSDocInfo(jsdoc);
                }
            }
            ExternExportsPass.this.externsRoot.addChildToBack(pathDefinition);
            ExternExportsPass.this.alreadyExportedPaths.add(path);
        }

        private Node createExternFunction(Node exportedFunction) {
            Node paramList = NodeUtil.getFunctionParameters(exportedFunction).cloneTree();
            for (Node param = paramList.getFirstChild(); param != null && param.isName(); param = param.getNext()) {
                String originalName = param.getOriginalName();
                if (originalName == null) continue;
                param.setString(originalName);
            }
            Node externFunction = IR.function(IR.name(""), paramList, IR.block());
            if (exportedFunction.getJSType() != null) {
                externFunction.setJSType(exportedFunction.getJSType());
                this.deleteInlineJsdocs(externFunction);
            }
            return externFunction;
        }

        private void deleteInlineJsdocs(Node fn) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            for (Node param : NodeUtil.getFunctionParameters(fn).children()) {
                param.setJSDocInfo(null);
            }
            fn.getFirstChild().setJSDocInfo(null);
        }

        private JSDocInfo buildEmptyJSDoc() {
            return new JSDocInfoBuilder(false).build(true);
        }

        private JSDocInfo buildNamespaceJSDoc() {
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordConstancy();
            builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"const", (Object)"duplicate"));
            return builder.build();
        }

        private Node createExternObjectLit(Node exportedObjectLit) {
            Node lit = IR.objectlit(new Node[0]);
            lit.setJSType(exportedObjectLit.getJSType());
            lit.setJSDocInfo(this.buildEmptyJSDoc());
            int index = 1;
            for (Node child = exportedObjectLit.getFirstChild(); child != null; child = child.getNext()) {
                if (!child.isStringKey()) continue;
                lit.addChildToBack(IR.propdef(IR.stringKey(child.getString()), IR.number(index++)));
            }
            return lit;
        }

        protected Node getValue() {
            Node definition;
            String qualifiedName = this.value.getQualifiedName();
            if (qualifiedName == null) {
                return null;
            }
            Node definitionParent = (Node)ExternExportsPass.this.definitionMap.get(qualifiedName);
            if (definitionParent == null) {
                return null;
            }
            switch (definitionParent.getToken()) {
                case ASSIGN: {
                    definition = definitionParent.getLastChild();
                    break;
                }
                case VAR: {
                    definition = definitionParent.getLastChild().getLastChild();
                    break;
                }
                case FUNCTION: {
                    if (NodeUtil.isFunctionDeclaration(definitionParent)) {
                        definition = definitionParent;
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (!definition.isFunction() && !definition.isObjectLit()) {
                return null;
            }
            return definition;
        }
    }
}

