/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class ClosureCodeRemoval
implements CompilerPass {
    private final AbstractCompiler compiler;
    static final String ABSTRACT_METHOD_NAME = "goog.abstractMethod";
    private final boolean removeAbstractMethods;
    private final boolean removeAssertionCalls;
    private final List<RemovableAssignment> abstractMethodAssignmentNodes = new ArrayList<RemovableAssignment>();
    private final List<Node> abstractMemberFunctionNodes = new ArrayList<Node>();
    private final List<Node> assertionCalls = new ArrayList<Node>();

    ClosureCodeRemoval(AbstractCompiler compiler, boolean removeAbstractMethods, boolean removeAssertionCalls) {
        this.compiler = compiler;
        this.removeAbstractMethods = removeAbstractMethods;
        this.removeAssertionCalls = removeAssertionCalls;
    }

    @Override
    public void process(Node externs, Node root) {
        Node parent;
        ArrayList<NodeTraversal.Callback> passes = new ArrayList<NodeTraversal.Callback>();
        if (this.removeAbstractMethods) {
            passes.add(new FindAbstractMethods());
        }
        if (this.removeAssertionCalls) {
            passes.add(new FindAssertionCalls());
        }
        CombinedCompilerPass.traverse(this.compiler, root, passes);
        for (RemovableAssignment assignment : this.abstractMethodAssignmentNodes) {
            assignment.remove();
        }
        for (Node memberFunction : this.abstractMemberFunctionNodes) {
            this.compiler.reportFunctionDeleted(memberFunction.getFirstChild());
            parent = memberFunction.getParent();
            parent.removeChild(memberFunction);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        for (Node call : this.assertionCalls) {
            this.compiler.reportChangeToEnclosingScope(call);
            parent = call.getParent();
            if (parent.isExprResult()) {
                parent.detach();
                NodeUtil.markFunctionsDeleted(parent, this.compiler);
                continue;
            }
            Node firstArg = call.getSecondChild();
            if (firstArg == null) {
                parent.replaceChild(call, NodeUtil.newUndefinedNode(call));
            } else {
                Node replacement = firstArg.detach();
                replacement.setJSType(call.getJSType());
                parent.replaceChild(call, replacement);
            }
            NodeUtil.markFunctionsDeleted(call, this.compiler);
        }
    }

    private class FindAssertionCalls
    extends NodeTraversal.AbstractPostOrderCallback {
        final Set<String> assertionNames;

        FindAssertionCalls() {
            ImmutableSet.Builder assertionNamesBuilder = ImmutableSet.builder();
            for (CodingConvention.AssertionFunctionSpec spec : ClosureCodeRemoval.this.compiler.getCodingConvention().getAssertionFunctions()) {
                assertionNamesBuilder.add((Object)spec.getFunctionName());
            }
            this.assertionNames = assertionNamesBuilder.build();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            String fnName;
            if (n.isCall() && this.assertionNames.contains(fnName = n.getFirstChild().getQualifiedName())) {
                ClosureCodeRemoval.this.assertionCalls.add(n);
            }
        }
    }

    private class FindAbstractMethods
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindAbstractMethods() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isAssign()) {
                Node nameNode = n.getFirstChild();
                Node valueNode = n.getLastChild();
                if (nameNode.isQualifiedName() && valueNode.isQualifiedName() && valueNode.matchesQualifiedName(ClosureCodeRemoval.ABSTRACT_METHOD_NAME)) {
                    ClosureCodeRemoval.this.abstractMethodAssignmentNodes.add(new RemovableAssignment(n.getFirstChild(), n, t));
                } else if (n.getJSDocInfo() != null && n.getJSDocInfo().isAbstract() && !n.getJSDocInfo().isConstructor() && !valueNode.isClass()) {
                    ClosureCodeRemoval.this.abstractMethodAssignmentNodes.add(new RemovableAssignment(n.getFirstChild(), n, t));
                }
            } else if (n.isMemberFunctionDef() && parent.isClassMembers() && n.getJSDocInfo() != null && n.getJSDocInfo().isAbstract()) {
                ClosureCodeRemoval.this.abstractMemberFunctionNodes.add(n);
            }
        }
    }

    private class RemovableAssignment {
        final Node node;
        final Node parent;
        final List<Node> assignAncestors = new ArrayList<Node>();
        final Node lastAncestor;

        public RemovableAssignment(Node nameNode, Node assignNode, NodeTraversal traversal) {
            this.node = nameNode;
            this.parent = assignNode;
            Node ancestor = assignNode;
            do {
                ancestor = ancestor.getParent();
                this.assignAncestors.add(ancestor);
            } while (ancestor.isAssign() && ancestor.getFirstChild().isQualifiedName());
            this.lastAncestor = ancestor.getParent();
        }

        public void remove() {
            Node rhs = this.node.getNext();
            Node last = this.parent;
            for (Node ancestor : this.assignAncestors) {
                if (ancestor.isExprResult()) {
                    this.lastAncestor.removeChild(ancestor);
                    NodeUtil.markFunctionsDeleted(ancestor, ClosureCodeRemoval.this.compiler);
                } else {
                    rhs.detach();
                    ancestor.replaceChild(last, rhs);
                }
                last = ancestor;
            }
            ClosureCodeRemoval.this.compiler.reportChangeToEnclosingScope(this.lastAncestor);
        }
    }
}

