/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.jstype.FunctionType;

@Immutable
public final class ChromeCodingConvention
extends CodingConventions.Proxy {
    private final ImmutableSet<String> indirectlyDeclaredProperties;

    public ChromeCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ChromeCodingConvention(CodingConvention wrapped) {
        super(wrapped);
        this.indirectlyDeclaredProperties = new ImmutableSet.Builder().add((Object[])new String[]{"instance_", "getInstance"}).addAll(wrapped.getIndirectlyDeclaredProperties()).build();
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        if (!callArg.matchesQualifiedName("cr.addSingletonGetter") || !callNode.hasTwoChildren()) {
            return super.getSingletonGetterClassName(callNode);
        }
        return callArg.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetter(NominalTypeBuilder classType, FunctionType getterType) {
        Node defSite = classType.constructor().getSource();
        classType.declareConstructorProperty("getInstance", getterType, defSite);
        classType.declareConstructorProperty("instance_", classType.instance(), defSite);
    }

    public ImmutableCollection<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }

    public ImmutableCollection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of((Object)new CodingConvention.AssertionFunctionSpec("assert"), (Object)new ClosureCodingConvention.AssertInstanceofSpec("cr.ui.decorate"));
    }

    @Override
    public boolean isFunctionCallThatAlwaysThrows(Node n) {
        return CodingConventions.defaultIsFunctionCallThatAlwaysThrows(n, "assertNotReached");
    }
}

