// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/distribution.proto

package com.google.api;

/**
 * <pre>
 * Distribution contains summary statistics for a population of values and,
 * optionally, a histogram representing the distribution of those values across
 * a specified set of histogram buckets.
 * The summary statistics are the count, mean, sum of the squared deviation from
 * the mean, the minimum, and the maximum of the set of population of values.
 * The histogram is based on a sequence of buckets and gives a count of values
 * that fall into each bucket.  The boundaries of the buckets are given either
 * explicitly or by specifying parameters for a method of computing them
 * (buckets of fixed width or buckets of exponentially increasing width).
 * Although it is not forbidden, it is generally a bad idea to include
 * non-finite values (infinities or NaNs) in the population of values, as this
 * will render the `mean` and `sum_of_squared_deviation` fields meaningless.
 * </pre>
 *
 * Protobuf type {@code google.api.Distribution}
 */
public  final class Distribution extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.Distribution)
    DistributionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Distribution.newBuilder() to construct.
  private Distribution(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Distribution() {
    count_ = 0L;
    mean_ = 0D;
    sumOfSquaredDeviation_ = 0D;
    bucketCounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Distribution(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            count_ = input.readInt64();
            break;
          }
          case 17: {

            mean_ = input.readDouble();
            break;
          }
          case 25: {

            sumOfSquaredDeviation_ = input.readDouble();
            break;
          }
          case 34: {
            com.google.api.Distribution.Range.Builder subBuilder = null;
            if (range_ != null) {
              subBuilder = range_.toBuilder();
            }
            range_ = input.readMessage(com.google.api.Distribution.Range.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(range_);
              range_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            com.google.api.Distribution.BucketOptions.Builder subBuilder = null;
            if (bucketOptions_ != null) {
              subBuilder = bucketOptions_.toBuilder();
            }
            bucketOptions_ = input.readMessage(com.google.api.Distribution.BucketOptions.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(bucketOptions_);
              bucketOptions_ = subBuilder.buildPartial();
            }

            break;
          }
          case 56: {
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              bucketCounts_ = new java.util.ArrayList<java.lang.Long>();
              mutable_bitField0_ |= 0x00000020;
            }
            bucketCounts_.add(input.readInt64());
            break;
          }
          case 58: {
            int length = input.readRawVarint32();
            int limit = input.pushLimit(length);
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020) && input.getBytesUntilLimit() > 0) {
              bucketCounts_ = new java.util.ArrayList<java.lang.Long>();
              mutable_bitField0_ |= 0x00000020;
            }
            while (input.getBytesUntilLimit() > 0) {
              bucketCounts_.add(input.readInt64());
            }
            input.popLimit(limit);
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        bucketCounts_ = java.util.Collections.unmodifiableList(bucketCounts_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.DistributionProto.internal_static_google_api_Distribution_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Distribution.class, com.google.api.Distribution.Builder.class);
  }

  public interface RangeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.Range)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The minimum of the population values.
     * </pre>
     *
     * <code>double min = 1;</code>
     */
    double getMin();

    /**
     * <pre>
     * The maximum of the population values.
     * </pre>
     *
     * <code>double max = 2;</code>
     */
    double getMax();
  }
  /**
   * <pre>
   * The range of the population values.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.Range}
   */
  public  static final class Range extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.Range)
      RangeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Range.newBuilder() to construct.
    private Range(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Range() {
      min_ = 0D;
      max_ = 0D;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Range(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 9: {

              min_ = input.readDouble();
              break;
            }
            case 17: {

              max_ = input.readDouble();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Distribution.Range.class, com.google.api.Distribution.Range.Builder.class);
    }

    public static final int MIN_FIELD_NUMBER = 1;
    private double min_;
    /**
     * <pre>
     * The minimum of the population values.
     * </pre>
     *
     * <code>double min = 1;</code>
     */
    public double getMin() {
      return min_;
    }

    public static final int MAX_FIELD_NUMBER = 2;
    private double max_;
    /**
     * <pre>
     * The maximum of the population values.
     * </pre>
     *
     * <code>double max = 2;</code>
     */
    public double getMax() {
      return max_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (min_ != 0D) {
        output.writeDouble(1, min_);
      }
      if (max_ != 0D) {
        output.writeDouble(2, max_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (min_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(1, min_);
      }
      if (max_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(2, max_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.api.Distribution.Range)) {
        return super.equals(obj);
      }
      com.google.api.Distribution.Range other = (com.google.api.Distribution.Range) obj;

      boolean result = true;
      result = result && (
          java.lang.Double.doubleToLongBits(getMin())
          == java.lang.Double.doubleToLongBits(
              other.getMin()));
      result = result && (
          java.lang.Double.doubleToLongBits(getMax())
          == java.lang.Double.doubleToLongBits(
              other.getMax()));
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MIN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMin()));
      hash = (37 * hash) + MAX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getMax()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.Distribution.Range parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Distribution.Range parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Distribution.Range parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Distribution.Range parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Distribution.Range parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Distribution.Range parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Distribution.Range parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.api.Distribution.Range parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.api.Distribution.Range parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.api.Distribution.Range parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.api.Distribution.Range parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.api.Distribution.Range parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.api.Distribution.Range prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * The range of the population values.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.Range}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.Range)
        com.google.api.Distribution.RangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Distribution.Range.class, com.google.api.Distribution.Range.Builder.class);
      }

      // Construct using com.google.api.Distribution.Range.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        min_ = 0D;

        max_ = 0D;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_Range_descriptor;
      }

      public com.google.api.Distribution.Range getDefaultInstanceForType() {
        return com.google.api.Distribution.Range.getDefaultInstance();
      }

      public com.google.api.Distribution.Range build() {
        com.google.api.Distribution.Range result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.api.Distribution.Range buildPartial() {
        com.google.api.Distribution.Range result = new com.google.api.Distribution.Range(this);
        result.min_ = min_;
        result.max_ = max_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.Distribution.Range) {
          return mergeFrom((com.google.api.Distribution.Range)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.api.Distribution.Range other) {
        if (other == com.google.api.Distribution.Range.getDefaultInstance()) return this;
        if (other.getMin() != 0D) {
          setMin(other.getMin());
        }
        if (other.getMax() != 0D) {
          setMax(other.getMax());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.api.Distribution.Range parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.api.Distribution.Range) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private double min_ ;
      /**
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       */
      public double getMin() {
        return min_;
      }
      /**
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       */
      public Builder setMin(double value) {
        
        min_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The minimum of the population values.
       * </pre>
       *
       * <code>double min = 1;</code>
       */
      public Builder clearMin() {
        
        min_ = 0D;
        onChanged();
        return this;
      }

      private double max_ ;
      /**
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       */
      public double getMax() {
        return max_;
      }
      /**
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       */
      public Builder setMax(double value) {
        
        max_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The maximum of the population values.
       * </pre>
       *
       * <code>double max = 2;</code>
       */
      public Builder clearMax() {
        
        max_ = 0D;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.api.Distribution.Range)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.Range)
    private static final com.google.api.Distribution.Range DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.api.Distribution.Range();
    }

    public static com.google.api.Distribution.Range getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Range>
        PARSER = new com.google.protobuf.AbstractParser<Range>() {
      public Range parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Range(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Range> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Range> getParserForType() {
      return PARSER;
    }

    public com.google.api.Distribution.Range getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface BucketOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    boolean hasLinearBuckets();
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    com.google.api.Distribution.BucketOptions.Linear getLinearBuckets();
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    com.google.api.Distribution.BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder();

    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    boolean hasExponentialBuckets();
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    com.google.api.Distribution.BucketOptions.Exponential getExponentialBuckets();
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    com.google.api.Distribution.BucketOptions.ExponentialOrBuilder getExponentialBucketsOrBuilder();

    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    boolean hasExplicitBuckets();
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    com.google.api.Distribution.BucketOptions.Explicit getExplicitBuckets();
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    com.google.api.Distribution.BucketOptions.ExplicitOrBuilder getExplicitBucketsOrBuilder();

    public com.google.api.Distribution.BucketOptions.OptionsCase getOptionsCase();
  }
  /**
   * <pre>
   * A Distribution may optionally contain a histogram of the values in the
   * population.  The histogram is given in `bucket_counts` as counts of values
   * that fall into one of a sequence of non-overlapping buckets.  The sequence
   * of buckets is described by `bucket_options`.
   * A bucket specifies an inclusive lower bound and exclusive upper bound for
   * the values that are counted for that bucket.  The upper bound of a bucket
   * is strictly greater than the lower bound.
   * The sequence of N buckets for a Distribution consists of an underflow
   * bucket (number 0), zero or more finite buckets (number 1 through N - 2) and
   * an overflow bucket (number N - 1).  The buckets are contiguous:  the lower
   * bound of bucket i (i &gt; 0) is the same as the upper bound of bucket i - 1.
   * The buckets span the whole range of finite values: lower bound of the
   * underflow bucket is -infinity and the upper bound of the overflow bucket is
   * +infinity.  The finite buckets are so-called because both bounds are
   * finite.
   * `BucketOptions` describes bucket boundaries in one of three ways.  Two
   * describe the boundaries by giving parameters for a formula to generate
   * boundaries and one gives the bucket boundaries explicitly.
   * If `bucket_boundaries` is not given, then no `bucket_counts` may be given.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution.BucketOptions}
   */
  public  static final class BucketOptions extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions)
      BucketOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BucketOptions.newBuilder() to construct.
    private BucketOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BucketOptions() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BucketOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.api.Distribution.BucketOptions.Linear.Builder subBuilder = null;
              if (optionsCase_ == 1) {
                subBuilder = ((com.google.api.Distribution.BucketOptions.Linear) options_).toBuilder();
              }
              options_ =
                  input.readMessage(com.google.api.Distribution.BucketOptions.Linear.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.api.Distribution.BucketOptions.Linear) options_);
                options_ = subBuilder.buildPartial();
              }
              optionsCase_ = 1;
              break;
            }
            case 18: {
              com.google.api.Distribution.BucketOptions.Exponential.Builder subBuilder = null;
              if (optionsCase_ == 2) {
                subBuilder = ((com.google.api.Distribution.BucketOptions.Exponential) options_).toBuilder();
              }
              options_ =
                  input.readMessage(com.google.api.Distribution.BucketOptions.Exponential.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.api.Distribution.BucketOptions.Exponential) options_);
                options_ = subBuilder.buildPartial();
              }
              optionsCase_ = 2;
              break;
            }
            case 26: {
              com.google.api.Distribution.BucketOptions.Explicit.Builder subBuilder = null;
              if (optionsCase_ == 3) {
                subBuilder = ((com.google.api.Distribution.BucketOptions.Explicit) options_).toBuilder();
              }
              options_ =
                  input.readMessage(com.google.api.Distribution.BucketOptions.Explicit.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.api.Distribution.BucketOptions.Explicit) options_);
                options_ = subBuilder.buildPartial();
              }
              optionsCase_ = 3;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Distribution.BucketOptions.class, com.google.api.Distribution.BucketOptions.Builder.class);
    }

    public interface LinearOrBuilder extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Linear)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      int getNumFiniteBuckets();

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      double getWidth();

      /**
       * <pre>
       * Lower bound of the first bucket.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      double getOffset();
    }
    /**
     * <pre>
     * Specify a sequence of buckets that all have the same width (except
     * overflow and underflow).  Each bucket represents a constant absolute
     * uncertainty on the specific value in the bucket.
     * Defines `num_finite_buckets + 2` (= N) buckets with these boundaries for
     * bucket `i`:
     *    Upper bound (0 &lt;= i &lt; N-1):     offset + (width * i).
     *    Lower bound (1 &lt;= i &lt; N):       offset + (width * (i - 1)).
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Linear}
     */
    public  static final class Linear extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Linear)
        LinearOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Linear.newBuilder() to construct.
      private Linear(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Linear() {
        numFiniteBuckets_ = 0;
        width_ = 0D;
        offset_ = 0D;
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Linear(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownFieldProto3(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 8: {

                numFiniteBuckets_ = input.readInt32();
                break;
              }
              case 17: {

                width_ = input.readDouble();
                break;
              }
              case 25: {

                offset_ = input.readDouble();
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Distribution.BucketOptions.Linear.class, com.google.api.Distribution.BucketOptions.Linear.Builder.class);
      }

      public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
      private int numFiniteBuckets_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }

      public static final int WIDTH_FIELD_NUMBER = 2;
      private double width_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double width = 2;</code>
       */
      public double getWidth() {
        return width_;
      }

      public static final int OFFSET_FIELD_NUMBER = 3;
      private double offset_;
      /**
       * <pre>
       * Lower bound of the first bucket.
       * </pre>
       *
       * <code>double offset = 3;</code>
       */
      public double getOffset() {
        return offset_;
      }

      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (numFiniteBuckets_ != 0) {
          output.writeInt32(1, numFiniteBuckets_);
        }
        if (width_ != 0D) {
          output.writeDouble(2, width_);
        }
        if (offset_ != 0D) {
          output.writeDouble(3, offset_);
        }
        unknownFields.writeTo(output);
      }

      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numFiniteBuckets_ != 0) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(1, numFiniteBuckets_);
        }
        if (width_ != 0D) {
          size += com.google.protobuf.CodedOutputStream
            .computeDoubleSize(2, width_);
        }
        if (offset_ != 0D) {
          size += com.google.protobuf.CodedOutputStream
            .computeDoubleSize(3, offset_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.api.Distribution.BucketOptions.Linear)) {
          return super.equals(obj);
        }
        com.google.api.Distribution.BucketOptions.Linear other = (com.google.api.Distribution.BucketOptions.Linear) obj;

        boolean result = true;
        result = result && (getNumFiniteBuckets()
            == other.getNumFiniteBuckets());
        result = result && (
            java.lang.Double.doubleToLongBits(getWidth())
            == java.lang.Double.doubleToLongBits(
                other.getWidth()));
        result = result && (
            java.lang.Double.doubleToLongBits(getOffset())
            == java.lang.Double.doubleToLongBits(
                other.getOffset()));
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getNumFiniteBuckets();
        hash = (37 * hash) + WIDTH_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getWidth()));
        hash = (37 * hash) + OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getOffset()));
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Linear parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.api.Distribution.BucketOptions.Linear prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Specify a sequence of buckets that all have the same width (except
       * overflow and underflow).  Each bucket represents a constant absolute
       * uncertainty on the specific value in the bucket.
       * Defines `num_finite_buckets + 2` (= N) buckets with these boundaries for
       * bucket `i`:
       *    Upper bound (0 &lt;= i &lt; N-1):     offset + (width * i).
       *    Lower bound (1 &lt;= i &lt; N):       offset + (width * (i - 1)).
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Linear}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Linear)
          com.google.api.Distribution.BucketOptions.LinearOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
        }

        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.api.Distribution.BucketOptions.Linear.class, com.google.api.Distribution.BucketOptions.Linear.Builder.class);
        }

        // Construct using com.google.api.Distribution.BucketOptions.Linear.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        public Builder clear() {
          super.clear();
          numFiniteBuckets_ = 0;

          width_ = 0D;

          offset_ = 0D;

          return this;
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Linear_descriptor;
        }

        public com.google.api.Distribution.BucketOptions.Linear getDefaultInstanceForType() {
          return com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        }

        public com.google.api.Distribution.BucketOptions.Linear build() {
          com.google.api.Distribution.BucketOptions.Linear result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.google.api.Distribution.BucketOptions.Linear buildPartial() {
          com.google.api.Distribution.BucketOptions.Linear result = new com.google.api.Distribution.BucketOptions.Linear(this);
          result.numFiniteBuckets_ = numFiniteBuckets_;
          result.width_ = width_;
          result.offset_ = offset_;
          onBuilt();
          return result;
        }

        public Builder clone() {
          return (Builder) super.clone();
        }
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.api.Distribution.BucketOptions.Linear) {
            return mergeFrom((com.google.api.Distribution.BucketOptions.Linear)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.api.Distribution.BucketOptions.Linear other) {
          if (other == com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance()) return this;
          if (other.getNumFiniteBuckets() != 0) {
            setNumFiniteBuckets(other.getNumFiniteBuckets());
          }
          if (other.getWidth() != 0D) {
            setWidth(other.getWidth());
          }
          if (other.getOffset() != 0D) {
            setOffset(other.getOffset());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        public final boolean isInitialized() {
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.api.Distribution.BucketOptions.Linear parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.api.Distribution.BucketOptions.Linear) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numFiniteBuckets_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public int getNumFiniteBuckets() {
          return numFiniteBuckets_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder setNumFiniteBuckets(int value) {
          
          numFiniteBuckets_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder clearNumFiniteBuckets() {
          
          numFiniteBuckets_ = 0;
          onChanged();
          return this;
        }

        private double width_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         */
        public double getWidth() {
          return width_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         */
        public Builder setWidth(double value) {
          
          width_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double width = 2;</code>
         */
        public Builder clearWidth() {
          
          width_ = 0D;
          onChanged();
          return this;
        }

        private double offset_ ;
        /**
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         */
        public double getOffset() {
          return offset_;
        }
        /**
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         */
        public Builder setOffset(double value) {
          
          offset_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Lower bound of the first bucket.
         * </pre>
         *
         * <code>double offset = 3;</code>
         */
        public Builder clearOffset() {
          
          offset_ = 0D;
          onChanged();
          return this;
        }
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Linear)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Linear)
      private static final com.google.api.Distribution.BucketOptions.Linear DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.api.Distribution.BucketOptions.Linear();
      }

      public static com.google.api.Distribution.BucketOptions.Linear getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Linear>
          PARSER = new com.google.protobuf.AbstractParser<Linear>() {
        public Linear parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Linear(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Linear> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Linear> getParserForType() {
        return PARSER;
      }

      public com.google.api.Distribution.BucketOptions.Linear getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ExponentialOrBuilder extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Exponential)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      int getNumFiniteBuckets();

      /**
       * <pre>
       * Must be greater than 1.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      double getGrowthFactor();

      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      double getScale();
    }
    /**
     * <pre>
     * Specify a sequence of buckets that have a width that is proportional to
     * the value of the lower bound.  Each bucket represents a constant relative
     * uncertainty on a specific value in the bucket.
     * Defines `num_finite_buckets + 2` (= N) buckets with these boundaries for
     * bucket i:
     *    Upper bound (0 &lt;= i &lt; N-1):     scale * (growth_factor ^ i).
     *    Lower bound (1 &lt;= i &lt; N):       scale * (growth_factor ^ (i - 1)).
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Exponential}
     */
    public  static final class Exponential extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Exponential)
        ExponentialOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Exponential.newBuilder() to construct.
      private Exponential(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Exponential() {
        numFiniteBuckets_ = 0;
        growthFactor_ = 0D;
        scale_ = 0D;
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Exponential(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownFieldProto3(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 8: {

                numFiniteBuckets_ = input.readInt32();
                break;
              }
              case 17: {

                growthFactor_ = input.readDouble();
                break;
              }
              case 25: {

                scale_ = input.readDouble();
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Distribution.BucketOptions.Exponential.class, com.google.api.Distribution.BucketOptions.Exponential.Builder.class);
      }

      public static final int NUM_FINITE_BUCKETS_FIELD_NUMBER = 1;
      private int numFiniteBuckets_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>int32 num_finite_buckets = 1;</code>
       */
      public int getNumFiniteBuckets() {
        return numFiniteBuckets_;
      }

      public static final int GROWTH_FACTOR_FIELD_NUMBER = 2;
      private double growthFactor_;
      /**
       * <pre>
       * Must be greater than 1.
       * </pre>
       *
       * <code>double growth_factor = 2;</code>
       */
      public double getGrowthFactor() {
        return growthFactor_;
      }

      public static final int SCALE_FIELD_NUMBER = 3;
      private double scale_;
      /**
       * <pre>
       * Must be greater than 0.
       * </pre>
       *
       * <code>double scale = 3;</code>
       */
      public double getScale() {
        return scale_;
      }

      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (numFiniteBuckets_ != 0) {
          output.writeInt32(1, numFiniteBuckets_);
        }
        if (growthFactor_ != 0D) {
          output.writeDouble(2, growthFactor_);
        }
        if (scale_ != 0D) {
          output.writeDouble(3, scale_);
        }
        unknownFields.writeTo(output);
      }

      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (numFiniteBuckets_ != 0) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(1, numFiniteBuckets_);
        }
        if (growthFactor_ != 0D) {
          size += com.google.protobuf.CodedOutputStream
            .computeDoubleSize(2, growthFactor_);
        }
        if (scale_ != 0D) {
          size += com.google.protobuf.CodedOutputStream
            .computeDoubleSize(3, scale_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.api.Distribution.BucketOptions.Exponential)) {
          return super.equals(obj);
        }
        com.google.api.Distribution.BucketOptions.Exponential other = (com.google.api.Distribution.BucketOptions.Exponential) obj;

        boolean result = true;
        result = result && (getNumFiniteBuckets()
            == other.getNumFiniteBuckets());
        result = result && (
            java.lang.Double.doubleToLongBits(getGrowthFactor())
            == java.lang.Double.doubleToLongBits(
                other.getGrowthFactor()));
        result = result && (
            java.lang.Double.doubleToLongBits(getScale())
            == java.lang.Double.doubleToLongBits(
                other.getScale()));
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NUM_FINITE_BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getNumFiniteBuckets();
        hash = (37 * hash) + GROWTH_FACTOR_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getGrowthFactor()));
        hash = (37 * hash) + SCALE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getScale()));
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Exponential parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.api.Distribution.BucketOptions.Exponential prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Specify a sequence of buckets that have a width that is proportional to
       * the value of the lower bound.  Each bucket represents a constant relative
       * uncertainty on a specific value in the bucket.
       * Defines `num_finite_buckets + 2` (= N) buckets with these boundaries for
       * bucket i:
       *    Upper bound (0 &lt;= i &lt; N-1):     scale * (growth_factor ^ i).
       *    Lower bound (1 &lt;= i &lt; N):       scale * (growth_factor ^ (i - 1)).
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Exponential}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Exponential)
          com.google.api.Distribution.BucketOptions.ExponentialOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
        }

        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.api.Distribution.BucketOptions.Exponential.class, com.google.api.Distribution.BucketOptions.Exponential.Builder.class);
        }

        // Construct using com.google.api.Distribution.BucketOptions.Exponential.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        public Builder clear() {
          super.clear();
          numFiniteBuckets_ = 0;

          growthFactor_ = 0D;

          scale_ = 0D;

          return this;
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Exponential_descriptor;
        }

        public com.google.api.Distribution.BucketOptions.Exponential getDefaultInstanceForType() {
          return com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        }

        public com.google.api.Distribution.BucketOptions.Exponential build() {
          com.google.api.Distribution.BucketOptions.Exponential result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.google.api.Distribution.BucketOptions.Exponential buildPartial() {
          com.google.api.Distribution.BucketOptions.Exponential result = new com.google.api.Distribution.BucketOptions.Exponential(this);
          result.numFiniteBuckets_ = numFiniteBuckets_;
          result.growthFactor_ = growthFactor_;
          result.scale_ = scale_;
          onBuilt();
          return result;
        }

        public Builder clone() {
          return (Builder) super.clone();
        }
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.api.Distribution.BucketOptions.Exponential) {
            return mergeFrom((com.google.api.Distribution.BucketOptions.Exponential)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.api.Distribution.BucketOptions.Exponential other) {
          if (other == com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance()) return this;
          if (other.getNumFiniteBuckets() != 0) {
            setNumFiniteBuckets(other.getNumFiniteBuckets());
          }
          if (other.getGrowthFactor() != 0D) {
            setGrowthFactor(other.getGrowthFactor());
          }
          if (other.getScale() != 0D) {
            setScale(other.getScale());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        public final boolean isInitialized() {
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.api.Distribution.BucketOptions.Exponential parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.api.Distribution.BucketOptions.Exponential) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int numFiniteBuckets_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public int getNumFiniteBuckets() {
          return numFiniteBuckets_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder setNumFiniteBuckets(int value) {
          
          numFiniteBuckets_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>int32 num_finite_buckets = 1;</code>
         */
        public Builder clearNumFiniteBuckets() {
          
          numFiniteBuckets_ = 0;
          onChanged();
          return this;
        }

        private double growthFactor_ ;
        /**
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         */
        public double getGrowthFactor() {
          return growthFactor_;
        }
        /**
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         */
        public Builder setGrowthFactor(double value) {
          
          growthFactor_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 1.
         * </pre>
         *
         * <code>double growth_factor = 2;</code>
         */
        public Builder clearGrowthFactor() {
          
          growthFactor_ = 0D;
          onChanged();
          return this;
        }

        private double scale_ ;
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         */
        public double getScale() {
          return scale_;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         */
        public Builder setScale(double value) {
          
          scale_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be greater than 0.
         * </pre>
         *
         * <code>double scale = 3;</code>
         */
        public Builder clearScale() {
          
          scale_ = 0D;
          onChanged();
          return this;
        }
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Exponential)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Exponential)
      private static final com.google.api.Distribution.BucketOptions.Exponential DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.api.Distribution.BucketOptions.Exponential();
      }

      public static com.google.api.Distribution.BucketOptions.Exponential getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Exponential>
          PARSER = new com.google.protobuf.AbstractParser<Exponential>() {
        public Exponential parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Exponential(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Exponential> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Exponential> getParserForType() {
        return PARSER;
      }

      public com.google.api.Distribution.BucketOptions.Exponential getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ExplicitOrBuilder extends
        // @@protoc_insertion_point(interface_extends:google.api.Distribution.BucketOptions.Explicit)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      java.util.List<java.lang.Double> getBoundsList();
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      int getBoundsCount();
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      double getBounds(int index);
    }
    /**
     * <pre>
     * A set of buckets with arbitrary widths.
     * Defines `size(bounds) + 1` (= N) buckets with these boundaries for
     * bucket i:
     *    Upper bound (0 &lt;= i &lt; N-1):     bounds[i]
     *    Lower bound (1 &lt;= i &lt; N);       bounds[i - 1]
     * There must be at least one element in `bounds`.  If `bounds` has only one
     * element, there are no finite buckets, and that single element is the
     * common boundary of the overflow and underflow buckets.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions.Explicit}
     */
    public  static final class Explicit extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:google.api.Distribution.BucketOptions.Explicit)
        ExplicitOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Explicit.newBuilder() to construct.
      private Explicit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Explicit() {
        bounds_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Explicit(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownFieldProto3(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 9: {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  bounds_ = new java.util.ArrayList<java.lang.Double>();
                  mutable_bitField0_ |= 0x00000001;
                }
                bounds_.add(input.readDouble());
                break;
              }
              case 10: {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001) && input.getBytesUntilLimit() > 0) {
                  bounds_ = new java.util.ArrayList<java.lang.Double>();
                  mutable_bitField0_ |= 0x00000001;
                }
                while (input.getBytesUntilLimit() > 0) {
                  bounds_.add(input.readDouble());
                }
                input.popLimit(limit);
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
            bounds_ = java.util.Collections.unmodifiableList(bounds_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Distribution.BucketOptions.Explicit.class, com.google.api.Distribution.BucketOptions.Explicit.Builder.class);
      }

      public static final int BOUNDS_FIELD_NUMBER = 1;
      private java.util.List<java.lang.Double> bounds_;
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public java.util.List<java.lang.Double>
          getBoundsList() {
        return bounds_;
      }
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public int getBoundsCount() {
        return bounds_.size();
      }
      /**
       * <pre>
       * The values must be monotonically increasing.
       * </pre>
       *
       * <code>repeated double bounds = 1;</code>
       */
      public double getBounds(int index) {
        return bounds_.get(index);
      }
      private int boundsMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getSerializedSize();
        if (getBoundsList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(boundsMemoizedSerializedSize);
        }
        for (int i = 0; i < bounds_.size(); i++) {
          output.writeDoubleNoTag(bounds_.get(i));
        }
        unknownFields.writeTo(output);
      }

      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          dataSize = 8 * getBoundsList().size();
          size += dataSize;
          if (!getBoundsList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream
                .computeInt32SizeNoTag(dataSize);
          }
          boundsMemoizedSerializedSize = dataSize;
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.api.Distribution.BucketOptions.Explicit)) {
          return super.equals(obj);
        }
        com.google.api.Distribution.BucketOptions.Explicit other = (com.google.api.Distribution.BucketOptions.Explicit) obj;

        boolean result = true;
        result = result && getBoundsList()
            .equals(other.getBoundsList());
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getBoundsCount() > 0) {
          hash = (37 * hash) + BOUNDS_FIELD_NUMBER;
          hash = (53 * hash) + getBoundsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.api.Distribution.BucketOptions.Explicit parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.api.Distribution.BucketOptions.Explicit prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * A set of buckets with arbitrary widths.
       * Defines `size(bounds) + 1` (= N) buckets with these boundaries for
       * bucket i:
       *    Upper bound (0 &lt;= i &lt; N-1):     bounds[i]
       *    Lower bound (1 &lt;= i &lt; N);       bounds[i - 1]
       * There must be at least one element in `bounds`.  If `bounds` has only one
       * element, there are no finite buckets, and that single element is the
       * common boundary of the overflow and underflow buckets.
       * </pre>
       *
       * Protobuf type {@code google.api.Distribution.BucketOptions.Explicit}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions.Explicit)
          com.google.api.Distribution.BucketOptions.ExplicitOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
        }

        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.api.Distribution.BucketOptions.Explicit.class, com.google.api.Distribution.BucketOptions.Explicit.Builder.class);
        }

        // Construct using com.google.api.Distribution.BucketOptions.Explicit.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        public Builder clear() {
          super.clear();
          bounds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_Explicit_descriptor;
        }

        public com.google.api.Distribution.BucketOptions.Explicit getDefaultInstanceForType() {
          return com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        }

        public com.google.api.Distribution.BucketOptions.Explicit build() {
          com.google.api.Distribution.BucketOptions.Explicit result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public com.google.api.Distribution.BucketOptions.Explicit buildPartial() {
          com.google.api.Distribution.BucketOptions.Explicit result = new com.google.api.Distribution.BucketOptions.Explicit(this);
          int from_bitField0_ = bitField0_;
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            bounds_ = java.util.Collections.unmodifiableList(bounds_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.bounds_ = bounds_;
          onBuilt();
          return result;
        }

        public Builder clone() {
          return (Builder) super.clone();
        }
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.api.Distribution.BucketOptions.Explicit) {
            return mergeFrom((com.google.api.Distribution.BucketOptions.Explicit)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.api.Distribution.BucketOptions.Explicit other) {
          if (other == com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance()) return this;
          if (!other.bounds_.isEmpty()) {
            if (bounds_.isEmpty()) {
              bounds_ = other.bounds_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBoundsIsMutable();
              bounds_.addAll(other.bounds_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        public final boolean isInitialized() {
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.api.Distribution.BucketOptions.Explicit parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.api.Distribution.BucketOptions.Explicit) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<java.lang.Double> bounds_ = java.util.Collections.emptyList();
        private void ensureBoundsIsMutable() {
          if (!((bitField0_ & 0x00000001) == 0x00000001)) {
            bounds_ = new java.util.ArrayList<java.lang.Double>(bounds_);
            bitField0_ |= 0x00000001;
           }
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public java.util.List<java.lang.Double>
            getBoundsList() {
          return java.util.Collections.unmodifiableList(bounds_);
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public int getBoundsCount() {
          return bounds_.size();
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public double getBounds(int index) {
          return bounds_.get(index);
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder setBounds(
            int index, double value) {
          ensureBoundsIsMutable();
          bounds_.set(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder addBounds(double value) {
          ensureBoundsIsMutable();
          bounds_.add(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder addAllBounds(
            java.lang.Iterable<? extends java.lang.Double> values) {
          ensureBoundsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, bounds_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The values must be monotonically increasing.
         * </pre>
         *
         * <code>repeated double bounds = 1;</code>
         */
        public Builder clearBounds() {
          bounds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions.Explicit)
      }

      // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions.Explicit)
      private static final com.google.api.Distribution.BucketOptions.Explicit DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.api.Distribution.BucketOptions.Explicit();
      }

      public static com.google.api.Distribution.BucketOptions.Explicit getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Explicit>
          PARSER = new com.google.protobuf.AbstractParser<Explicit>() {
        public Explicit parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Explicit(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Explicit> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Explicit> getParserForType() {
        return PARSER;
      }

      public com.google.api.Distribution.BucketOptions.Explicit getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int optionsCase_ = 0;
    private java.lang.Object options_;
    public enum OptionsCase
        implements com.google.protobuf.Internal.EnumLite {
      LINEAR_BUCKETS(1),
      EXPONENTIAL_BUCKETS(2),
      EXPLICIT_BUCKETS(3),
      OPTIONS_NOT_SET(0);
      private final int value;
      private OptionsCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OptionsCase valueOf(int value) {
        return forNumber(value);
      }

      public static OptionsCase forNumber(int value) {
        switch (value) {
          case 1: return LINEAR_BUCKETS;
          case 2: return EXPONENTIAL_BUCKETS;
          case 3: return EXPLICIT_BUCKETS;
          case 0: return OPTIONS_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public OptionsCase
    getOptionsCase() {
      return OptionsCase.forNumber(
          optionsCase_);
    }

    public static final int LINEAR_BUCKETS_FIELD_NUMBER = 1;
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    public boolean hasLinearBuckets() {
      return optionsCase_ == 1;
    }
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    public com.google.api.Distribution.BucketOptions.Linear getLinearBuckets() {
      if (optionsCase_ == 1) {
         return (com.google.api.Distribution.BucketOptions.Linear) options_;
      }
      return com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
    }
    /**
     * <pre>
     * The linear bucket.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
     */
    public com.google.api.Distribution.BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder() {
      if (optionsCase_ == 1) {
         return (com.google.api.Distribution.BucketOptions.Linear) options_;
      }
      return com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
    }

    public static final int EXPONENTIAL_BUCKETS_FIELD_NUMBER = 2;
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    public boolean hasExponentialBuckets() {
      return optionsCase_ == 2;
    }
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    public com.google.api.Distribution.BucketOptions.Exponential getExponentialBuckets() {
      if (optionsCase_ == 2) {
         return (com.google.api.Distribution.BucketOptions.Exponential) options_;
      }
      return com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
    }
    /**
     * <pre>
     * The exponential buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
     */
    public com.google.api.Distribution.BucketOptions.ExponentialOrBuilder getExponentialBucketsOrBuilder() {
      if (optionsCase_ == 2) {
         return (com.google.api.Distribution.BucketOptions.Exponential) options_;
      }
      return com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
    }

    public static final int EXPLICIT_BUCKETS_FIELD_NUMBER = 3;
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    public boolean hasExplicitBuckets() {
      return optionsCase_ == 3;
    }
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    public com.google.api.Distribution.BucketOptions.Explicit getExplicitBuckets() {
      if (optionsCase_ == 3) {
         return (com.google.api.Distribution.BucketOptions.Explicit) options_;
      }
      return com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
    }
    /**
     * <pre>
     * The explicit buckets.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
     */
    public com.google.api.Distribution.BucketOptions.ExplicitOrBuilder getExplicitBucketsOrBuilder() {
      if (optionsCase_ == 3) {
         return (com.google.api.Distribution.BucketOptions.Explicit) options_;
      }
      return com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (optionsCase_ == 1) {
        output.writeMessage(1, (com.google.api.Distribution.BucketOptions.Linear) options_);
      }
      if (optionsCase_ == 2) {
        output.writeMessage(2, (com.google.api.Distribution.BucketOptions.Exponential) options_);
      }
      if (optionsCase_ == 3) {
        output.writeMessage(3, (com.google.api.Distribution.BucketOptions.Explicit) options_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (optionsCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (com.google.api.Distribution.BucketOptions.Linear) options_);
      }
      if (optionsCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (com.google.api.Distribution.BucketOptions.Exponential) options_);
      }
      if (optionsCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (com.google.api.Distribution.BucketOptions.Explicit) options_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.api.Distribution.BucketOptions)) {
        return super.equals(obj);
      }
      com.google.api.Distribution.BucketOptions other = (com.google.api.Distribution.BucketOptions) obj;

      boolean result = true;
      result = result && getOptionsCase().equals(
          other.getOptionsCase());
      if (!result) return false;
      switch (optionsCase_) {
        case 1:
          result = result && getLinearBuckets()
              .equals(other.getLinearBuckets());
          break;
        case 2:
          result = result && getExponentialBuckets()
              .equals(other.getExponentialBuckets());
          break;
        case 3:
          result = result && getExplicitBuckets()
              .equals(other.getExplicitBuckets());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (optionsCase_) {
        case 1:
          hash = (37 * hash) + LINEAR_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getLinearBuckets().hashCode();
          break;
        case 2:
          hash = (37 * hash) + EXPONENTIAL_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExponentialBuckets().hashCode();
          break;
        case 3:
          hash = (37 * hash) + EXPLICIT_BUCKETS_FIELD_NUMBER;
          hash = (53 * hash) + getExplicitBuckets().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.Distribution.BucketOptions parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.api.Distribution.BucketOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.api.Distribution.BucketOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.api.Distribution.BucketOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.api.Distribution.BucketOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A Distribution may optionally contain a histogram of the values in the
     * population.  The histogram is given in `bucket_counts` as counts of values
     * that fall into one of a sequence of non-overlapping buckets.  The sequence
     * of buckets is described by `bucket_options`.
     * A bucket specifies an inclusive lower bound and exclusive upper bound for
     * the values that are counted for that bucket.  The upper bound of a bucket
     * is strictly greater than the lower bound.
     * The sequence of N buckets for a Distribution consists of an underflow
     * bucket (number 0), zero or more finite buckets (number 1 through N - 2) and
     * an overflow bucket (number N - 1).  The buckets are contiguous:  the lower
     * bound of bucket i (i &gt; 0) is the same as the upper bound of bucket i - 1.
     * The buckets span the whole range of finite values: lower bound of the
     * underflow bucket is -infinity and the upper bound of the overflow bucket is
     * +infinity.  The finite buckets are so-called because both bounds are
     * finite.
     * `BucketOptions` describes bucket boundaries in one of three ways.  Two
     * describe the boundaries by giving parameters for a formula to generate
     * boundaries and one gives the bucket boundaries explicitly.
     * If `bucket_boundaries` is not given, then no `bucket_counts` may be given.
     * </pre>
     *
     * Protobuf type {@code google.api.Distribution.BucketOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.api.Distribution.BucketOptions)
        com.google.api.Distribution.BucketOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Distribution.BucketOptions.class, com.google.api.Distribution.BucketOptions.Builder.class);
      }

      // Construct using com.google.api.Distribution.BucketOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        optionsCase_ = 0;
        options_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.api.DistributionProto.internal_static_google_api_Distribution_BucketOptions_descriptor;
      }

      public com.google.api.Distribution.BucketOptions getDefaultInstanceForType() {
        return com.google.api.Distribution.BucketOptions.getDefaultInstance();
      }

      public com.google.api.Distribution.BucketOptions build() {
        com.google.api.Distribution.BucketOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.google.api.Distribution.BucketOptions buildPartial() {
        com.google.api.Distribution.BucketOptions result = new com.google.api.Distribution.BucketOptions(this);
        if (optionsCase_ == 1) {
          if (linearBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = linearBucketsBuilder_.build();
          }
        }
        if (optionsCase_ == 2) {
          if (exponentialBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = exponentialBucketsBuilder_.build();
          }
        }
        if (optionsCase_ == 3) {
          if (explicitBucketsBuilder_ == null) {
            result.options_ = options_;
          } else {
            result.options_ = explicitBucketsBuilder_.build();
          }
        }
        result.optionsCase_ = optionsCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.Distribution.BucketOptions) {
          return mergeFrom((com.google.api.Distribution.BucketOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.api.Distribution.BucketOptions other) {
        if (other == com.google.api.Distribution.BucketOptions.getDefaultInstance()) return this;
        switch (other.getOptionsCase()) {
          case LINEAR_BUCKETS: {
            mergeLinearBuckets(other.getLinearBuckets());
            break;
          }
          case EXPONENTIAL_BUCKETS: {
            mergeExponentialBuckets(other.getExponentialBuckets());
            break;
          }
          case EXPLICIT_BUCKETS: {
            mergeExplicitBuckets(other.getExplicitBuckets());
            break;
          }
          case OPTIONS_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.api.Distribution.BucketOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.api.Distribution.BucketOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int optionsCase_ = 0;
      private java.lang.Object options_;
      public OptionsCase
          getOptionsCase() {
        return OptionsCase.forNumber(
            optionsCase_);
      }

      public Builder clearOptions() {
        optionsCase_ = 0;
        options_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.api.Distribution.BucketOptions.Linear, com.google.api.Distribution.BucketOptions.Linear.Builder, com.google.api.Distribution.BucketOptions.LinearOrBuilder> linearBucketsBuilder_;
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public boolean hasLinearBuckets() {
        return optionsCase_ == 1;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public com.google.api.Distribution.BucketOptions.Linear getLinearBuckets() {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1) {
            return (com.google.api.Distribution.BucketOptions.Linear) options_;
          }
          return com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        } else {
          if (optionsCase_ == 1) {
            return linearBucketsBuilder_.getMessage();
          }
          return com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder setLinearBuckets(com.google.api.Distribution.BucketOptions.Linear value) {
        if (linearBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          linearBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder setLinearBuckets(
          com.google.api.Distribution.BucketOptions.Linear.Builder builderForValue) {
        if (linearBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          linearBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder mergeLinearBuckets(com.google.api.Distribution.BucketOptions.Linear value) {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1 &&
              options_ != com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance()) {
            options_ = com.google.api.Distribution.BucketOptions.Linear.newBuilder((com.google.api.Distribution.BucketOptions.Linear) options_)
                .mergeFrom(value).buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 1) {
            linearBucketsBuilder_.mergeFrom(value);
          }
          linearBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public Builder clearLinearBuckets() {
        if (linearBucketsBuilder_ == null) {
          if (optionsCase_ == 1) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 1) {
            optionsCase_ = 0;
            options_ = null;
          }
          linearBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public com.google.api.Distribution.BucketOptions.Linear.Builder getLinearBucketsBuilder() {
        return getLinearBucketsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      public com.google.api.Distribution.BucketOptions.LinearOrBuilder getLinearBucketsOrBuilder() {
        if ((optionsCase_ == 1) && (linearBucketsBuilder_ != null)) {
          return linearBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 1) {
            return (com.google.api.Distribution.BucketOptions.Linear) options_;
          }
          return com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The linear bucket.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Linear linear_buckets = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.api.Distribution.BucketOptions.Linear, com.google.api.Distribution.BucketOptions.Linear.Builder, com.google.api.Distribution.BucketOptions.LinearOrBuilder> 
          getLinearBucketsFieldBuilder() {
        if (linearBucketsBuilder_ == null) {
          if (!(optionsCase_ == 1)) {
            options_ = com.google.api.Distribution.BucketOptions.Linear.getDefaultInstance();
          }
          linearBucketsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.api.Distribution.BucketOptions.Linear, com.google.api.Distribution.BucketOptions.Linear.Builder, com.google.api.Distribution.BucketOptions.LinearOrBuilder>(
                  (com.google.api.Distribution.BucketOptions.Linear) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 1;
        onChanged();;
        return linearBucketsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.api.Distribution.BucketOptions.Exponential, com.google.api.Distribution.BucketOptions.Exponential.Builder, com.google.api.Distribution.BucketOptions.ExponentialOrBuilder> exponentialBucketsBuilder_;
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public boolean hasExponentialBuckets() {
        return optionsCase_ == 2;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public com.google.api.Distribution.BucketOptions.Exponential getExponentialBuckets() {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2) {
            return (com.google.api.Distribution.BucketOptions.Exponential) options_;
          }
          return com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        } else {
          if (optionsCase_ == 2) {
            return exponentialBucketsBuilder_.getMessage();
          }
          return com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder setExponentialBuckets(com.google.api.Distribution.BucketOptions.Exponential value) {
        if (exponentialBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          exponentialBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder setExponentialBuckets(
          com.google.api.Distribution.BucketOptions.Exponential.Builder builderForValue) {
        if (exponentialBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          exponentialBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder mergeExponentialBuckets(com.google.api.Distribution.BucketOptions.Exponential value) {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2 &&
              options_ != com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance()) {
            options_ = com.google.api.Distribution.BucketOptions.Exponential.newBuilder((com.google.api.Distribution.BucketOptions.Exponential) options_)
                .mergeFrom(value).buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 2) {
            exponentialBucketsBuilder_.mergeFrom(value);
          }
          exponentialBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public Builder clearExponentialBuckets() {
        if (exponentialBucketsBuilder_ == null) {
          if (optionsCase_ == 2) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 2) {
            optionsCase_ = 0;
            options_ = null;
          }
          exponentialBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public com.google.api.Distribution.BucketOptions.Exponential.Builder getExponentialBucketsBuilder() {
        return getExponentialBucketsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      public com.google.api.Distribution.BucketOptions.ExponentialOrBuilder getExponentialBucketsOrBuilder() {
        if ((optionsCase_ == 2) && (exponentialBucketsBuilder_ != null)) {
          return exponentialBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 2) {
            return (com.google.api.Distribution.BucketOptions.Exponential) options_;
          }
          return com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The exponential buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Exponential exponential_buckets = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.api.Distribution.BucketOptions.Exponential, com.google.api.Distribution.BucketOptions.Exponential.Builder, com.google.api.Distribution.BucketOptions.ExponentialOrBuilder> 
          getExponentialBucketsFieldBuilder() {
        if (exponentialBucketsBuilder_ == null) {
          if (!(optionsCase_ == 2)) {
            options_ = com.google.api.Distribution.BucketOptions.Exponential.getDefaultInstance();
          }
          exponentialBucketsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.api.Distribution.BucketOptions.Exponential, com.google.api.Distribution.BucketOptions.Exponential.Builder, com.google.api.Distribution.BucketOptions.ExponentialOrBuilder>(
                  (com.google.api.Distribution.BucketOptions.Exponential) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 2;
        onChanged();;
        return exponentialBucketsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.api.Distribution.BucketOptions.Explicit, com.google.api.Distribution.BucketOptions.Explicit.Builder, com.google.api.Distribution.BucketOptions.ExplicitOrBuilder> explicitBucketsBuilder_;
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public boolean hasExplicitBuckets() {
        return optionsCase_ == 3;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public com.google.api.Distribution.BucketOptions.Explicit getExplicitBuckets() {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3) {
            return (com.google.api.Distribution.BucketOptions.Explicit) options_;
          }
          return com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        } else {
          if (optionsCase_ == 3) {
            return explicitBucketsBuilder_.getMessage();
          }
          return com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder setExplicitBuckets(com.google.api.Distribution.BucketOptions.Explicit value) {
        if (explicitBucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          options_ = value;
          onChanged();
        } else {
          explicitBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder setExplicitBuckets(
          com.google.api.Distribution.BucketOptions.Explicit.Builder builderForValue) {
        if (explicitBucketsBuilder_ == null) {
          options_ = builderForValue.build();
          onChanged();
        } else {
          explicitBucketsBuilder_.setMessage(builderForValue.build());
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder mergeExplicitBuckets(com.google.api.Distribution.BucketOptions.Explicit value) {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3 &&
              options_ != com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance()) {
            options_ = com.google.api.Distribution.BucketOptions.Explicit.newBuilder((com.google.api.Distribution.BucketOptions.Explicit) options_)
                .mergeFrom(value).buildPartial();
          } else {
            options_ = value;
          }
          onChanged();
        } else {
          if (optionsCase_ == 3) {
            explicitBucketsBuilder_.mergeFrom(value);
          }
          explicitBucketsBuilder_.setMessage(value);
        }
        optionsCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public Builder clearExplicitBuckets() {
        if (explicitBucketsBuilder_ == null) {
          if (optionsCase_ == 3) {
            optionsCase_ = 0;
            options_ = null;
            onChanged();
          }
        } else {
          if (optionsCase_ == 3) {
            optionsCase_ = 0;
            options_ = null;
          }
          explicitBucketsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public com.google.api.Distribution.BucketOptions.Explicit.Builder getExplicitBucketsBuilder() {
        return getExplicitBucketsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      public com.google.api.Distribution.BucketOptions.ExplicitOrBuilder getExplicitBucketsOrBuilder() {
        if ((optionsCase_ == 3) && (explicitBucketsBuilder_ != null)) {
          return explicitBucketsBuilder_.getMessageOrBuilder();
        } else {
          if (optionsCase_ == 3) {
            return (com.google.api.Distribution.BucketOptions.Explicit) options_;
          }
          return com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * The explicit buckets.
       * </pre>
       *
       * <code>.google.api.Distribution.BucketOptions.Explicit explicit_buckets = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.api.Distribution.BucketOptions.Explicit, com.google.api.Distribution.BucketOptions.Explicit.Builder, com.google.api.Distribution.BucketOptions.ExplicitOrBuilder> 
          getExplicitBucketsFieldBuilder() {
        if (explicitBucketsBuilder_ == null) {
          if (!(optionsCase_ == 3)) {
            options_ = com.google.api.Distribution.BucketOptions.Explicit.getDefaultInstance();
          }
          explicitBucketsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.api.Distribution.BucketOptions.Explicit, com.google.api.Distribution.BucketOptions.Explicit.Builder, com.google.api.Distribution.BucketOptions.ExplicitOrBuilder>(
                  (com.google.api.Distribution.BucketOptions.Explicit) options_,
                  getParentForChildren(),
                  isClean());
          options_ = null;
        }
        optionsCase_ = 3;
        onChanged();;
        return explicitBucketsBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.api.Distribution.BucketOptions)
    }

    // @@protoc_insertion_point(class_scope:google.api.Distribution.BucketOptions)
    private static final com.google.api.Distribution.BucketOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.api.Distribution.BucketOptions();
    }

    public static com.google.api.Distribution.BucketOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BucketOptions>
        PARSER = new com.google.protobuf.AbstractParser<BucketOptions>() {
      public BucketOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BucketOptions(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<BucketOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BucketOptions> getParserForType() {
      return PARSER;
    }

    public com.google.api.Distribution.BucketOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  public static final int COUNT_FIELD_NUMBER = 1;
  private long count_;
  /**
   * <pre>
   * The number of values in the population. Must be non-negative.
   * </pre>
   *
   * <code>int64 count = 1;</code>
   */
  public long getCount() {
    return count_;
  }

  public static final int MEAN_FIELD_NUMBER = 2;
  private double mean_;
  /**
   * <pre>
   * The arithmetic mean of the values in the population. If `count` is zero
   * then this field must be zero.
   * </pre>
   *
   * <code>double mean = 2;</code>
   */
  public double getMean() {
    return mean_;
  }

  public static final int SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER = 3;
  private double sumOfSquaredDeviation_;
  /**
   * <pre>
   * The sum of squared deviations from the mean of the values in the
   * population.  For values x_i this is:
   *     Sum[i=1..n]((x_i - mean)^2)
   * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
   * describes Welford's method for accumulating this sum in one pass.
   * If `count` is zero then this field must be zero.
   * </pre>
   *
   * <code>double sum_of_squared_deviation = 3;</code>
   */
  public double getSumOfSquaredDeviation() {
    return sumOfSquaredDeviation_;
  }

  public static final int RANGE_FIELD_NUMBER = 4;
  private com.google.api.Distribution.Range range_;
  /**
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  public boolean hasRange() {
    return range_ != null;
  }
  /**
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  public com.google.api.Distribution.Range getRange() {
    return range_ == null ? com.google.api.Distribution.Range.getDefaultInstance() : range_;
  }
  /**
   * <pre>
   * If specified, contains the range of the population values. The field
   * must not be present if the `count` is zero.
   * </pre>
   *
   * <code>.google.api.Distribution.Range range = 4;</code>
   */
  public com.google.api.Distribution.RangeOrBuilder getRangeOrBuilder() {
    return getRange();
  }

  public static final int BUCKET_OPTIONS_FIELD_NUMBER = 6;
  private com.google.api.Distribution.BucketOptions bucketOptions_;
  /**
   * <pre>
   * Defines the histogram bucket boundaries.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  public boolean hasBucketOptions() {
    return bucketOptions_ != null;
  }
  /**
   * <pre>
   * Defines the histogram bucket boundaries.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  public com.google.api.Distribution.BucketOptions getBucketOptions() {
    return bucketOptions_ == null ? com.google.api.Distribution.BucketOptions.getDefaultInstance() : bucketOptions_;
  }
  /**
   * <pre>
   * Defines the histogram bucket boundaries.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
   */
  public com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
    return getBucketOptions();
  }

  public static final int BUCKET_COUNTS_FIELD_NUMBER = 7;
  private java.util.List<java.lang.Long> bucketCounts_;
  /**
   * <pre>
   * If `bucket_options` is given, then the sum of the values in `bucket_counts`
   * must equal the value in `count`.  If `bucket_options` is not given, no
   * `bucket_counts` fields may be given.
   * Bucket counts are given in order under the numbering scheme described
   * above (the underflow bucket has number 0; the finite buckets, if any,
   * have numbers 1 through N-2; the overflow bucket has number N-1).
   * The size of `bucket_counts` must be no greater than N as defined in
   * `bucket_options`.
   * Any suffix of trailing zero bucket_count fields may be omitted.
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   */
  public java.util.List<java.lang.Long>
      getBucketCountsList() {
    return bucketCounts_;
  }
  /**
   * <pre>
   * If `bucket_options` is given, then the sum of the values in `bucket_counts`
   * must equal the value in `count`.  If `bucket_options` is not given, no
   * `bucket_counts` fields may be given.
   * Bucket counts are given in order under the numbering scheme described
   * above (the underflow bucket has number 0; the finite buckets, if any,
   * have numbers 1 through N-2; the overflow bucket has number N-1).
   * The size of `bucket_counts` must be no greater than N as defined in
   * `bucket_options`.
   * Any suffix of trailing zero bucket_count fields may be omitted.
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   */
  public int getBucketCountsCount() {
    return bucketCounts_.size();
  }
  /**
   * <pre>
   * If `bucket_options` is given, then the sum of the values in `bucket_counts`
   * must equal the value in `count`.  If `bucket_options` is not given, no
   * `bucket_counts` fields may be given.
   * Bucket counts are given in order under the numbering scheme described
   * above (the underflow bucket has number 0; the finite buckets, if any,
   * have numbers 1 through N-2; the overflow bucket has number N-1).
   * The size of `bucket_counts` must be no greater than N as defined in
   * `bucket_options`.
   * Any suffix of trailing zero bucket_count fields may be omitted.
   * </pre>
   *
   * <code>repeated int64 bucket_counts = 7;</code>
   */
  public long getBucketCounts(int index) {
    return bucketCounts_.get(index);
  }
  private int bucketCountsMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (count_ != 0L) {
      output.writeInt64(1, count_);
    }
    if (mean_ != 0D) {
      output.writeDouble(2, mean_);
    }
    if (sumOfSquaredDeviation_ != 0D) {
      output.writeDouble(3, sumOfSquaredDeviation_);
    }
    if (range_ != null) {
      output.writeMessage(4, getRange());
    }
    if (bucketOptions_ != null) {
      output.writeMessage(6, getBucketOptions());
    }
    if (getBucketCountsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(bucketCountsMemoizedSerializedSize);
    }
    for (int i = 0; i < bucketCounts_.size(); i++) {
      output.writeInt64NoTag(bucketCounts_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (count_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(1, count_);
    }
    if (mean_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(2, mean_);
    }
    if (sumOfSquaredDeviation_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(3, sumOfSquaredDeviation_);
    }
    if (range_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getRange());
    }
    if (bucketOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getBucketOptions());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < bucketCounts_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeInt64SizeNoTag(bucketCounts_.get(i));
      }
      size += dataSize;
      if (!getBucketCountsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      bucketCountsMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.Distribution)) {
      return super.equals(obj);
    }
    com.google.api.Distribution other = (com.google.api.Distribution) obj;

    boolean result = true;
    result = result && (getCount()
        == other.getCount());
    result = result && (
        java.lang.Double.doubleToLongBits(getMean())
        == java.lang.Double.doubleToLongBits(
            other.getMean()));
    result = result && (
        java.lang.Double.doubleToLongBits(getSumOfSquaredDeviation())
        == java.lang.Double.doubleToLongBits(
            other.getSumOfSquaredDeviation()));
    result = result && (hasRange() == other.hasRange());
    if (hasRange()) {
      result = result && getRange()
          .equals(other.getRange());
    }
    result = result && (hasBucketOptions() == other.hasBucketOptions());
    if (hasBucketOptions()) {
      result = result && getBucketOptions()
          .equals(other.getBucketOptions());
    }
    result = result && getBucketCountsList()
        .equals(other.getBucketCountsList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getCount());
    hash = (37 * hash) + MEAN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getMean()));
    hash = (37 * hash) + SUM_OF_SQUARED_DEVIATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getSumOfSquaredDeviation()));
    if (hasRange()) {
      hash = (37 * hash) + RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getRange().hashCode();
    }
    if (hasBucketOptions()) {
      hash = (37 * hash) + BUCKET_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketOptions().hashCode();
    }
    if (getBucketCountsCount() > 0) {
      hash = (37 * hash) + BUCKET_COUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketCountsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Distribution parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Distribution parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Distribution parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Distribution parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Distribution parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Distribution parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Distribution parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.Distribution parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.Distribution parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.Distribution parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.Distribution parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.Distribution parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.Distribution prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Distribution contains summary statistics for a population of values and,
   * optionally, a histogram representing the distribution of those values across
   * a specified set of histogram buckets.
   * The summary statistics are the count, mean, sum of the squared deviation from
   * the mean, the minimum, and the maximum of the set of population of values.
   * The histogram is based on a sequence of buckets and gives a count of values
   * that fall into each bucket.  The boundaries of the buckets are given either
   * explicitly or by specifying parameters for a method of computing them
   * (buckets of fixed width or buckets of exponentially increasing width).
   * Although it is not forbidden, it is generally a bad idea to include
   * non-finite values (infinities or NaNs) in the population of values, as this
   * will render the `mean` and `sum_of_squared_deviation` fields meaningless.
   * </pre>
   *
   * Protobuf type {@code google.api.Distribution}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.Distribution)
      com.google.api.DistributionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Distribution.class, com.google.api.Distribution.Builder.class);
    }

    // Construct using com.google.api.Distribution.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      count_ = 0L;

      mean_ = 0D;

      sumOfSquaredDeviation_ = 0D;

      if (rangeBuilder_ == null) {
        range_ = null;
      } else {
        range_ = null;
        rangeBuilder_ = null;
      }
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }
      bucketCounts_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.DistributionProto.internal_static_google_api_Distribution_descriptor;
    }

    public com.google.api.Distribution getDefaultInstanceForType() {
      return com.google.api.Distribution.getDefaultInstance();
    }

    public com.google.api.Distribution build() {
      com.google.api.Distribution result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.api.Distribution buildPartial() {
      com.google.api.Distribution result = new com.google.api.Distribution(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.count_ = count_;
      result.mean_ = mean_;
      result.sumOfSquaredDeviation_ = sumOfSquaredDeviation_;
      if (rangeBuilder_ == null) {
        result.range_ = range_;
      } else {
        result.range_ = rangeBuilder_.build();
      }
      if (bucketOptionsBuilder_ == null) {
        result.bucketOptions_ = bucketOptions_;
      } else {
        result.bucketOptions_ = bucketOptionsBuilder_.build();
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        bucketCounts_ = java.util.Collections.unmodifiableList(bucketCounts_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.bucketCounts_ = bucketCounts_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Distribution) {
        return mergeFrom((com.google.api.Distribution)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Distribution other) {
      if (other == com.google.api.Distribution.getDefaultInstance()) return this;
      if (other.getCount() != 0L) {
        setCount(other.getCount());
      }
      if (other.getMean() != 0D) {
        setMean(other.getMean());
      }
      if (other.getSumOfSquaredDeviation() != 0D) {
        setSumOfSquaredDeviation(other.getSumOfSquaredDeviation());
      }
      if (other.hasRange()) {
        mergeRange(other.getRange());
      }
      if (other.hasBucketOptions()) {
        mergeBucketOptions(other.getBucketOptions());
      }
      if (!other.bucketCounts_.isEmpty()) {
        if (bucketCounts_.isEmpty()) {
          bucketCounts_ = other.bucketCounts_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureBucketCountsIsMutable();
          bucketCounts_.addAll(other.bucketCounts_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.Distribution parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.Distribution) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private long count_ ;
    /**
     * <pre>
     * The number of values in the population. Must be non-negative.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public long getCount() {
      return count_;
    }
    /**
     * <pre>
     * The number of values in the population. Must be non-negative.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public Builder setCount(long value) {
      
      count_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The number of values in the population. Must be non-negative.
     * </pre>
     *
     * <code>int64 count = 1;</code>
     */
    public Builder clearCount() {
      
      count_ = 0L;
      onChanged();
      return this;
    }

    private double mean_ ;
    /**
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public double getMean() {
      return mean_;
    }
    /**
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public Builder setMean(double value) {
      
      mean_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The arithmetic mean of the values in the population. If `count` is zero
     * then this field must be zero.
     * </pre>
     *
     * <code>double mean = 2;</code>
     */
    public Builder clearMean() {
      
      mean_ = 0D;
      onChanged();
      return this;
    }

    private double sumOfSquaredDeviation_ ;
    /**
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population.  For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     */
    public double getSumOfSquaredDeviation() {
      return sumOfSquaredDeviation_;
    }
    /**
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population.  For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     */
    public Builder setSumOfSquaredDeviation(double value) {
      
      sumOfSquaredDeviation_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The sum of squared deviations from the mean of the values in the
     * population.  For values x_i this is:
     *     Sum[i=1..n]((x_i - mean)^2)
     * Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
     * describes Welford's method for accumulating this sum in one pass.
     * If `count` is zero then this field must be zero.
     * </pre>
     *
     * <code>double sum_of_squared_deviation = 3;</code>
     */
    public Builder clearSumOfSquaredDeviation() {
      
      sumOfSquaredDeviation_ = 0D;
      onChanged();
      return this;
    }

    private com.google.api.Distribution.Range range_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.Distribution.Range, com.google.api.Distribution.Range.Builder, com.google.api.Distribution.RangeOrBuilder> rangeBuilder_;
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public boolean hasRange() {
      return rangeBuilder_ != null || range_ != null;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public com.google.api.Distribution.Range getRange() {
      if (rangeBuilder_ == null) {
        return range_ == null ? com.google.api.Distribution.Range.getDefaultInstance() : range_;
      } else {
        return rangeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder setRange(com.google.api.Distribution.Range value) {
      if (rangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        range_ = value;
        onChanged();
      } else {
        rangeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder setRange(
        com.google.api.Distribution.Range.Builder builderForValue) {
      if (rangeBuilder_ == null) {
        range_ = builderForValue.build();
        onChanged();
      } else {
        rangeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder mergeRange(com.google.api.Distribution.Range value) {
      if (rangeBuilder_ == null) {
        if (range_ != null) {
          range_ =
            com.google.api.Distribution.Range.newBuilder(range_).mergeFrom(value).buildPartial();
        } else {
          range_ = value;
        }
        onChanged();
      } else {
        rangeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public Builder clearRange() {
      if (rangeBuilder_ == null) {
        range_ = null;
        onChanged();
      } else {
        range_ = null;
        rangeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public com.google.api.Distribution.Range.Builder getRangeBuilder() {
      
      onChanged();
      return getRangeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    public com.google.api.Distribution.RangeOrBuilder getRangeOrBuilder() {
      if (rangeBuilder_ != null) {
        return rangeBuilder_.getMessageOrBuilder();
      } else {
        return range_ == null ?
            com.google.api.Distribution.Range.getDefaultInstance() : range_;
      }
    }
    /**
     * <pre>
     * If specified, contains the range of the population values. The field
     * must not be present if the `count` is zero.
     * </pre>
     *
     * <code>.google.api.Distribution.Range range = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.Distribution.Range, com.google.api.Distribution.Range.Builder, com.google.api.Distribution.RangeOrBuilder> 
        getRangeFieldBuilder() {
      if (rangeBuilder_ == null) {
        rangeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Distribution.Range, com.google.api.Distribution.Range.Builder, com.google.api.Distribution.RangeOrBuilder>(
                getRange(),
                getParentForChildren(),
                isClean());
        range_ = null;
      }
      return rangeBuilder_;
    }

    private com.google.api.Distribution.BucketOptions bucketOptions_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.Distribution.BucketOptions, com.google.api.Distribution.BucketOptions.Builder, com.google.api.Distribution.BucketOptionsOrBuilder> bucketOptionsBuilder_;
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public boolean hasBucketOptions() {
      return bucketOptionsBuilder_ != null || bucketOptions_ != null;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public com.google.api.Distribution.BucketOptions getBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        return bucketOptions_ == null ? com.google.api.Distribution.BucketOptions.getDefaultInstance() : bucketOptions_;
      } else {
        return bucketOptionsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder setBucketOptions(com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOptions_ = value;
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder setBucketOptions(
        com.google.api.Distribution.BucketOptions.Builder builderForValue) {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = builderForValue.build();
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder mergeBucketOptions(com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (bucketOptions_ != null) {
          bucketOptions_ =
            com.google.api.Distribution.BucketOptions.newBuilder(bucketOptions_).mergeFrom(value).buildPartial();
        } else {
          bucketOptions_ = value;
        }
        onChanged();
      } else {
        bucketOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public Builder clearBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
        onChanged();
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public com.google.api.Distribution.BucketOptions.Builder getBucketOptionsBuilder() {
      
      onChanged();
      return getBucketOptionsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    public com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
      if (bucketOptionsBuilder_ != null) {
        return bucketOptionsBuilder_.getMessageOrBuilder();
      } else {
        return bucketOptions_ == null ?
            com.google.api.Distribution.BucketOptions.getDefaultInstance() : bucketOptions_;
      }
    }
    /**
     * <pre>
     * Defines the histogram bucket boundaries.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.api.Distribution.BucketOptions, com.google.api.Distribution.BucketOptions.Builder, com.google.api.Distribution.BucketOptionsOrBuilder> 
        getBucketOptionsFieldBuilder() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptionsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Distribution.BucketOptions, com.google.api.Distribution.BucketOptions.Builder, com.google.api.Distribution.BucketOptionsOrBuilder>(
                getBucketOptions(),
                getParentForChildren(),
                isClean());
        bucketOptions_ = null;
      }
      return bucketOptionsBuilder_;
    }

    private java.util.List<java.lang.Long> bucketCounts_ = java.util.Collections.emptyList();
    private void ensureBucketCountsIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        bucketCounts_ = new java.util.ArrayList<java.lang.Long>(bucketCounts_);
        bitField0_ |= 0x00000020;
       }
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public java.util.List<java.lang.Long>
        getBucketCountsList() {
      return java.util.Collections.unmodifiableList(bucketCounts_);
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public int getBucketCountsCount() {
      return bucketCounts_.size();
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public long getBucketCounts(int index) {
      return bucketCounts_.get(index);
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder setBucketCounts(
        int index, long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder addBucketCounts(long value) {
      ensureBucketCountsIsMutable();
      bucketCounts_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder addAllBucketCounts(
        java.lang.Iterable<? extends java.lang.Long> values) {
      ensureBucketCountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, bucketCounts_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If `bucket_options` is given, then the sum of the values in `bucket_counts`
     * must equal the value in `count`.  If `bucket_options` is not given, no
     * `bucket_counts` fields may be given.
     * Bucket counts are given in order under the numbering scheme described
     * above (the underflow bucket has number 0; the finite buckets, if any,
     * have numbers 1 through N-2; the overflow bucket has number N-1).
     * The size of `bucket_counts` must be no greater than N as defined in
     * `bucket_options`.
     * Any suffix of trailing zero bucket_count fields may be omitted.
     * </pre>
     *
     * <code>repeated int64 bucket_counts = 7;</code>
     */
    public Builder clearBucketCounts() {
      bucketCounts_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.api.Distribution)
  }

  // @@protoc_insertion_point(class_scope:google.api.Distribution)
  private static final com.google.api.Distribution DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.Distribution();
  }

  public static com.google.api.Distribution getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Distribution>
      PARSER = new com.google.protobuf.AbstractParser<Distribution>() {
    public Distribution parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Distribution(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Distribution> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Distribution> getParserForType() {
    return PARSER;
  }

  public com.google.api.Distribution getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

