/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.MethodName;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.tracing.MetricsTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@BetaApi
@InternalApi
public class MetricsTracerFactory
implements ApiTracerFactory {
    protected MetricsRecorder metricsRecorder;
    private final Map<String, String> attributes;

    public MetricsTracerFactory(MetricsRecorder metricsRecorder) {
        this(metricsRecorder, (Map<String, String>)ImmutableMap.of());
    }

    public MetricsTracerFactory(MetricsRecorder metricsRecorder, Map<String, String> attributes) {
        this.metricsRecorder = metricsRecorder;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        MetricsTracer metricsTracer = new MetricsTracer(MethodName.of(spanName.getClientName(), spanName.getMethodName()), this.metricsRecorder);
        this.attributes.forEach(metricsTracer::addAttributes);
        return metricsTracer;
    }
}

