/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.viewer;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.ControllerFactory;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingControllerFactory;
import org.icepdf.ri.common.SwingViewBuilderFactory;
import org.icepdf.ri.common.ViewBuilder;
import org.icepdf.ri.common.ViewBuilderFactory;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.WindowManagementCallback;
import org.icepdf.ri.common.print.PrintHelper;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class WindowManager
implements WindowManagementCallback {
    public static final String APPLICATION_WIDTH = "application.width";
    public static final String APPLICATION_HEIGHT = "application.height";
    public static final String APPLICATION_X_OFFSET = "application.x";
    public static final String APPLICATION_Y_OFFSET = "application.y";
    public static final int NEW_WINDOW_OFFSET = 10;
    private static WindowManager windowManager;
    private ViewerPropertiesManager properties;
    private ArrayList<Controller> controllers;
    private static int newWindowInvocationCounter;
    private ResourceBundle messageBundle = null;
    public static ControllerFactory controllerFactory;
    public static final ViewBuilderFactory viewBuilderFactory;

    private WindowManager() {
    }

    public static WindowManager getInstance() {
        return windowManager;
    }

    public static WindowManager createInstance(ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        windowManager = new WindowManager();
        WindowManager.windowManager.properties = viewerPropertiesManager;
        WindowManager.windowManager.controllers = new ArrayList();
        WindowManager.windowManager.messageBundle = resourceBundle != null ? resourceBundle : ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        if (Defs.booleanProperty((String)"org.icepdf.core.verbose", (boolean)true)) {
            System.out.println("\nICEpdf Viewer " + Document.getLibraryVersion());
        }
        return windowManager;
    }

    @Override
    public ViewerPropertiesManager getProperties() {
        return this.properties;
    }

    public long getNumberOfWindows() {
        return newWindowInvocationCounter;
    }

    @Override
    public Collection<Controller> getControllers() {
        return this.controllers;
    }

    @Override
    public void newWindow(String string) {
        Controller controller = this.commonWindowCreation();
        controller.openDocument(string);
    }

    public void newWindow(Document document, String string) {
        Controller controller = this.commonWindowCreation();
        controller.openDocument(document, string);
    }

    @Override
    public void newWindow(URL uRL) {
        Controller controller = this.commonWindowCreation();
        controller.openDocument(uRL);
    }

    public void newWindow(String string, String string2) {
        Controller controller = this.commonWindowCreation(false);
        controller.openDocument(string);
        this.print(controller, string2);
    }

    public void newWindow(Document document, String string, String string2) {
        Controller controller = this.commonWindowCreation(false);
        controller.openDocument(document, string);
        this.print(controller, string2);
    }

    public void newWindow(URL uRL, String string) {
        Controller controller = this.commonWindowCreation(false);
        controller.openDocument(uRL);
        this.print(controller, string);
    }

    private void print(Controller controller, String string) {
        controller.printAndExit(!PrintHelper.hasPrinter(string), string);
        this.quit(controller, controller.getViewerFrame(), controller.getPropertiesManager().getPreferences());
    }

    protected Controller commonWindowCreation() {
        return this.commonWindowCreation(true);
    }

    protected Controller commonWindowCreation(boolean bl) {
        SwingController swingController = new SwingController(this.messageBundle);
        swingController.setWindowManagementCallback(this);
        swingController.getDocumentViewController().setAnnotationCallback(new MyAnnotationCallback(swingController.getDocumentViewController()));
        this.controllers.add(swingController);
        int n = 1;
        int n2 = 4;
        float f = 0.0f;
        Preferences preferences = this.getProperties().getPreferences();
        try {
            n = preferences.getInt("document.viewtype", 1);
            n2 = preferences.getInt("document.pagefit.mode", 4);
            f = preferences.getFloat("document.rotation", f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ViewBuilder viewBuilder = viewBuilderFactory.create(swingController, n, n2, f);
        JFrame jFrame = viewBuilder.buildViewerFrame();
        if (jFrame != null) {
            WindowManager.newWindowLocation(jFrame);
            jFrame.setVisible(bl);
        }
        return swingController;
    }

    public static void newWindowLocation(Container container) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
        int n = preferences.getInt(APPLICATION_WIDTH, 800);
        int n2 = preferences.getInt(APPLICATION_HEIGHT, 600);
        int n3 = (int)(rectangle.getMinX() + rectangle.getWidth() / 2.0 - (double)(n / 2));
        int n4 = (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0 - (double)(n2 / 2));
        int n5 = preferences.getInt(APPLICATION_X_OFFSET, n3);
        int n6 = preferences.getInt(APPLICATION_Y_OFFSET, n4);
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        ArrayList<GraphicsDevice> arrayList = new ArrayList<GraphicsDevice>();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            if (!graphicsConfiguration.getBounds().contains(n5, n6, n, n2)) continue;
            arrayList.add(graphicsDevice);
        }
        if (arrayList.size() == 0) {
            n5 = n3;
            n6 = n4;
        }
        preferences.putInt(APPLICATION_X_OFFSET, n5);
        preferences.putInt(APPLICATION_Y_OFFSET, n6);
        container.setSize(n, n2);
        int n7 = newWindowInvocationCounter > 0 ? 10 : 0;
        container.setLocation(n5 + n7, n6 + n7);
        ++newWindowInvocationCounter;
    }

    public static void saveViewerState(Container container) {
        if (container != null) {
            Rectangle rectangle = container.getBounds();
            Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
            preferences.putInt(APPLICATION_X_OFFSET, rectangle.x);
            preferences.putInt(APPLICATION_Y_OFFSET, rectangle.y);
            preferences.putInt(APPLICATION_WIDTH, rectangle.width);
            preferences.putInt(APPLICATION_HEIGHT, rectangle.height);
            preferences.putInt("document.pagefit.mode", preferences.getInt("document.pagefit.mode", 0));
            int n = preferences.getInt("document.viewtype", 1);
            if (n != 7) {
                preferences.putInt("document.viewtype", preferences.getInt("document.viewtype", 1));
            }
            if (ViewModel.getDefaultFilePath() != null) {
                preferences.put("application.default.filepath", ViewModel.getDefaultFilePath());
            }
            if (ViewModel.getDefaultURL() != null) {
                preferences.put("application.default.url", ViewModel.getDefaultURL());
            }
        }
    }

    @Override
    public void disposeWindow(Controller controller, Frame frame, Preferences preferences) {
        if (this.controllers.size() <= 1) {
            this.quit(controller, frame, preferences);
            return;
        }
        int n = this.controllers.indexOf(controller);
        if (n >= 0) {
            this.controllers.remove(n);
            --newWindowInvocationCounter;
            if (frame != null) {
                frame.setVisible(false);
                frame.dispose();
            }
        }
    }

    @Override
    public void quit(Controller controller, Frame frame, Preferences preferences) {
        WindowManager.saveViewerState(frame);
        for (Controller controller2 : this.controllers) {
            if (controller2 == null) continue;
            controller2.dispose();
        }
        System.exit(0);
    }

    @Override
    public void minimiseAllWindows() {
        for (Controller controller : this.controllers) {
            Frame frame = controller.getViewerFrame();
            if (frame == null) continue;
            frame.setState(1);
        }
    }

    @Override
    public void bringAllWindowsToFront(Controller controller) {
        Frame frame = null;
        for (Controller controller2 : this.controllers) {
            Frame frame2 = controller2.getViewerFrame();
            if (frame2 == null) continue;
            if (controller == controller2) {
                frame = frame2;
                continue;
            }
            frame2.setState(0);
            frame2.toFront();
        }
        if (frame != null) {
            frame.setState(0);
            frame.toFront();
        }
    }

    @Override
    public void bringWindowToFront(int n) {
        Controller controller;
        Frame frame;
        if (n >= 0 && n < this.controllers.size() && (frame = (controller = this.controllers.get(n)).getViewerFrame()) != null) {
            frame.setState(0);
            frame.toFront();
        }
    }

    @Override
    public List getWindowDocumentOriginList(Controller controller) {
        Integer n = null;
        int n2 = this.controllers.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2 + 1);
        for (int i = 0; i < n2; ++i) {
            Document document;
            String string = null;
            Controller controller2 = this.controllers.get(i);
            if (controller == controller2) {
                n = i;
            }
            if ((document = controller2.getDocument()) != null) {
                string = document.getDocumentOrigin();
            }
            arrayList.add(string);
        }
        if (n != null) {
            arrayList.add(n);
        }
        return arrayList;
    }

    void updateUI() {
        for (Controller controller : this.controllers) {
            Frame frame = controller.getViewerFrame();
            if (frame == null) continue;
            SwingUtilities.updateComponentTreeUI(frame);
        }
    }

    static {
        newWindowInvocationCounter = 0;
        controllerFactory = SwingControllerFactory.getInstance();
        viewBuilderFactory = SwingViewBuilderFactory.getInstance();
    }
}

