/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.viewer;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.util.FontPropertiesManager;
import org.icepdf.ri.util.URLAccess;
import org.icepdf.ri.util.ViewerPropertiesManager;
import org.icepdf.ri.viewer.WindowManager;

public class Launcher {
    private static final Logger logger = Logger.getLogger(Launcher.class.toString());
    public static final String APPLICATION_LOOK_AND_FEEL = "application.lookandfeel";
    private static ViewerPropertiesManager propertiesManager;

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "";
        String string2 = "";
        String string3 = null;
        block10: for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            if (i == stringArray.length - 1) {
                bl = true;
                break;
            }
            switch (string4 = stringArray[i]) {
                case "-loadfile": {
                    string2 = stringArray[++i].trim();
                    continue block10;
                }
                case "-loadurl": {
                    string = stringArray[++i].trim();
                    continue block10;
                }
                case "-print": {
                    string3 = stringArray[++i].trim();
                    continue block10;
                }
                default: {
                    bl = true;
                }
            }
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        if (bl) {
            System.out.println(resourceBundle.getString("viewer.commandLin.error"));
            System.exit(1);
        }
        Launcher.run(string2, string, string3, resourceBundle);
    }

    private static void run(String string, String string2, String string3, ResourceBundle resourceBundle) {
        propertiesManager = ViewerPropertiesManager.getInstance();
        FontPropertiesManager.getInstance().loadOrReadSystemFonts();
        Launcher.setupLookAndFeel(resourceBundle);
        ViewModel.setDefaultFilePath(propertiesManager.getPreferences().get("application.default.filepath", null));
        ViewModel.setDefaultURL(propertiesManager.getPreferences().get("application.default.url", null));
        WindowManager windowManager = WindowManager.createInstance(propertiesManager, resourceBundle);
        if (string != null && !string.isEmpty()) {
            if (string3 != null) {
                windowManager.newWindow(string, string3);
            } else {
                windowManager.newWindow(string);
            }
            ViewModel.setDefaultFilePath(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            URLAccess uRLAccess = URLAccess.doURLAccess(string2);
            uRLAccess.closeConnection();
            if (uRLAccess.errorMessage != null) {
                Object[] objectArray = new Object[]{uRLAccess.errorMessage, uRLAccess.urlLocation};
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.launcher.URLError.dialog.message"));
                JOptionPane.showMessageDialog(null, messageFormat.format(objectArray), resourceBundle.getString("viewer.launcher.URLError.dialog.title"), 1);
            } else if (string3 != null) {
                windowManager.newWindow(uRLAccess.url, string3);
            } else {
                windowManager.newWindow(uRLAccess.url);
            }
            ViewModel.setDefaultURL(uRLAccess.urlLocation);
            uRLAccess.dispose();
        }
        if ((string == null || string.isEmpty()) && (string2 == null || string2.isEmpty()) || windowManager.getNumberOfWindows() == 0L) {
            windowManager.newWindow("");
        }
    }

    private static void setupLookAndFeel(ResourceBundle resourceBundle) {
        Object object;
        if (SystemProperties.OS_NAME.contains("OS X")) {
            Defs.setSystemProperty((String)"apple.laf.useScreenMenuBar", (String)"true");
            object = resourceBundle.getString("viewer.window.title.default");
            Defs.setSystemProperty((String)"com.apple.mrj.application.apple.menu.about.name", (String)object);
        }
        object = propertiesManager.getPreferences();
        String string = propertiesManager.getLookAndFeel(APPLICATION_LOOK_AND_FEEL, null, resourceBundle);
        if (string != null) {
            try {
                UIManager.setLookAndFeel(string);
                return;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{((Preferences)object).get(APPLICATION_LOOK_AND_FEEL, null)};
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.launcher.URLError.dialog.message"));
                JOptionPane.showMessageDialog(null, messageFormat.format(objectArray), resourceBundle.getString("viewer.launcher.lookAndFeel.error.message"), 0);
            }
        }
        try {
            String string2 = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error setting Swing Look and Feel.", exception);
        }
    }
}

