/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util.qa;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.util.FontPropertiesManager;
import org.icepdf.ri.util.qa.CaptureTest;

public class PageCapture
implements CaptureTest<BufferedImage> {
    protected Document document;

    @Override
    public int load(Path path) {
        FontPropertiesManager.getInstance().loadOrReadSystemFonts();
        try {
            this.document = new Document();
            this.document.setFile(path.toAbsolutePath().toString());
            return this.document.getNumberOfPages();
        }
        catch (IOException | PDFSecurityException throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    @Override
    public BufferedImage capture(int n, int n2, int n3, float f, float f2) {
        try {
            return (BufferedImage)this.document.getPageImage(n, n2, n3, f, f2);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    @Override
    public void dispose() {
        this.document.dispose();
    }
}

