/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.icepdf.ri.util.Parse;
import org.icepdf.ri.util.Resources;
import org.icepdf.ri.util.SortedProperties;

public final class ViewerPropertiesManager {
    private static final Logger logger = Logger.getLogger(ViewerPropertiesManager.class.toString());
    public static final String PROPERTY_TOKEN_SEPARATOR = "|";
    public static final String DEFAULT_PROP_FILE = "ICEpdfDefault.properties";
    public static final String DEFAULT_PROP_FILE_PATH = "org/icepdf/ri/viewer/res/";
    public static final String DEFAULT_MESSAGE_BUNDLE = "org.icepdf.ri.resources.MessageBundle";
    public static final String PROPERTY_DEFAULT_FILE_PATH = "application.default.filepath";
    public static final String PROPERTY_DEFAULT_URL = "application.default.url";
    public static final String PROPERTY_RECENT_FILES_SIZE = "application.menu.recent.file.size";
    public static final String PROPERTY_ICON_DEFAULT_SIZE = "application.icon.default.size";
    public static final String PROPERTY_DIVIDER_LOCATION = "application.divider.location";
    public static final String PROPERTY_DEFAULT_PAGEFIT = "document.pagefit.mode";
    public static final String PROPERTY_DEFAULT_ROTATION = "document.rotation";
    public static final String PROPERTY_DEFAULT_VIEW_TYPE = "document.viewtype";
    public static final String PROPERTY_TEXT_SELECTION_COLOR = "org.icepdf.core.views.page.text.selection.color";
    public static final String PROPERTY_TEXT_HIGHLIGHT_COLOR = "org.icepdf.core.views.page.text.highlight.color";
    public static final String PROPERTY_PAGE_VIEW_SHADOW_COLOR = "org.icepdf.core.views.page.shadow.color";
    public static final String PROPERTY_PAGE_VIEW_PAPER_COLOR = "org.icepdf.core.views.page.paper.color";
    public static final String PROPERTY_PAGE_VIEW_BORDER_COLOR = "org.icepdf.core.views.page.border.color";
    public static final String PROPERTY_PAGE_VIEW_BACKGROUND_COLOR = "org.icepdf.core.views.background.color";
    public static final String PROPERTY_IMAGING_REFERENCE_TYPE = "org.icepdf.core.imageReference";
    public static final String PROPERTY_IMAGE_PROXY_ENABLED = "org.icepdf.core.imageProxy";
    public static final String PROPERTY_IMAGE_PROXY_THREAD_COUNT = "org.icepdf.core.library.imageThreadPoolSize";
    public static final String PROPERTY_COMMON_THREAD_COUNT = "org.icepdf.core.library.threadPoolSize";
    public static final String PROPERTY_SHOW_MENU_RECENT_FILES = "application.toolbar.show.resentfiles";
    public static final String PROPERTY_SHOW_TOOLBAR_UTILITY = "application.toolbar.show.utility";
    public static final String PROPERTY_SHOW_TOOLBAR_PAGENAV = "application.toolbar.show.pagenav";
    public static final String PROPERTY_SHOW_TOOLBAR_ZOOM = "application.toolbar.show.zoom";
    public static final String PROPERTY_SHOW_TOOLBAR_FIT = "application.toolbar.show.fit";
    public static final String PROPERTY_SHOW_TOOLBAR_FULL_SCREEN = "application.toolbar.show.fullscreen";
    public static final String PROPERTY_SHOW_TOOLBAR_ROTATE = "application.toolbar.show.rotate";
    public static final String PROPERTY_SHOW_TOOLBAR_TOOL = "application.toolbar.show.tool";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION = "application.toolbar.show.annotation";
    public static final String PROPERTY_SHOW_TOOLBAR_FORMS = "application.toolbar.show.forms";
    public static final String PROPERTY_SHOW_TOOLBAR_SEARCH = "application.toolbar.show.search";
    public static final String PROPERTY_SHOW_STATUSBAR = "application.statusbar";
    public static final String PROPERTY_SHOW_STATUSBAR_STATUSLABEL = "application.statusbar.show.statuslabel";
    public static final String PROPERTY_SHOW_STATUSBAR_VIEWMODE = "application.statusbar.show.viewmode";
    public static final String PROPERTY_SHOW_STATUSBAR_VIEWMODE_SINGLE = "application.statusbar.show.viewmode.singlepage";
    public static final String PROPERTY_SHOW_STATUSBAR_VIEWMODE_SINGLE_CONTINUOUS = "application.statusbar.show.viewmode.single.page.continuous";
    public static final String PROPERTY_SHOW_STATUSBAR_VIEWMODE_DOUBLE = "application.statusbar.show.viewmode.double.page";
    public static final String PROPERTY_SHOW_STATUSBAR_VIEWMODE_DOUBLE_CONTINUOUS = "application.statusbar.show.viewmode.double.page.continuous";
    public static final String PROPERTY_SHOW_UTILITY_OPEN = "application.toolbar.show.utility.open";
    public static final String PROPERTY_SHOW_UTILITY_SAVE = "application.toolbar.show.utility.save";
    public static final String PROPERTY_SHOW_UTILITY_PRINT = "application.toolbar.show.utility.print";
    public static final String PROPERTY_SHOW_UTILITY_SEARCH = "application.toolbar.show.utility.search";
    public static final String PROPERTY_SHOW_UTILITY_UPANE = "application.toolbar.show.utility.upane";
    public static final String PROPERTY_HIDE_UTILITYPANE = "application.utilitypane.hide";
    public static final String PROPERTY_SHOW_UTILITYPANE_BOOKMARKS = "application.utilitypane.show.bookmarks";
    public static final String PROPERTY_SHOW_UTILITYPANE_ATTACHMENTS = "application.utilitypane.show.attachments";
    public static final String PROPERTY_SHOW_UTILITYPANE_SEARCH = "application.utilitypane.show.search";
    public static final String PROPERTY_SHOW_UTILITYPANE_THUMBNAILS = "application.utilitypane.show.thumbs";
    public static final String PROPERTY_SHOW_UTILITYPANE_LAYERS = "application.utilitypane.show.layers";
    public static final String PROPERTY_SHOW_UTILITYPANE_ANNOTATION = "application.utilitypane.show.annotation";
    public static final String PROPERTY_SHOW_UTILITYPANE_ANNOTATION_FLAGS = "application.utilitypane.show.annotation.flags";
    public static final String PROPERTY_SHOW_UTILITYPANE_SIGNATURES = "application.utilitypane.show.signatures";
    public static final String PROPERTY_SHOW_UTILITYPANE_ANNOTATION_MARKUP = "application.utilitypane.show.annotation.markup";
    public static final String PROPERTY_SHOW_UTILITYPANE_ANNOTATION_DESTINATIONS = "application.utilitypane.show.annotation.dests";
    public static final String PROPERTY_SHOW_PREFERENCES_GENERAL = "application.preferences.show.general";
    public static final String PROPERTY_SHOW_PREFERENCES_ANNOTATIONS = "application.preferences.show.annotations";
    public static final String PROPERTY_SHOW_PREFERENCES_IMAGING = "application.preferences.show.imaging";
    public static final String PROPERTY_SHOW_PREFERENCES_FONTS = "application.preferences.show.fonts";
    public static final String PROPERTY_SHOW_PREFERENCES_ADVANCED = "application.preferences.show.advanced";
    public static final String PROPERTY_SHOW_PREFERENCES_EXIMPORT = "application.preferences.show.eximport";
    public static final String PROPERTY_UTILITYPANE_THUMBNAILS_ZOOM = "application.utilitypane.thumbnail.zoom";
    public static final String PROPERTY_DEFAULT_ZOOM_LEVEL = "application.zoom.factor.default";
    public static final String PROPERTY_ZOOM_RANGES = "application.zoom.range.default";
    public static final String PROPERTY_SHOW_KEYBOARD_SHORTCUTS = "application.menuitem.show.keyboard.shortcuts";
    public static final String PROPERTY_VIEWPREF_HIDETOOLBAR = "application.viewerpreferences.hidetoolbar";
    public static final String PROPERTY_VIEWPREF_HIDEMENUBAR = "application.viewerpreferences.hidemenubar";
    public static final String PROPERTY_VIEWPREF_FITWINDOW = "application.viewerpreferences.fitwindow";
    public static final String PROPERTY_VIEWPREF_FORM_HIGHLIGHT = "application.viewerpreferences.form.highlight";
    public static final String PROPERTY_VIEWPREF_ANNOTATION_EDIT_MODE = "application.viewerpreferences.annotation.editmode";
    public static final String PROPERTY_ANNOTATION_HIGHLIGHT_SELECTION_TYPE = "application.annotation.highlight.selection.type";
    public static final String PROPERTY_ANNOTATION_LINE_SELECTION_TYPE = "application.annotation.line.selection.type";
    public static final String PROPERTY_ANNOTATION_LINK_SELECTION_TYPE = "application.annotation.link.selection.type";
    public static final String PROPERTY_ANNOTATION_SQUARE_SELECTION_TYPE = "application.annotation.rectangle.selection.type";
    public static final String PROPERTY_ANNOTATION_CIRCLE_SELECTION_TYPE = "application.annotation.circle.selection.type";
    public static final String PROPERTY_ANNOTATION_INK_SELECTION_TYPE = "application.annotation.ink.selection.type";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_SELECTION_TYPE = "application.annotation.freetext.selection.type";
    public static final String PROPERTY_ANNOTATION_TEXT_SELECTION_TYPE = "application.annotation.text.selection.type";
    public static final Set<String> ALL_SELECTION_PROPERTIES = new HashSet<String>(Arrays.asList("application.annotation.circle.selection.type", "application.annotation.highlight.selection.type", "application.annotation.ink.selection.type", "application.annotation.line.selection.type", "application.annotation.link.selection.type", "application.annotation.rectangle.selection.type", "application.annotation.text.selection.type", "application.annotation.freetext.selection.type"));
    public static final String PROPERTY_ANNOTATION_PROPERTIES_HIGHLIGHT_ENABLED = "application.annotation.properties.highlight.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_UNDERLINE_ENABLED = "application.annotation.properties.underline.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_STRIKE_OUT_ENABLED = "application.annotation.properties.strikeout.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_LINE_ENABLED = "application.annotation.properties.line.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_LINK_ENABLED = "application.annotation.properties.link.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_ARROW_ENABLED = "application.annotation.properties.arrow.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_RECTANGLE_ENABLED = "application.annotation.properties.rectangle.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_CIRCLE_ENABLED = "application.annotation.properties.circle.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_INK_ENABLED = "application.annotation.properties.ink.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_FREE_TEXT_ENABLED = "application.annotation.properties.freetext.enabled";
    public static final String PROPERTY_ANNOTATION_PROPERTIES_TEXT_ENABLED = "application.annotation.properties.text.enabled";
    public static final String PROPERTY_ANNOTATION_EDITING_MODE_ENABLED = "application.annotation.editing.mode.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_SELECTION = "application.toolbar.annotation.selection.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_HIGHLIGHT = "application.toolbar.annotation.highlight.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_UNDERLINE = "application.toolbar.annotation.underline.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_STRIKE_OUT = "application.toolbar.annotation.strikeout.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_LINE = "application.toolbar.annotation.line.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_LINK = "application.toolbar.annotation.link.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_ARROW = "application.toolbar.annotation.arrow.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_RECTANGLE = "application.toolbar.annotation.rectangle.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_CIRCLE = "application.toolbar.annotation.circle.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_INK = "application.toolbar.annotation.ink.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_FREE_TEXT = "application.toolbar.annotation.freetext.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_TEXT = "application.toolbar.annotation.text.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_PERMISSION = "application.toolbar.annotation.permission.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_UTILITY = "application.toolbar.annotation.toolbar.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_BOOKMARK_UTILITY = "application.toolbar.bookmark.toolbar.enabled";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION_PREVIEW = "application.toolbar.annotation.preview.enabled";
    public static final String PROPERTY_SHOW_ANNOTATION_MARKUP_REPLY_TO = "application.annotation.show.markup.replyTo";
    public static final String PROPERTY_SHOW_ANNOTATION_MARKUP_ADD_ANNOTATIONS = "application.annotation.show.markup.addAnnotations";
    public static final String PROPERTY_SHOW_ANNOTATION_MARKUP_SET_STATUS = "application.annotation.show.markup.setStatus";
    public static final String PROPERTY_ANNOTATION_HIGHLIGHT_COLOR = "application.viewer.preference.annotation.highlight.color";
    public static final String PROPERTY_ANNOTATION_HIGHLIGHT_OPACITY = "application.viewer.preference.annotation.highlight.opacity";
    public static final String PROPERTY_ANNOTATION_STRIKE_OUT_COLOR = "application.viewer.preference.annotation.strikeout.color";
    public static final String PROPERTY_ANNOTATION_STRIKE_OUT_OPACITY = "application.viewer.preference.annotation.strikeout.opacity";
    public static final String PROPERTY_ANNOTATION_UNDERLINE_COLOR = "application.viewer.preference.annotation.underline.color";
    public static final String PROPERTY_ANNOTATION_UNDERLINE_OPACITY = "application.viewer.preference.annotation.underline.opacity";
    public static final String PROPERTY_ANNOTATION_SQUIGGLY_COLOR = "application.viewer.preference.annotation.squiggly.color";
    public static final String PROPERTY_ANNOTATION_SQUIGGLY_OPACITY = "application.viewer.preference.annotation.squiggly.opacity";
    public static final String PROPERTY_ANNOTATION_TEXT_COLOR = "application.viewer.preference.annotation.text.color";
    public static final String PROPERTY_ANNOTATION_TEXT_OPACITY = "application.viewer.preference.annotation.text.opacity";
    public static final String PROPERTY_ANNOTATION_TEXT_ICON = "application.viewer.preference.annotation.text.icon";
    public static final String PROPERTY_ANNOTATION_INK_COLOR = "application.viewer.preference.annotation.ink.color";
    public static final String PROPERTY_ANNOTATION_INK_OPACITY = "application.viewer.preference.annotation.ink.opacity";
    public static final String PROPERTY_ANNOTATION_SQUARE_COLOR = "application.viewer.preference.annotation.square.color";
    public static final String PROPERTY_ANNOTATION_SQUARE_FILL_COLOR = "application.viewer.preference.annotation.square.fill.color";
    public static final String PROPERTY_ANNOTATION_SQUARE_OPACITY = "application.viewer.preference.annotation.square.fill.opacity";
    public static final String PROPERTY_ANNOTATION_CIRCLE_COLOR = "application.viewer.preference.annotation.circle.color";
    public static final String PROPERTY_ANNOTATION_CIRCLE_FILL_COLOR = "application.viewer.preference.annotation.circle.fill.color";
    public static final String PROPERTY_ANNOTATION_CIRCLE_OPACITY = "application.viewer.preference.annotation.circle.fill.opacity";
    public static final String PROPERTY_ANNOTATION_LINE_COLOR = "application.viewer.preference.annotation.line.color";
    public static final String PROPERTY_ANNOTATION_LINE_FILL_COLOR = "application.viewer.preference.annotation.line.fill.color";
    public static final String PROPERTY_ANNOTATION_LINE_OPACITY = "application.viewer.preference.annotation.line.fill.opcity";
    public static final String PROPERTY_ANNOTATION_LINE_ARROW_COLOR = "application.viewer.preference.annotation.arrow.color";
    public static final String PROPERTY_ANNOTATION_LINE_ARROW_FILL_COLOR = "application.viewer.preference.annotation.arrow.fill.color";
    public static final String PROPERTY_ANNOTATION_LINE_ARROW_OPACITY = "application.viewer.preference.annotation.arrow.fill.opacity";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_COLOR = "application.viewer.preference.annotation.freetext.color";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_SIZE = "application.viewer.preference.annotation.freetext.size";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_FONT = "application.viewer.preference.annotation.freetext.font";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_OPACITY = "application.viewer.preference.annotation.freetext.opacity";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_FILL_COLOR = "application.viewer.preference.annotation.freetext.fill.color";
    public static final String PROPERTY_ANNOTATION_FREE_TEXT_BORDER_COLOR = "application.viewer.preference.annotation.freetext.border.color";
    public static final String PROPERTY_ANNOTATION_RECENT_COLORS = "application.viewer.preference.annotation.color.recent";
    public static final String PROPERTY_ANNOTATION_RECENT_COLOR_LABEL = "application.viewer.preference.annotation.recent.color.labels";
    public static final String PROPERTY_RECENTLY_OPENED_FILES = "application.viewer.preference.recent.files";
    public static final String PROPERTY_ANNOTATION_SORT_COLUMN = "application.viewer.utility.annotation.sort.column";
    public static final String PROPERTY_ANNOTATION_FILTER_AUTHOR_COLUMN = "application.viewer.utility.annotation.filter.author.column";
    public static final String PROPERTY_ANNOTATION_FILTER_VISIBILITY_COLUMN = "application.viewer.utility.annotation.filter.visibility.column";
    public static final String PROPERTY_ANNOTATION_FILTER_TYPE_COLUMN = "application.viewer.utility.annotation.filter.type.column";
    public static final String PROPERTY_ANNOTATION_FILTER_COLOR_COLUMN = "application.viewer.utility.annotation.filter.color.column";
    public static final String PROPERTY_ANNOTATION_QUICK_COLOR = "application.viewer.utility.annotation.filter.quick.color";
    public static final String PROPERTY_SEARCH_PANEL_WHOLE_PAGE_ENABLED = "application.viewer.utility.search.whole.page.enabled";
    public static final String PROPERTY_SEARCH_PANEL_REGEX_ENABLED = "application.viewer.utility.search.regex.enabled";
    public static final String PROPERTY_SEARCH_PANEL_WHOLE_WORDS_ENABLED = "application.viewer.utility.search.whole.words.enabled";
    public static final String PROPERTY_SEARCH_PANEL_CASE_SENSITIVE_ENABLED = "application.viewer.utility.search.case.sensitive.enabled";
    public static final String PROPERTY_SEARCH_PANEL_CUMULATIVE_ENABLED = "application.viewer.utility.search.case.cumulative.enabled";
    public static final String PROPERTY_SEARCH_PANEL_SEARCH_COMMENTS_ENABLED = "application.viewer.utility.search.comments.cumulative.enabled";
    public static final String PROPERTY_SEARCH_PANEL_SEARCH_DEST_ENABLED = "application.viewer.utility.search.case.destinations.enabled";
    public static final String PROPERTY_SEARCH_PANEL_SEARCH_TEXT_ENABLED = "application.viewer.utility.search.case.text.enabled";
    public static final String PROPERTY_SEARCH_PANEL_SEARCH_FORMS_ENABLED = "application.viewer.utility.search.case.forms.enabled";
    public static final String PROPERTY_SEARCH_PANEL_SEARCH_OUTLINES_ENABLED = "application.viewer.utility.search.case.outlines.enabled";
    public static final String PROPERTY_SEARCH_PANEL_SHOW_PAGES_ENABLED = "application.viewer.utility.search.case.pages.enabled";
    public static final String PROPERTY_QUICK_SEARCH_WHOLE_WORDS_ENABLED = "application.viewer.toolbar.search.whole.words.enabled";
    public static final String PROPERTY_QUICK_SEARCH_CASE_SENSITIVE_ENABLED = "application.viewer.toolbar.search.case.sensitive.enabled";
    public static final String PROPERTY_QUICK_SEARCH_SEARCH_COMMENTS_ENABLED = "application.viewer.toolbar.search.comments.cumulative.enabled";
    public static final String PROPERTY_SEARCH_MARKUP_PANEL_REGEX_ENABLED = "application.viewer.utility.search.markup.regex.enabled";
    public static final String PROPERTY_SEARCH_MARKUP_PANEL_CASE_SENSITIVE_ENABLED = "application.viewer.utility.search.markup.case.sensitive.enabled";
    public static final String PROPERTY_ANNOTATION_SUMMARY_FONT_NAME = "application.viewer.annotation.summary.font.name";
    public static final String PROPERTY_ANNOTATION_SUMMARY_FONT_SIZE = "application.viewer.annotation.summary.font.size";
    public static final String PROPERTY_ANNOTATION_LAST_USED_PUBLIC_FLAG = "application.viewer.annotation.public.flag";
    private static ViewerPropertiesManager propertiesManager;
    private static Preferences preferences;
    private static Properties localProperties;
    private static Properties defaultProps;

    private ViewerPropertiesManager() {
    }

    public static ViewerPropertiesManager getInstance() {
        if (propertiesManager == null) {
            propertiesManager = new ViewerPropertiesManager();
            try {
                if (preferences.keys().length == 0) {
                    ViewerPropertiesManager.setupDefaultProperties();
                    ViewerPropertiesManager.saveLocalProperties();
                } else {
                    ViewerPropertiesManager.updatePropertiesWithPreferences();
                }
            }
            catch (BackingStoreException backingStoreException) {
                logger.severe("Couldn't access backing store");
                ViewerPropertiesManager.setupDefaultProperties();
            }
        }
        return propertiesManager;
    }

    public static void printAllProperties() {
        try {
            Arrays.stream(preferences.keys()).forEach(string -> {
                logger.fine(string + " -> " + preferences.get((String)string, ""));
                logger.fine(string + " -> " + propertiesManager.checkAndStoreStringProperty((String)string, ""));
            });
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    private static void updatePropertiesWithPreferences() throws BackingStoreException {
        defaultProps = new SortedProperties();
        Arrays.stream(preferences.keys()).forEach(string -> defaultProps.setProperty((String)string, preferences.get((String)string, null)));
        localProperties = new SortedProperties(defaultProps);
    }

    public Preferences getPreferences() {
        return preferences;
    }

    public void set(String string, String string2) {
        localProperties.setProperty(string, string2);
        preferences.put(string, string2);
    }

    public void remove(String string) {
        localProperties.remove(string);
    }

    public static void saveLocalProperties() {
        Enumeration<Object> enumeration = localProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            preferences.put(string, localProperties.getProperty(string));
        }
    }

    public void setDouble(String string, double d) {
        localProperties.setProperty(string, Double.toString(d));
        preferences.putDouble(string, d);
    }

    public void setFloat(String string, float f) {
        localProperties.setProperty(string, Float.toString(f));
        preferences.putFloat(string, f);
    }

    public void setInt(String string, int n) {
        localProperties.setProperty(string, Integer.toString(n));
        preferences.putInt(string, n);
    }

    public void setBoolean(String string, boolean bl) {
        localProperties.setProperty(string, Boolean.toString(bl));
        preferences.putBoolean(string, bl);
    }

    public String checkAndStoreStringProperty(String string, String string2) {
        String string3 = localProperties.getProperty(string, string2);
        localProperties.setProperty(string, string3);
        return string3;
    }

    public boolean checkAndStoreBooleanProperty(String string) {
        return this.checkAndStoreBooleanProperty(string, true);
    }

    public boolean checkAndStoreBooleanProperty(String string, boolean bl) {
        boolean bl2 = Boolean.parseBoolean(localProperties.getProperty(string, Boolean.toString(bl)));
        localProperties.setProperty(string, String.valueOf(bl2));
        return bl2;
    }

    public double checkAndStoreDoubleProperty(String string) {
        return this.checkAndStoreDoubleProperty(string, 1.0);
    }

    public double checkAndStoreDoubleProperty(String string, double d) {
        double d2 = Double.parseDouble(localProperties.getProperty(string, Double.toString(d)));
        localProperties.setProperty(string, String.valueOf(d2));
        return d2;
    }

    public int checkAndStoreIntProperty(String string) {
        return this.checkAndStoreIntProperty(string, 1);
    }

    public int checkAndStoreIntProperty(String string, int n) {
        int n2 = Integer.parseInt(localProperties.getProperty(string, Integer.toString(n)));
        localProperties.setProperty(string, String.valueOf(n2));
        return n2;
    }

    public float checkAndStoreFloatProperty(String string) {
        return this.checkAndStoreFloatProperty(string, 1.0f);
    }

    public float checkAndStoreFloatProperty(String string, float f) {
        float f2 = Float.parseFloat(localProperties.getProperty(string, Float.toString(f)));
        localProperties.setProperty(string, String.valueOf(f2));
        return f2;
    }

    public float[] checkAndStoreFloatArrayProperty(String string, float[] fArray) {
        String string2 = localProperties.getProperty(string);
        float[] fArray2 = fArray;
        try {
            if (string2 != null && string2.trim().length() > 0) {
                String[] stringArray = string2.split(",");
                fArray2 = new float[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        fArray2[i] = Float.parseFloat(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder(fArray.length * 2);
                for (int i = 0; i < fArray.length; ++i) {
                    stringBuilder.append(fArray[i]);
                    if (i + 1 >= fArray.length) continue;
                    stringBuilder.append(",");
                }
                localProperties.setProperty(string, stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fArray2;
    }

    public String getLookAndFeel(String string, String string2, ResourceBundle resourceBundle) {
        String string3;
        String string4 = preferences.get(string, null);
        if (string4 != null) {
            string3 = Parse.parseLookAndFeel(string4, resourceBundle);
            if (string3 != null) {
                return string3;
            }
            preferences.remove(string);
        }
        if (defaultProps != null && (string4 = defaultProps.getProperty(string)) != null) {
            string3 = Parse.parseLookAndFeel(string4, null);
            if (string3 != null) {
                return string3;
            }
            preferences.remove(string);
            Resources.showMessageDialog(null, 0, resourceBundle, "manager.properties.title", "manager.properties.lafError", string4);
        }
        return string2;
    }

    public void clearPreferences() {
        block3: {
            try {
                String[] stringArray;
                for (String string : stringArray = preferences.keys()) {
                    preferences.remove(string);
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Error clearing preferences cache", exception);
            }
        }
    }

    private static void setupDefaultProperties() {
        block13: {
            try (InputStream inputStream = ViewerPropertiesManager.getResourceAsStream(DEFAULT_PROP_FILE_PATH, DEFAULT_PROP_FILE);){
                defaultProps = new SortedProperties();
                if (inputStream != null) {
                    defaultProps.load(inputStream);
                    if (preferences.get(PROPERTY_DEFAULT_FILE_PATH, null) == null) {
                        Enumeration<Object> enumeration = defaultProps.keys();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            preferences.put(string, defaultProps.getProperty(string));
                        }
                    }
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Default properties file could not be found on the class path. ");
                }
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.WARNING)) break block13;
                logger.log(Level.WARNING, "Error loading default properties cache", iOException);
            }
        }
        localProperties = new SortedProperties(defaultProps);
    }

    public static boolean importPreferences(File file) {
        boolean bl;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            Preferences.importPreferences(bufferedInputStream);
            preferences = Preferences.userNodeForPackage(ViewerPropertiesManager.class);
            ViewerPropertiesManager.updatePropertiesWithPreferences();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | BackingStoreException | InvalidPreferencesFormatException exception) {
                logger.warning("Couldn't load file " + file.getAbsolutePath());
                return false;
            }
        }
        ((InputStream)bufferedInputStream).close();
        return bl;
    }

    public static boolean exportPreferences(File file) {
        boolean bl;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            preferences.exportSubtree(bufferedOutputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | BackingStoreException exception) {
                logger.warning("Couldn't write to file " + file.getAbsolutePath());
                return false;
            }
        }
        ((OutputStream)bufferedOutputStream).close();
        return bl;
    }

    public static boolean importProperties(File file) {
        boolean bl;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            localProperties.load(bufferedInputStream);
            ViewerPropertiesManager.saveLocalProperties();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.warning("Couldn't load file " + file.getAbsolutePath());
                return false;
            }
        }
        ((InputStream)bufferedInputStream).close();
        return bl;
    }

    public static boolean exportProperties(File file) {
        boolean bl;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            localProperties.store(bufferedOutputStream, "IcePDF properties file");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.warning("Couldn't write to file " + file.getAbsolutePath());
                return false;
            }
        }
        ((OutputStream)bufferedOutputStream).close();
        return bl;
    }

    private static InputStream getResourceAsStream(String string, String string2) {
        InputStream inputStream;
        int n = string2.indexOf(58);
        if (n >= 0 && string2.lastIndexOf(n - 1, 47) < 0) {
            try {
                return new URL(string2).openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        string2 = ViewerPropertiesManager.makeResPath(string, string2);
        ClassLoader classLoader = string.getClass().getClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string2)) != null) {
            return inputStream;
        }
        return ClassLoader.getSystemResourceAsStream(string2);
    }

    private static String makeResPath(String string, String string2) {
        if (string2.length() != 0 && string2.charAt(0) == '/') {
            return string2.substring(1);
        }
        if (string == null) {
            return string2;
        }
        return string + string2;
    }

    static {
        preferences = Preferences.userNodeForPackage(ViewerPropertiesManager.class);
    }
}

