/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.AbstractColorButton;
import org.icepdf.ri.common.widgets.ColorToggleButton;
import org.icepdf.ri.common.widgets.PaintButtonInterface;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.ViewerPropertiesManager;

public abstract class AnnotationColorToggleButton
extends AbstractColorButton {
    private static final Logger logger = Logger.getLogger(AnnotationColorToggleButton.class.toString());
    private final String colorProperty;

    protected AnnotationColorToggleButton(Controller controller, ResourceBundle resourceBundle, String string, String string2, String string3, String string4, String string5, Font font) {
        super(controller, resourceBundle);
        this.colorProperty = string3;
        this.colorButton = new ColorToggleButton();
        this.colorButton.setFont(font);
        this.colorButton.setToolTipText(string2);
        if (string5.equals("_32")) {
            this.colorButton.setPreferredSize(new Dimension(32, 32));
        } else if (string5.equals("_24")) {
            this.colorButton.setPreferredSize(new Dimension(24, 24));
        }
        this.colorButton.setRolloverEnabled(true);
        try {
            this.colorButton.setIcon(new ImageIcon(Images.get(string4 + "_a" + string5 + ".png")));
            this.colorButton.setPressedIcon(new ImageIcon(Images.get(string4 + "_i" + string5 + ".png")));
            this.colorButton.setRolloverIcon(new ImageIcon(Images.get(string4 + "_r" + string5 + ".png")));
            this.colorButton.setDisabledIcon(new ImageIcon(Images.get(string4 + "_i" + string5 + ".png")));
        }
        catch (NullPointerException nullPointerException) {
            logger.warning("Failed to load toolbar toggle drop down button images: " + string4 + "_i" + string5 + ".png");
        }
        this.colorButton.setBorder(BorderFactory.createEmptyBorder());
        this.colorButton.setContentAreaFilled(false);
        this.colorButton.setFocusPainted(true);
    }

    @Override
    public void setColor(Color color, boolean bl) {
        ((PaintButtonInterface)((Object)this.colorButton)).setColor(color);
        this.colorButton.repaint();
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        ViewerPropertiesManager.getInstance().setInt(this.colorProperty, color.getRGB());
    }
}

