/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class RgbColorChooser {
    private static final Logger logger = Logger.getLogger(RgbColorChooser.class.toString());

    public static Color showDialog(Component component, String string, Color color) throws HeadlessException {
        Object object;
        try {
            object = UIManager.getSystemLookAndFeelClassName();
            if (((String)object).contains("GTK")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
        }
        catch (Exception exception) {
            logger.warning("Could not set metal look and feel.");
        }
        object = new JColorChooser(color != null ? color : Color.white);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ((JColorChooser)object).getChooserPanels();
        for (AbstractColorChooserPanel object2 : abstractColorChooserPanelArray) {
            String string2;
            switch (string2 = object2.getDisplayName()) {
                case "HSV": 
                case "CMYK": 
                case "HSL": {
                    ((JColorChooser)object).removeChooserPanel(object2);
                }
            }
        }
        ColorTracker colorTracker = new ColorTracker((JColorChooser)object);
        ActionListener actionListener = actionEvent -> colorTracker.setColor(null);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, (JColorChooser)object, colorTracker, actionListener);
        jDialog.setVisible(true);
        try {
            String exception = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(exception);
        }
        catch (Exception exception) {
            logger.warning("Could not set " + UIManager.getSystemLookAndFeelClassName());
        }
        return colorTracker.getColor();
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        private final JColorChooser chooser;
        private Color color;

        ColorTracker(JColorChooser jColorChooser) {
            this.chooser = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.color = this.chooser.getColor();
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

