/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JWindow;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.annotations.AnnotationColorPropertyPanel;
import org.icepdf.ri.util.ViewerPropertiesManager;

public abstract class AbstractColorButton
extends AbstractButton
implements ActionListener,
AncestorListener {
    private static final Logger logger = Logger.getLogger(AbstractColorButton.class.toString());
    protected final AnnotationColorPropertyPanel annotationColorPropertyPanel;
    protected AbstractButton colorButton;
    protected final JButton dropDownArrowButton;
    protected JWindow popup;
    protected final Controller controller;

    public AbstractColorButton(Controller controller, ResourceBundle resourceBundle) {
        this.controller = controller;
        this.dropDownArrowButton = new JButton(new MetalComboBoxIcon());
        this.dropDownArrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.dropDownArrowButton.setContentAreaFilled(false);
        this.dropDownArrowButton.setRolloverEnabled(false);
        this.dropDownArrowButton.setFocusPainted(false);
        this.annotationColorPropertyPanel = new AnnotationColorPropertyPanel(controller, resourceBundle);
        this.annotationColorPropertyPanel.setCallback(this);
        Insets insets = this.dropDownArrowButton.getMargin();
        this.dropDownArrowButton.setMargin(new Insets(insets.top, 0, insets.bottom, 0));
        String string = ViewerPropertiesManager.getInstance().getPreferences().get("application.icon.default.size", "_32");
        if (string.equals("_32")) {
            this.setPreferredSize(new Dimension(48, 32));
        } else if (string.equals("_24")) {
            this.setPreferredSize(new Dimension(36, 24));
        }
        this.dropDownArrowButton.addActionListener(this);
        this.addAncestorListener(this);
    }

    protected void setupLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.colorButton, gridBagConstraints);
        this.add(this.colorButton);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.dropDownArrowButton, gridBagConstraints);
        this.add(this.dropDownArrowButton);
    }

    public abstract void setColor(Color var1, boolean var2);

    public void refreshColorPanel() {
        this.annotationColorPropertyPanel.refreshColorPanel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.colorButton.setSelected(true);
        this.popup = new JWindow(this.getFrame(null));
        this.popup.getContentPane().add(this.annotationColorPropertyPanel);
        this.popup.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                AbstractColorButton.this.popup.setVisible(false);
            }
        });
        this.popup.pack();
        Point point = this.colorButton.getLocationOnScreen();
        point.translate(this.colorButton.getWidth() - this.popup.getWidth(), this.colorButton.getHeight());
        this.popup.setLocation(point);
        this.popup.toFront();
        this.popup.setVisible(true);
        this.popup.requestFocusInWindow();
    }

    protected Frame getFrame(Component component) {
        if (component == null) {
            component = this;
        }
        if (component.getParent() instanceof Frame) {
            return (Frame)component.getParent();
        }
        return this.getFrame(component.getParent());
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.hidePopup();
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.hidePopup();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
        if (ancestorEvent.getSource() != this.popup) {
            this.hidePopup();
        }
    }

    public void hidePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.annotationColorPropertyPanel != null) {
            this.annotationColorPropertyPanel.setEnabled(bl);
        }
        if (this.colorButton != null) {
            this.colorButton.setEnabled(bl);
        }
        if (this.dropDownArrowButton != null) {
            this.dropDownArrowButton.setEnabled(bl);
        }
    }

    public AbstractButton getColorButton() {
        return this.colorButton;
    }

    @Override
    public boolean isSelected() {
        return this.colorButton.isSelected();
    }

    @Override
    public void setSelected(boolean bl) {
        this.colorButton.setSelected(bl);
    }

    @Override
    public ButtonModel getModel() {
        return this.colorButton.getModel();
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.colorButton.addItemListener(itemListener);
    }

    public boolean equals(Object object) {
        return object.equals(this.colorButton) || super.equals(object);
    }
}

