/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.summary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.summary.AnnotationSummaryBox;
import org.icepdf.ri.common.views.annotations.summary.DraggableAnnotationPanel;
import org.icepdf.ri.common.widgets.DragDropColorList;

public class ColorLabelPanel
extends JPanel
implements PropertyChangeListener {
    private final Controller controller;
    private final DragDropColorList.ColorLabel colorLabel;
    private final DraggableAnnotationPanel draggableAnnotationPanel;

    public ColorLabelPanel(Frame frame, Controller controller, DragDropColorList.ColorLabel colorLabel) {
        this.colorLabel = colorLabel;
        this.controller = controller;
        this.setLayout(new BorderLayout());
        if (colorLabel != null) {
            this.add((Component)new JLabel("<html><h3>" + colorLabel.getLabel() + "</h3></html>", 0), "North");
        }
        this.draggableAnnotationPanel = new DraggableAnnotationPanel(frame);
        this.add((Component)new JScrollPane(this.draggableAnnotationPanel), "Center");
    }

    public int getNumberOfComponents() {
        return this.draggableAnnotationPanel.getComponentCount();
    }

    public void addAnnotation(MarkupAnnotation markupAnnotation) {
        PopupAnnotation popupAnnotation = markupAnnotation.getPopupAnnotation();
        if (popupAnnotation != null) {
            List<AbstractPageViewComponent> list = this.controller.getDocumentViewController().getDocumentViewModel().getPageComponents();
            int n = markupAnnotation.getPageIndex();
            if (n >= 0) {
                AnnotationSummaryBox annotationSummaryBox = new AnnotationSummaryBox(popupAnnotation, this.controller.getDocumentViewController(), list.get(n));
                annotationSummaryBox.setVisible(true);
                annotationSummaryBox.removeMouseListeners();
                this.draggableAnnotationPanel.add(annotationSummaryBox);
            }
        }
    }

    public void updateAnnotation(MarkupAnnotation markupAnnotation) {
        for (Component component : this.draggableAnnotationPanel.getComponents()) {
            if (!(component instanceof AnnotationSummaryBox)) continue;
            AnnotationSummaryBox annotationSummaryBox = (AnnotationSummaryBox)component;
            MarkupAnnotation markupAnnotation2 = ((PopupAnnotation)annotationSummaryBox.getAnnotation()).getParent();
            if (!markupAnnotation.getPObjectReference().equals((Object)markupAnnotation2.getPObjectReference())) continue;
            annotationSummaryBox.refreshPopupState();
            annotationSummaryBox.repaint();
            break;
        }
    }

    public void removeAnnotation(MarkupAnnotation markupAnnotation) {
        for (Component component : this.draggableAnnotationPanel.getComponents()) {
            if (!(component instanceof AnnotationSummaryBox)) continue;
            AnnotationSummaryBox annotationSummaryBox = (AnnotationSummaryBox)component;
            MarkupAnnotation markupAnnotation2 = ((PopupAnnotation)annotationSummaryBox.getAnnotation()).getParent();
            if (!markupAnnotation.getPObjectReference().equals((Object)markupAnnotation2.getPObjectReference())) continue;
            this.draggableAnnotationPanel.remove(component);
            this.draggableAnnotationPanel.revalidate();
            this.draggableAnnotationPanel.repaint();
            break;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("annotationSummaryBoxFontSizeChange")) {
            Component[] componentArray;
            for (Component component : componentArray = this.draggableAnnotationPanel.getComponents()) {
                Component component2 = component;
                if (!(component2 instanceof AnnotationSummaryBox)) continue;
                ((AnnotationSummaryBox)component2).setFontSize(((Integer)object).intValue());
            }
        }
    }

    public DragDropColorList.ColorLabel getColorLabel() {
        return this.colorLabel;
    }
}

