/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signatures;

import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.icepdf.ri.common.views.annotations.signatures.CertificatePropertiesDialog;

class CertificateInfo {
    private final X509Certificate cert;
    private final ResourceBundle messageBundle;

    CertificateInfo(X509Certificate x509Certificate, ResourceBundle resourceBundle) {
        this.cert = x509Certificate;
        this.messageBundle = resourceBundle;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    private String extractAliasName(X509Certificate x509Certificate) {
        Object[] objectArray;
        Object object;
        String string = this.messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.unknownSubject.label");
        String string2 = this.messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.unknownIssuer.label");
        try {
            object = new X500Name(x509Certificate.getSubjectDN().toString());
            objectArray = new X500Name(x509Certificate.getIssuerDN().toString());
            string = CertificatePropertiesDialog.parseRelativeDistinguishedName((X500Name)object, BCStyle.CN);
            string2 = CertificatePropertiesDialog.parseRelativeDistinguishedName((X500Name)objectArray, BCStyle.CN);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.certificateInfo.label"));
        objectArray = new Object[]{string, string2};
        return ((Format)object).format(objectArray);
    }

    public String toString() {
        return this.extractAliasName(this.cert);
    }
}

