/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.acroform;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.SignatureHandler;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.signatures.CertificatePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignaturePropertiesDialog;

public class SignatureComponent
extends AbstractAnnotationComponent<SignatureWidgetAnnotation> {
    private static final Logger logger = Logger.getLogger(SignatureComponent.class.toString());
    protected final JPopupMenu contextMenu;
    protected final Controller controller;

    public SignatureComponent(SignatureWidgetAnnotation signatureWidgetAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(signatureWidgetAnnotation, documentViewController, abstractPageViewComponent);
        this.controller = documentViewController.getParentController();
        this.isShowInvisibleBorder = true;
        this.isResizable = false;
        this.isMovable = false;
        if (!signatureWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            this.isEditable = false;
            this.isRollover = false;
            this.isMovable = false;
            this.isResizable = false;
            this.isShowInvisibleBorder = false;
        }
        this.contextMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.signature.menu.showCertificates.label"));
        jMenuItem.addActionListener(new CertificatePropertiesActionListener());
        this.contextMenu.add(jMenuItem);
        this.contextMenu.add(new JPopupMenu.Separator());
        JMenuItem jMenuItem2 = new JMenuItem(this.messageBundle.getString("viewer.annotation.signature.menu.signatureProperties.label"));
        jMenuItem2.addActionListener(new signerPropertiesActionListener());
        this.contextMenu.add(jMenuItem2);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void resetAppearanceShapes() {
    }

    @Override
    public void paintComponent(Graphics graphics) {
    }

    protected void showSignatureWidgetPropertiesDialog() {
        SignatureValidator signatureValidator;
        SignatureFieldDictionary signatureFieldDictionary = ((SignatureWidgetAnnotation)this.annotation).getFieldDictionary();
        if (signatureFieldDictionary != null && (signatureValidator = ((SignatureWidgetAnnotation)this.annotation).getSignatureValidator()) != null) {
            try {
                signatureValidator.validate();
                new SignaturePropertiesDialog(this.controller.getViewerFrame(), this.messageBundle, (SignatureWidgetAnnotation)this.annotation).setVisible(true);
            }
            catch (SignatureIntegrityException signatureIntegrityException) {
                logger.fine("Error validating annotation " + ((SignatureWidgetAnnotation)this.annotation).toString());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (mouseEvent.getClickCount() == 2) {
            this.showSignatureWidgetPropertiesDialog();
        } else if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
            this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private SignatureWidgetAnnotation getSignatureWidgetAnnotation() {
        SignatureWidgetAnnotation signatureWidgetAnnotation = null;
        if (this.annotation instanceof SignatureWidgetAnnotation) {
            signatureWidgetAnnotation = (SignatureWidgetAnnotation)this.annotation;
        } else {
            try {
                signatureWidgetAnnotation = new SignatureWidgetAnnotation(null);
                signatureWidgetAnnotation.init();
                this.annotation = signatureWidgetAnnotation;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                logger.fine("Signature component annotation instance creation was interrupted");
            }
        }
        return signatureWidgetAnnotation;
    }

    class signerPropertiesActionListener
    implements ActionListener {
        signerPropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SignatureComponent.this.showSignatureWidgetPropertiesDialog();
        }
    }

    class CertificatePropertiesActionListener
    implements ActionListener {
        CertificatePropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SignatureHandler signatureHandler;
            SignatureValidator signatureValidator;
            SignatureFieldDictionary signatureFieldDictionary = ((SignatureWidgetAnnotation)SignatureComponent.this.annotation).getFieldDictionary();
            if (signatureFieldDictionary != null && (signatureValidator = (signatureHandler = signatureFieldDictionary.getLibrary().getSignatureHandler()).validateSignature(signatureFieldDictionary)) != null) {
                try {
                    signatureValidator.validate();
                    new CertificatePropertiesDialog(SignatureComponent.this.controller.getViewerFrame(), SignatureComponent.this.messageBundle, (Collection<? extends Certificate>)signatureValidator.getCertificateChain()).setVisible(true);
                }
                catch (SignatureIntegrityException signatureIntegrityException) {
                    logger.fine("Error validating annotation " + ((SignatureWidgetAnnotation)SignatureComponent.this.annotation).toString());
                }
            }
        }
    }
}

