/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.acroform;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import org.icepdf.core.pobjects.acroform.ChoiceFieldDictionary;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.ChoiceWidgetAnnotation;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.ScalableField;
import org.icepdf.ri.common.views.annotations.ScalableJList;
import org.icepdf.ri.common.views.annotations.ScalableJScrollPane;
import org.icepdf.ri.common.views.annotations.acroform.AbstractChoiceComponent;

public class ChoiceListComponent
extends AbstractChoiceComponent
implements AdjustmentListener,
FocusListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AbstractChoiceComponent.class.toString());
    private ScalableJList choiceList;
    private ScalableJScrollPane choiceListPane;

    public ChoiceListComponent(ChoiceWidgetAnnotation choiceWidgetAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(choiceWidgetAnnotation, documentViewController, abstractPageViewComponent);
        if (SystemProperties.INTERACTIVE_ANNOTATIONS && choiceWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            Object object;
            Object object2;
            ChoiceFieldDictionary.ChoiceOption choiceOption2;
            DocumentViewModel documentViewModel = documentViewController.getDocumentViewModel();
            ChoiceFieldDictionary choiceFieldDictionary = choiceWidgetAnnotation.getFieldDictionary();
            DefaultListModel<ChoiceFieldDictionary.ChoiceOption> defaultListModel = new DefaultListModel<ChoiceFieldDictionary.ChoiceOption>();
            ArrayList arrayList = choiceFieldDictionary.getOptions();
            if (arrayList == null) {
                arrayList = choiceWidgetAnnotation.generateChoices();
            }
            int n = 0;
            for (ChoiceFieldDictionary.ChoiceOption choiceOption2 : arrayList) {
                defaultListModel.add(n++, choiceOption2);
            }
            this.choiceList = new ScalableJList(defaultListModel, documentViewModel);
            ChoiceWidgetAnnotation choiceWidgetAnnotation2 = choiceWidgetAnnotation;
            this.choiceList.addListSelectionListener(arg_0 -> this.lambda$new$0(choiceWidgetAnnotation, (Annotation)choiceWidgetAnnotation2, arg_0));
            choiceOption2 = choiceFieldDictionary.getChoiceFieldType();
            if (choiceOption2 == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_LIST_SINGLE_SELECT) {
                this.choiceList.setSelectionMode(0);
                if (choiceFieldDictionary.getFieldValue() != null && choiceFieldDictionary.getIndexes() != null && choiceFieldDictionary.getIndexes().size() == 1) {
                    this.choiceList.setSelectedIndex((Integer)choiceFieldDictionary.getIndexes().get(0));
                }
            } else {
                this.choiceList.setSelectionMode(2);
                if (choiceFieldDictionary.getIndexes() != null && choiceFieldDictionary.getIndexes().size() > 0) {
                    object2 = choiceFieldDictionary.getIndexes();
                    object = new int[((ArrayList)object2).size()];
                    int n2 = ((ArrayList)object2).size();
                    for (int i = 0; i < n2; ++i) {
                        object[i] = (Integer)((ArrayList)object2).get(i);
                    }
                    this.choiceList.setSelectedIndices((int[])object);
                }
            }
            this.choiceList.setLayoutOrientation(0);
            object2 = "Helvetica";
            if (choiceFieldDictionary.getFontName() != null) {
                object2 = choiceFieldDictionary.getFontName().toString();
            }
            this.choiceList.setFont(new Font((String)object2, 0, (int)choiceFieldDictionary.getSize()));
            this.choiceList.setFocusable(true);
            this.choiceListPane = new ScalableJScrollPane(this.choiceList, documentViewModel);
            this.choiceListPane.getVerticalScrollBar().addAdjustmentListener(this);
            this.choiceListPane.getHorizontalScrollBar().addAdjustmentListener(this);
            this.choiceListPane.setFocusable(false);
            object = new GridLayout(1, 1, 0, 0);
            this.setLayout((LayoutManager)object);
            this.setOpaque(false);
            this.add(this.choiceListPane);
        }
        this.revalidate();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.choiceList.requestFocus();
    }

    @Override
    public void validate() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        ChoiceFieldDictionary choiceFieldDictionary = ((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary();
        String string = "Helvetica";
        if (choiceFieldDictionary.getFontName() != null) {
            string = choiceFieldDictionary.getFontName().toString();
        }
        this.choiceList.setFont(new Font(string, 0, (int)(choiceFieldDictionary.getSize() * documentViewModel.getViewZoom())));
        super.validate();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.choiceListPane.getHorizontalScrollBar().removeAdjustmentListener(this);
        this.choiceListPane.getVerticalScrollBar().removeAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getValue() > 0) {
            this.choiceList.setActive(true);
            this.choiceListPane.setActive(true);
            ((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary().setFieldValue(this.choiceList.getSelectedValue(), ((ChoiceWidgetAnnotation)this.annotation).getPObjectReference());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        if ("valueFieldReset".equals(string)) {
            ChoiceFieldDictionary choiceFieldDictionary = ((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary();
            choiceFieldDictionary.setFieldValue(choiceFieldDictionary.getFieldValue(), ((ChoiceWidgetAnnotation)this.annotation).getPObjectReference());
            this.resetAppearanceShapes();
        } else if ("focusOwner".equals(string) && object instanceof ScalableField) {
            boolean bl;
            ScalableField scalableField = (ScalableField)object;
            boolean bl2 = bl = !((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary().isReadOnly();
            if (bl) {
                if (scalableField.equals(this.choiceList) || scalableField.equals(this.choiceListPane)) {
                    this.choiceList.setActive(true);
                    this.choiceListPane.setActive(true);
                    this.choiceListPane.getVerticalScrollBar().setVisible(true);
                } else {
                    scalableField.setActive(true);
                }
            }
        } else if ("focusOwner".equals(string) && object2 instanceof ScalableField) {
            ScalableField scalableField = (ScalableField)object2;
            this.resetAppearanceShapes();
            this.getParent().validate();
            if (scalableField.equals(this.choiceList) || scalableField.equals(this.choiceListPane)) {
                this.choiceList.setActive(false);
                this.choiceListPane.setActive(false);
                this.choiceListPane.getVerticalScrollBar().setVisible(false);
            } else {
                scalableField.setActive(false);
            }
        }
        this.getParent().validate();
        this.getParent().repaint();
    }

    @Override
    public boolean isActive() {
        return this.choiceList != null && this.choiceList.isActive();
    }

    private /* synthetic */ void lambda$new$0(ChoiceWidgetAnnotation choiceWidgetAnnotation, Annotation annotation, ListSelectionEvent listSelectionEvent) {
        boolean bl = this.choiceList.getValueIsAdjusting();
        if (!bl) {
            choiceWidgetAnnotation.getFieldDictionary().setFieldValue(this.choiceList.getSelectedValue(), annotation.getPObjectReference());
        }
    }
}

