/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.tools.DestinationHandler;
import org.icepdf.ri.common.tools.FreeTextAnnotationHandler;
import org.icepdf.ri.common.utility.annotation.AnnotationFilter;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.annotations.AnnotationPopup;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.widgets.DragDropColorList;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class MarkupAnnotationPopupMenu
extends AnnotationPopup<MarkupAnnotationComponent> {
    private static final Logger logger = Logger.getLogger(MarkupAnnotationPopupMenu.class.toString());
    protected JMenuItem replyMenuItem;
    protected JMenuItem statusNoneMenuItem;
    protected JMenuItem statusAcceptedItem;
    protected JMenuItem statusCancelledMenuItem;
    protected JMenuItem statusCompletedMenuItem;
    protected JMenuItem statusRejectedMenuItem;
    protected JMenuItem openAllMenuItem;
    protected JMenuItem minimizeAllMenuItem;
    protected JMenuItem addDestinationMenuItem;
    protected JMenuItem addFreeTextMenuItem1;
    protected JMenuItem addFreeTextMenuItem2;
    protected JMenuItem togglePrivacyMenuItem;
    protected JMenuItem setAllPrivateMenuItem;
    protected JMenuItem setAllPublicMenuItem;
    protected JMenu changeColorMenu;
    protected final boolean deleteRoot;

    public MarkupAnnotationPopupMenu(MarkupAnnotationComponent markupAnnotationComponent, Controller controller, AbstractPageViewComponent abstractPageViewComponent, boolean bl) {
        super(markupAnnotationComponent, controller, abstractPageViewComponent);
        this.deleteRoot = bl;
        this.annotationComponent = markupAnnotationComponent;
        this.buildGui();
    }

    @Override
    public void buildGui() {
        JMenu jMenu;
        ViewerPropertiesManager viewerPropertiesManager = ViewerPropertiesManager.getInstance();
        boolean bl = this.controller.havePermissionToModifyDocument();
        this.statusNoneMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.status.none.label"));
        this.statusNoneMenuItem.setEnabled(bl);
        this.statusAcceptedItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.status.accepted.label"));
        this.statusAcceptedItem.setEnabled(bl);
        this.statusCancelledMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.status.cancelled.label"));
        this.statusCancelledMenuItem.setEnabled(bl);
        this.statusCompletedMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.status.completed.label"));
        this.statusCompletedMenuItem.setEnabled(bl);
        this.statusRejectedMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.status.rejected.label"));
        this.statusRejectedMenuItem.setEnabled(bl);
        this.openAllMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.openAll.label"));
        this.minimizeAllMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.minimizeAll.label"));
        this.changeColorMenu = this.buildColorMenu();
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.annotation.show.markup.addAnnotations")) {
            this.addDestinationMenuItem = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.view.selectionTool.contextMenu.addDestination.label"));
            this.addDestinationMenuItem.setEnabled(bl);
            this.addDestinationMenuItem.addActionListener(this);
            this.addDestinationMenuItem.setIcon(new ImageIcon(Images.get("destination_20.png")));
            this.addFreeTextMenuItem1 = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.addAnnotation.freeText.label"));
            this.addFreeTextMenuItem1.setEnabled(bl);
            this.addFreeTextMenuItem1.setIcon(new ImageIcon(Images.get("freetext_annot_a_20.png")));
            this.addFreeTextMenuItem1.addActionListener(this);
            this.addFreeTextMenuItem2 = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.addAnnotation.freeText.label"));
            this.addFreeTextMenuItem2.setEnabled(bl);
            this.addFreeTextMenuItem2.setIcon(new ImageIcon(Images.get("freetext_annot_a_20.png")));
            this.addFreeTextMenuItem2.addActionListener(this);
            jMenu = new JMenu(this.messageBundle.getString("viewer.annotation.popup.addAnnotation.label"));
            this.addDestinationMenuItem.setEnabled(bl);
            jMenu.add(this.addDestinationMenuItem);
            jMenu.addSeparator();
            jMenu.add(this.addFreeTextMenuItem2);
            this.add(this.addFreeTextMenuItem1);
            this.add(jMenu);
            this.addSeparator();
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.annotation.show.markup.replyTo")) {
            this.replyMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.reply.label"));
            this.replyMenuItem.addActionListener(this);
            this.replyMenuItem.setEnabled(bl);
            this.add(this.replyMenuItem);
        }
        if (this.changeColorMenu.getMenuComponentCount() > 0) {
            this.add(this.changeColorMenu);
            this.addSeparator();
            this.changeColorMenu.setEnabled(bl);
        }
        if (viewerPropertiesManager.checkAndStoreBooleanProperty("application.annotation.show.markup.setStatus")) {
            jMenu = new JMenu(this.messageBundle.getString("viewer.annotation.popup.status.label"));
            this.statusNoneMenuItem.addActionListener(this);
            jMenu.add(this.statusNoneMenuItem);
            this.statusAcceptedItem.addActionListener(this);
            jMenu.add(this.statusAcceptedItem);
            this.statusCancelledMenuItem.addActionListener(this);
            jMenu.add(this.statusCancelledMenuItem);
            this.statusCompletedMenuItem.addActionListener(this);
            jMenu.add(this.statusCompletedMenuItem);
            this.statusRejectedMenuItem.addActionListener(this);
            jMenu.add(this.statusRejectedMenuItem);
            this.add(jMenu);
            this.addSeparator();
        }
        if (SystemProperties.PRIVATE_PROPERTY_ENABLED) {
            jMenu = new JMenu(this.messageBundle.getString("viewer.annotation.popup.privacy.label"));
            this.togglePrivacyMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.privacy.toggle.label"));
            this.togglePrivacyMenuItem.addActionListener(this);
            jMenu.add(this.togglePrivacyMenuItem);
            this.setAllPrivateMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.privacy.all.private.label"));
            this.setAllPrivateMenuItem.addActionListener(this);
            jMenu.add(this.setAllPrivateMenuItem);
            this.setAllPublicMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.privacy.all.public.label"));
            this.setAllPublicMenuItem.addActionListener(this);
            jMenu.add(this.setAllPublicMenuItem);
            this.add(jMenu);
            this.addSeparator();
            jMenu.setEnabled(bl);
        }
        this.openAllMenuItem.addActionListener(this);
        this.add(this.openAllMenuItem);
        this.minimizeAllMenuItem.addActionListener(this);
        this.add(this.minimizeAllMenuItem);
        this.add(this.deleteMenuItem);
        this.deleteMenuItem.addActionListener(this);
        this.addSeparator();
        this.add(this.propertiesMenuItem);
        this.propertiesMenuItem.addActionListener(this);
    }

    void refreshColorMenu() {
        this.changeColorMenu.removeAll();
        JMenu jMenu = this.buildColorMenu();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            arrayList.add(jMenu.getItem(i));
        }
        arrayList.forEach(this.changeColorMenu::add);
    }

    private JMenu buildColorMenu() {
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.annotation.popup.color.change.label"));
        List<JMenuItem> list = this.annotationComponent != null && ((MarkupAnnotationComponent)this.annotationComponent).annotation != null ? DragDropColorList.retrieveColorLabels().stream().filter(colorLabel -> !colorLabel.getColor().equals(((MarkupAnnotationComponent)this.annotationComponent).annotation.getColor())).sorted(Comparator.comparing(DragDropColorList.ColorLabel::getLabel)).map(colorLabel -> {
            JMenuItem jMenuItem = new JMenuItem(colorLabel.getLabel());
            jMenuItem.setForeground(Color.BLACK);
            Color color = new Color(colorLabel.getColor().getRed(), colorLabel.getColor().getGreen(), colorLabel.getColor().getBlue(), 80);
            jMenuItem.setBackground(color);
            jMenuItem.setOpaque(true);
            jMenuItem.addActionListener(actionEvent -> {
                Object t = ((MarkupAnnotationComponent)this.annotationComponent).getAnnotation();
                t.setColor(colorLabel.getColor());
                t.getPage().updateAnnotation(t);
                ((MarkupAnnotationComponent)this.annotationComponent).resetAppearanceShapes();
                ((MarkupAnnotationComponent)this.annotationComponent).repaint();
                this.controller.getDocumentViewController().updateAnnotation(this.annotationComponent);
            });
            return jMenuItem;
        }).collect(Collectors.toList()) : Collections.emptyList();
        list.forEach(jMenu::add);
        return jMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (this.annotationComponent == null) {
            logger.log(Level.WARNING, "Markup Annotation is null");
            return;
        }
        UserAnnotationFilter userAnnotationFilter = new UserAnnotationFilter();
        if (object == this.replyMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.replyToSelectedMarkupExecute();
            }
        } else if (object == this.deleteMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.deleteSelectedMarkupExecute(this.deleteRoot);
            }
        } else if (object == this.statusNoneMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.setStatusSelectedMarkupExecute(this.messageBundle.getString("viewer.annotation.popup.status.none.title"), this.messageBundle.getString("viewer.annotation.popup.status.none.msg"), "None");
            }
        } else if (object == this.statusAcceptedItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.setStatusSelectedMarkupExecute(this.messageBundle.getString("viewer.annotation.popup.status.accepted.title"), this.messageBundle.getString("viewer.annotation.popup.status.accepted.msg"), "Accepted");
            }
        } else if (object == this.statusCancelledMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.setStatusSelectedMarkupExecute(this.messageBundle.getString("viewer.annotation.popup.status.cancelled.title"), this.messageBundle.getString("viewer.annotation.popup.status.cancelled.msg"), "Cancelled");
            }
        } else if (object == this.statusCompletedMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            popupAnnotationComponent.setStatusSelectedMarkupExecute(this.messageBundle.getString("viewer.annotation.popup.status.completed.title"), this.messageBundle.getString("viewer.annotation.popup.status.completed.msg"), "Completed");
        } else if (object == this.statusRejectedMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.setStatusSelectedMarkupExecute(this.messageBundle.getString("viewer.annotation.popup.status.rejected.title"), this.messageBundle.getString("viewer.annotation.popup.status.rejected.msg"), "Rejected");
            }
        } else if (object == this.openAllMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            popupAnnotationComponent.showHidePopupAnnotations(true);
        } else if (object == this.minimizeAllMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                popupAnnotationComponent.showHidePopupAnnotations(false);
            }
        } else if (object == this.propertiesMenuItem) {
            PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
            if (popupAnnotationComponent != null) {
                this.controller.showAnnotationProperties(popupAnnotationComponent.getAnnotationParentComponent());
            }
        } else if (object == this.addDestinationMenuItem) {
            Point point = ((MarkupAnnotationComponent)this.annotationComponent).getLocation();
            this.pageViewComponent = (PageViewComponentImpl)((MarkupAnnotationComponent)this.annotationComponent).getPageViewComponent();
            new DestinationHandler(this.controller.getDocumentViewController(), this.pageViewComponent).createNewDestination(((MarkupAnnotationComponent)this.annotationComponent).getAnnotation().getContents(), point.x, point.y);
        } else if (object == this.addFreeTextMenuItem1 || object == this.addFreeTextMenuItem2) {
            Point point = ((MarkupAnnotationComponent)this.annotationComponent).getLocation();
            Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
            int n = preferences.getInt("application.viewer.preference.annotation.freetext.size", 12) + 2;
            n = (int)((float)n * this.controller.getDocumentViewController().getZoom());
            new FreeTextAnnotationHandler(this.controller.getDocumentViewController(), this.pageViewComponent).createFreeTextAnnotation(point.x, point.y - n, false);
        } else if (object == this.setAllPrivateMenuItem) {
            ((SwingController)this.controller).changeAnnotationsPrivacy(userAnnotationFilter, true);
        } else if (object == this.setAllPublicMenuItem) {
            ((SwingController)this.controller).changeAnnotationsPrivacy(userAnnotationFilter, false);
        } else if (object == this.togglePrivacyMenuItem) {
            MarkupAnnotation markupAnnotation = (MarkupAnnotation)((MarkupAnnotationComponent)this.annotationComponent).getAnnotation();
            Set set = markupAnnotation.getReplyingAnnotations(true).stream().map(Dictionary::getPObjectReference).collect(Collectors.toSet());
            ((SwingController)this.controller).changeAnnotationsPrivacy(annotation -> set.contains(annotation.getPObjectReference()) || annotation.getPObjectReference().equals((Object)markupAnnotation.getPObjectReference()), !markupAnnotation.getFlagPrivateContents());
        }
    }

    private static class UserAnnotationFilter
    implements AnnotationFilter {
        private UserAnnotationFilter() {
        }

        @Override
        public boolean filter(Annotation annotation) {
            return annotation instanceof MarkupAnnotation && ((MarkupAnnotation)annotation).getTitleText().equals(SystemProperties.USER_NAME);
        }
    }
}

