/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import javax.swing.JPopupMenu;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationPopup;
import org.icepdf.ri.common.views.annotations.PopupListener;

public class LinkAnnotationComponent
extends AbstractAnnotationComponent<LinkAnnotation> {
    protected final Color highlightColor = new Color(Integer.parseInt("83A3D3", 16));
    protected final Color linkColor = new Color(Integer.parseInt("990033", 16));

    public LinkAnnotationComponent(LinkAnnotation linkAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(linkAnnotation, documentViewController, abstractPageViewComponent);
        this.isShowInvisibleBorder = true;
        AnnotationPopup<LinkAnnotationComponent> annotationPopup = new AnnotationPopup<LinkAnnotationComponent>(this, documentViewController.getParentController(), this.getPageViewComponent());
        annotationPopup.buildGui();
        this.contextMenu = annotationPopup;
        LinkPopupListener linkPopupListener = new LinkPopupListener(this.contextMenu);
        this.addMouseListener(linkPopupListener);
    }

    private boolean isAnnotationEditable() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return (documentViewModel.getViewToolMode() == 6 || documentViewModel.getViewToolMode() == 7) && !((LinkAnnotation)this.annotation).getFlagReadOnly() && !((LinkAnnotation)this.annotation).getFlagLocked() && !((LinkAnnotation)this.annotation).getFlagInvisible() && !((LinkAnnotation)this.annotation).getFlagHidden();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Cloneable cloneable;
        Color color;
        Object object;
        Object object2;
        this.isEditable = this.isAnnotationEditable();
        if (this.documentViewController.getParentController().getViewModel().isAnnotationEditingMode()) {
            object2 = (Graphics2D)graphics;
            ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            object = ((Graphics2D)object2).getComposite();
            color = ((Graphics)object2).getColor();
            cloneable = ((Graphics2D)object2).getTransform();
            ((Graphics)object2).setColor(this.highlightColor);
            ((Graphics)object2).drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            ((Graphics2D)object2).setComposite(AlphaComposite.getInstance(3, 0.3f));
            ((Graphics)object2).fillRect(0, 0, this.getWidth(), this.getHeight());
            int n = 15;
            int n2 = 10;
            if (n2 > this.getHeight() - 4) {
                n2 = this.getHeight() - 4;
            }
            int n3 = 4;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(n - n3, 0.0f);
            generalPath.lineTo(n, n2 >> 1);
            generalPath.lineTo(n - n3, n2);
            generalPath.lineTo(0.0f, n2);
            generalPath.lineTo(n3, n2 >> 1);
            generalPath.closePath();
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            Page page = this.pageViewComponent.getPage();
            AffineTransform affineTransform = page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            affineTransform.setTransform(affineTransform.getScaleX(), 0.0, 0.0, -affineTransform.getScaleY(), 0.0, 0.0);
            Shape shape = affineTransform.createTransformedShape(generalPath);
            Rectangle rectangle = shape.getBounds();
            ((Graphics2D)object2).setComposite(AlphaComposite.getInstance(3, 0.4f));
            ((Graphics2D)object2).translate(this.getWidth() - rectangle.width - 2, this.getHeight() - rectangle.height - 2);
            ((Graphics)object2).setColor(this.linkColor);
            ((Graphics2D)object2).fill(shape);
            ((Graphics)object2).setColor(Color.DARK_GRAY);
            ((Graphics2D)object2).draw(shape);
            ((Graphics2D)object2).setComposite((Composite)object);
            ((Graphics)object2).setColor(color);
            ((Graphics2D)object2).setTransform((AffineTransform)cloneable);
        }
        object2 = this.documentViewController.getDocumentViewModel();
        if (this.isMousePressed && object2.getViewToolMode() != 6 && object2.getViewToolMode() != 7) {
            object = (Graphics2D)graphics;
            color = ((LinkAnnotation)this.annotation).getHighlightMode();
            cloneable = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            if (LinkAnnotation.HIGHLIGHT_INVERT.equals((Name)color)) {
                ((Graphics)object).setColor(annotationHighlightColor);
                ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                ((Graphics)object).fillRect((int)((RectangularShape)cloneable).getX(), (int)((RectangularShape)cloneable).getY(), (int)((RectangularShape)cloneable).getWidth(), (int)((RectangularShape)cloneable).getHeight());
            } else if (LinkAnnotation.HIGHLIGHT_OUTLINE.equals((Name)color)) {
                ((Graphics)object).setColor(annotationHighlightColor);
                ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                ((Graphics)object).drawRect((int)((RectangularShape)cloneable).getX(), (int)((RectangularShape)cloneable).getY(), (int)((RectangularShape)cloneable).getWidth(), (int)((RectangularShape)cloneable).getHeight());
            } else if (LinkAnnotation.HIGHLIGHT_PUSH.equals((Name)color)) {
                ((Graphics)object).setColor(annotationHighlightColor);
                ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, annotationHighlightAlpha));
                ((Graphics)object).drawRect((int)((RectangularShape)cloneable).getX(), (int)((RectangularShape)cloneable).getY(), (int)((RectangularShape)cloneable).getWidth(), (int)((RectangularShape)cloneable).getHeight());
            }
        }
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void resetAppearanceShapes() {
    }

    public class LinkPopupListener
    extends PopupListener {
        public LinkPopupListener(JPopupMenu jPopupMenu) {
            super(jPopupMenu);
        }

        @Override
        protected void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && LinkAnnotationComponent.this.isAnnotationEditable()) {
                this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

