/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Component;
import java.awt.geom.Rectangle2D;
import org.icepdf.core.Memento;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.ri.common.views.AnnotationComponent;

public class AnnotationState
implements Memento {
    protected Rectangle2D.Float userSpaceRectangle;
    protected final AnnotationComponent annotationComponent;

    public AnnotationState(AnnotationComponent annotationComponent) {
        this.annotationComponent = annotationComponent;
    }

    public void apply(AnnotationState annotationState) {
        Rectangle2D.Float float_ = annotationState.userSpaceRectangle;
        if (float_ != null) {
            this.userSpaceRectangle = new Rectangle2D.Float(float_.x, float_.y, float_.width, float_.height);
        }
        this.restore();
    }

    public void restore() {
        if (this.annotationComponent != null && this.annotationComponent.getAnnotation() != null) {
            Annotation annotation = this.annotationComponent.getAnnotation();
            this.restore(annotation);
            this.synchronizeState();
        }
    }

    public void restore(Annotation annotation) {
        if (annotation.getBorderStyle() == null) {
            annotation.setBorderStyle(new BorderStyle());
        }
        annotation.setUserSpaceRectangle(this.userSpaceRectangle);
    }

    public void synchronizeState() {
        int n = this.annotationComponent.getPageIndex();
        Document document = this.annotationComponent.getDocument();
        Annotation annotation = this.annotationComponent.getAnnotation();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(n);
        if (!annotation.isDeleted()) {
            page.updateAnnotation(annotation);
            this.annotationComponent.refreshDirtyBounds();
        } else {
            annotation.setDeleted(false);
            page.addAnnotation(annotation, true);
            ((Component)((Object)this.annotationComponent)).setVisible(true);
            this.annotationComponent.refreshDirtyBounds();
        }
    }
}

