/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.icepdf.ri.common.views.annotations.FileDropHandler;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public final class AnnotationFileDropHandler {
    private static AnnotationFileDropHandler instance;
    private final List<FileDropHandler> fileDropHandlers = new ArrayList<FileDropHandler>();

    private AnnotationFileDropHandler() {
    }

    public static AnnotationFileDropHandler getInstance() {
        if (instance == null) {
            instance = new AnnotationFileDropHandler();
        }
        return instance;
    }

    public void addFileDropHandler(FileDropHandler fileDropHandler) {
        this.fileDropHandlers.add(fileDropHandler);
    }

    public void handlePopupAnnotationFileDrop(File file, PopupAnnotationComponent popupAnnotationComponent) {
        for (FileDropHandler fileDropHandler : this.fileDropHandlers) {
            if (file == null || !file.getName().toLowerCase().endsWith(fileDropHandler.getExtension())) continue;
            fileDropHandler.execute(file, popupAnnotationComponent);
        }
    }
}

