/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.border.AbstractBorder;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.views.ResizeableComponent;

public class ResizableBorder
extends AbstractBorder {
    private static final Logger logger;
    private static Color selectColor;
    private static Color outlineColor;
    private static Color outlineResizeColor;
    public static final int INSETS = 5;
    private static final int[] locations;
    private static final int[] cursors;
    private static final Stroke dashedBorder;
    private static final Stroke solidBorder;
    protected int resizeWidgetDim;
    protected int originalResizeWidgetDim;
    protected int inset;

    public ResizableBorder(int n) {
        this.originalResizeWidgetDim = n;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    public void setZoom(float f) {
        this.resizeWidgetDim = (int)((float)this.originalResizeWidgetDim * f);
        this.inset = (int)((double)(5.0f * f) + 0.5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (component instanceof ResizeableComponent) {
            object = (ResizeableComponent)((Object)component);
            bl = object.isSelected();
            bl2 = object.isBorderStyle();
            bl3 = object.isEditable();
            bl4 = object.isRollover();
            bl6 = object.isResizable();
            bl7 = object.isShowInvisibleBorder();
        }
        if (!bl3) {
            return;
        }
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setStroke(dashedBorder);
        if (bl || component.hasFocus() || bl4) {
            ((Graphics)object).setColor(selectColor);
        } else {
            ((Graphics)object).setColor(outlineColor);
        }
        if (bl || bl4 || bl7 && !bl2) {
            ((Graphics)object).drawRect(n, n2, n3 - 1, n4 - 1);
        }
        ((Graphics)object).setColor(outlineResizeColor);
        ((Graphics2D)object).setStroke(solidBorder);
        if ((bl || bl4) && bl6) {
            for (int n5 : locations) {
                Rectangle rectangle = this.getRectangle(n, n2, n3, n4, n5);
                if (rectangle == null) continue;
                ((Graphics)object).fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                ((Graphics)object).drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            }
        }
    }

    private Rectangle getRectangle(int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 1: {
                return new Rectangle(n + n3 / 2 - this.resizeWidgetDim / 2, n2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 5: {
                return new Rectangle(n + n3 / 2 - this.resizeWidgetDim / 2, n2 + n4 - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 7: {
                return new Rectangle(n, n2 + n4 / 2 - this.resizeWidgetDim / 2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 3: {
                return new Rectangle(n + n3 - this.resizeWidgetDim, n2 + n4 / 2 - this.resizeWidgetDim / 2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 8: {
                return new Rectangle(n, n2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 2: {
                return new Rectangle(n + n3 - this.resizeWidgetDim, n2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 6: {
                return new Rectangle(n, n2 + n4 - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 4: {
                return new Rectangle(n + n3 - this.resizeWidgetDim, n2 + n4 - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
        }
        return null;
    }

    public int getCursor(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        if (component instanceof ResizeableComponent) {
            ResizeableComponent resizeableComponent = (ResizeableComponent)((Object)component);
            bl = resizeableComponent.isEditable();
            bl3 = resizeableComponent.isResizable();
            bl2 = resizeableComponent.isMovable();
        }
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (bl && bl3) {
            for (int i = 0; i < locations.length; ++i) {
                Rectangle rectangle = this.getRectangle(0, 0, n, n2, locations[i]);
                if (rectangle == null || !rectangle.contains(mouseEvent.getPoint())) continue;
                return cursors[i];
            }
        }
        if (bl2) {
            return 13;
        }
        return 0;
    }

    static {
        block2: {
            logger = Logger.getLogger(ResizableBorder.class.toString());
            try {
                String string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.select.color", (String)"#999999");
                int n = ColorUtil.convertColor((String)string);
                selectColor = new Color(n >= 0 ? n : Integer.parseInt("999999", 16));
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.outline.color", (String)"#cccccc");
                n = ColorUtil.convertColor((String)string);
                outlineColor = new Color(n >= 0 ? n : Integer.parseInt("cccccc", 16));
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.outline.colorResize", (String)"#666666");
                n = ColorUtil.convertColor((String)string);
                outlineResizeColor = new Color(n >= 0 ? n : Integer.parseInt("666666", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading page annotation outline colour");
            }
        }
        locations = new int[]{1, 5, 7, 3, 8, 2, 6, 4};
        cursors = new int[]{8, 9, 10, 11, 6, 7, 4, 5};
        dashedBorder = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 1.0f}, 0.0f);
        solidBorder = new BasicStroke(1.0f, 0, 2, 0.0f);
    }
}

