/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.views.PageViewComponent;

public class PageViewDecorator
extends JComponent {
    private static final Logger log;
    protected JComponent pageViewComponent;
    protected static final int SHADOW_SIZE = 3;
    protected final Dimension preferredSize = new Dimension();
    public static Color pageBorderColor;
    public static Color pageShadowColor;
    public static Color pageColor;

    public PageViewDecorator(JComponent jComponent) {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.pageViewComponent = jComponent;
        Dimension dimension = jComponent.getPreferredSize();
        this.preferredSize.setSize(dimension.width + 3, dimension.height + 3);
        this.add(jComponent);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.pageViewComponent.getPreferredSize();
        this.preferredSize.setSize(dimension.width + 3, dimension.height + 3);
        return this.preferredSize;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.pageViewComponent.getPreferredSize();
        graphics2D.setColor(pageColor);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        this.paintBorder(graphics2D, dimension);
        this.paintShadow(graphics2D, dimension);
        super.paint(graphics);
    }

    protected void paintBorder(Graphics2D graphics2D, Dimension dimension) {
        graphics2D.setColor(pageBorderColor);
        graphics2D.drawRect(0, 0, dimension.width, dimension.height);
    }

    protected void paintShadow(Graphics2D graphics2D, Dimension dimension) {
        graphics2D.setColor(pageShadowColor);
        graphics2D.fillRect(3, dimension.height, dimension.width - 3, 3);
        graphics2D.fillRect(dimension.width, 3, 3, dimension.height);
    }

    public PageViewComponent getPageViewComponent() {
        return (PageViewComponent)((Object)this.pageViewComponent);
    }

    static {
        block8: {
            int n;
            String string;
            block7: {
                block6: {
                    log = Logger.getLogger(PageViewDecorator.class.toString());
                    try {
                        string = Defs.sysProperty((String)"org.icepdf.core.views.page.shadow.color", (String)"#333333");
                        n = ColorUtil.convertColor((String)string);
                        pageShadowColor = new Color(n >= 0 ? n : Integer.parseInt("333333", 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!log.isLoggable(Level.WARNING)) break block6;
                        log.warning("Error reading page shadow colour");
                    }
                }
                try {
                    string = Defs.sysProperty((String)"org.icepdf.core.views.page.paper.color", (String)"#FFFFFF");
                    n = ColorUtil.convertColor((String)string);
                    pageColor = new Color(n >= 0 ? n : Integer.parseInt("FFFFFF", 16));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!log.isLoggable(Level.WARNING)) break block7;
                    log.warning("Error reading page paper color.");
                }
            }
            try {
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.border.color", (String)"#000000");
                n = ColorUtil.convertColor((String)string);
                pageBorderColor = new Color(n >= 0 ? n : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!log.isLoggable(Level.WARNING)) break block8;
                log.warning("Error reading page paper color.");
            }
        }
    }
}

