/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.ChoiceWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.GraphicsRenderingHints;
import org.icepdf.ri.common.search.DocumentSearchControllerImpl;
import org.icepdf.ri.common.tools.AnnotationSelectionHandler;
import org.icepdf.ri.common.tools.CircleAnnotationHandler;
import org.icepdf.ri.common.tools.FreeTextAnnotationHandler;
import org.icepdf.ri.common.tools.HighLightAnnotationHandler;
import org.icepdf.ri.common.tools.InkAnnotationHandler;
import org.icepdf.ri.common.tools.LineAnnotationHandler;
import org.icepdf.ri.common.tools.LineArrowAnnotationHandler;
import org.icepdf.ri.common.tools.LinkAnnotationHandler;
import org.icepdf.ri.common.tools.SquareAnnotationHandler;
import org.icepdf.ri.common.tools.StrikeOutAnnotationHandler;
import org.icepdf.ri.common.tools.TextAnnotationHandler;
import org.icepdf.ri.common.tools.TextSelection;
import org.icepdf.ri.common.tools.TextSelectionPageHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.UnderLineAnnotationHandler;
import org.icepdf.ri.common.tools.ZoomInPageHandler;
import org.icepdf.ri.common.utility.search.SearchHitComponent;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.MarkupGlueComponent;
import org.icepdf.ri.common.views.annotations.PageViewAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.destinations.DestinationComponent;

public class PageViewComponentImpl
extends AbstractPageViewComponent
implements FocusListener {
    private static final Logger logger = Logger.getLogger(PageViewComponentImpl.class.toString());
    protected ToolHandler currentToolHandler;
    protected final TextSelectionPageHandler textSelectionPageHandler;
    protected final Object annotationComponentsLock = new Object();
    protected ArrayList<AbstractAnnotationComponent> annotationComponents;
    protected Map<Annotation, AnnotationComponent> annotationToComponent;
    protected ArrayList<DestinationComponent> destinationComponents;
    private Set<SearchHitComponent> searchHitComponents = new HashSet<SearchHitComponent>();

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int n, int n2, int n3) {
        super(documentViewModel, pageTree, n, n2, n3);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.textSelectionPageHandler = new TextSelectionPageHandler(this.documentViewController, this);
        this.paintAnnotations = false;
    }

    @Override
    public void setDocumentViewCallback(DocumentView documentView) {
        super.setDocumentViewCallback(documentView);
        this.textSelectionPageHandler.setDocumentViewController(this.documentViewController);
    }

    public void clearSearchHighlights() {
        this.searchHitComponents.forEach(this::remove);
        this.searchHitComponents.clear();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, this.pageSize.width, this.pageSize.height);
        GraphicsRenderingHints graphicsRenderingHints = GraphicsRenderingHints.getDefault();
        graphics2D.setRenderingHints(graphicsRenderingHints.getRenderingHints(1));
        this.paintAnnotationComponents(graphics2D);
        this.paintTextSelection(graphics2D);
        this.paintDestinations(graphics2D);
        if (this.currentToolHandler != null) {
            this.currentToolHandler.paintTool(graphics2D);
        }
        if (this.documentViewModel.getViewToolMode() == 5) {
            this.textSelectionPageHandler.paintTool(graphics2D);
        }
        graphics2D.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.removeMouseMotionListener(this.currentToolHandler);
        this.removeMouseListener(this.currentToolHandler);
        this.removeFocusListener(this);
        if (this.annotationComponents != null) {
            Object object = this.annotationComponentsLock;
            synchronized (object) {
                for (AbstractAnnotationComponent abstractAnnotationComponent : this.annotationComponents) {
                    abstractAnnotationComponent.dispose();
                }
            }
        }
    }

    public void setToolMode(int n) {
        if (this.currentToolHandler != null) {
            this.currentToolHandler.uninstallTool();
            this.removeMouseListener(this.currentToolHandler);
            this.removeMouseMotionListener(this.currentToolHandler);
            this.currentToolHandler = null;
        }
        switch (n) {
            case 2: {
                this.currentToolHandler = new ZoomInPageHandler(this.documentViewController, this);
                break;
            }
            case 6: {
                this.currentToolHandler = new AnnotationSelectionHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 7: {
                this.currentToolHandler = new LinkAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 8: {
                this.currentToolHandler = new HighLightAnnotationHandler(this.documentViewController, this);
                ((HighLightAnnotationHandler)this.currentToolHandler).createTextMarkupAnnotation(null);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 11: {
                this.currentToolHandler = new StrikeOutAnnotationHandler(this.documentViewController, this);
                ((StrikeOutAnnotationHandler)this.currentToolHandler).createTextMarkupAnnotation(null);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 9: {
                this.currentToolHandler = new UnderLineAnnotationHandler(this.documentViewController, this);
                ((UnderLineAnnotationHandler)this.currentToolHandler).createTextMarkupAnnotation(null);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 12: {
                this.currentToolHandler = new LineAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 13: {
                this.currentToolHandler = new LineArrowAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 14: {
                this.currentToolHandler = new SquareAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 15: {
                this.currentToolHandler = new CircleAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 16: {
                this.currentToolHandler = new InkAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 17: {
                this.currentToolHandler = new FreeTextAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            case 18: {
                this.currentToolHandler = new TextAnnotationHandler(this.documentViewController, this);
                this.documentViewController.clearSelectedText();
                break;
            }
            default: {
                this.currentToolHandler = null;
            }
        }
        if (this.currentToolHandler != null) {
            this.currentToolHandler.installTool();
            this.addMouseListener(this.currentToolHandler);
            this.addMouseMotionListener(this.currentToolHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AbstractAnnotationComponent> getAnnotationComponents() {
        Object object = this.annotationComponentsLock;
        synchronized (object) {
            return this.annotationComponents;
        }
    }

    public AnnotationComponent getComponentFor(Annotation annotation) {
        if (this.annotationToComponent == null) {
            this.initializeAnnotationsComponent(this.getPage());
        }
        return this.annotationToComponent.get(annotation);
    }

    public ArrayList<DestinationComponent> getDestinationComponents() {
        return this.destinationComponents;
    }

    public TextSelectionPageHandler getTextSelectionPageHandler() {
        return this.textSelectionPageHandler;
    }

    public ToolHandler getCurrentToolHandler() {
        return this.currentToolHandler;
    }

    private void paintTextSelection(Graphics graphics) {
        block8: {
            Page page = this.getPage();
            DocumentSearchController documentSearchController = this.documentViewController.getParentController().getDocumentSearchController();
            if (page != null && page.isInitiated() && (documentSearchController.isSearchHighlightRefreshNeeded(this.pageIndex, null) || this.documentViewModel.isViewToolModeSelected(5) || this.documentViewModel.isViewToolModeSelected(8) || this.documentViewModel.isViewToolModeSelected(11) || this.documentViewModel.isViewToolModeSelected(9))) {
                try {
                    Set<SearchHitComponent> set;
                    PageText pageText = page.getViewText();
                    if (pageText == null) break block8;
                    if (documentSearchController.isSearchHighlightRefreshNeeded(this.pageIndex, pageText)) {
                        documentSearchController.searchHighlightPage(this.pageIndex);
                    }
                    if (this.documentViewModel.isSelectAll()) {
                        this.documentViewModel.addSelectedPageText(this);
                        pageText.selectAll();
                    }
                    TextSelection.paintSelectedText(graphics, this, this.documentViewModel);
                    if (documentSearchController instanceof DocumentSearchControllerImpl && !(set = ((DocumentSearchControllerImpl)documentSearchController).getComponentsFor(this.pageIndex)).equals(this.searchHitComponents)) {
                        this.searchHitComponents.forEach(this::remove);
                        this.searchHitComponents = set;
                        this.searchHitComponents.forEach(searchHitComponent -> {
                            this.setLayer((Component)searchHitComponent, JLayeredPane.MODAL_LAYER);
                            this.add((Component)searchHitComponent);
                        });
                        this.validate();
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.fine("Interrupt exception during view text fetch.");
                }
            } else if (page != null && !page.isInitiated() && documentSearchController.isSearchHighlightRefreshNeeded(this.pageIndex, null)) {
                this.pageBufferStore.setDirty(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintAnnotationComponents(Graphics graphics) {
        Page page = this.getPage();
        if (page != null && this.annotationComponents != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            AffineTransform affineTransform2 = page.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            graphics2D.transform(affineTransform2);
            boolean bl = this.documentViewModel.getViewToolMode() != 6;
            Object object = this.annotationComponentsLock;
            synchronized (object) {
                for (AbstractAnnotationComponent abstractAnnotationComponent : this.annotationComponents) {
                    AbstractAnnotationComponent abstractAnnotationComponent2 = abstractAnnotationComponent;
                    if (abstractAnnotationComponent2 == null || !((Component)abstractAnnotationComponent2).isVisible() || abstractAnnotationComponent2.getAnnotation() instanceof FreeTextAnnotation && abstractAnnotationComponent2.isActive() || abstractAnnotationComponent2.getAnnotation() instanceof TextWidgetAnnotation && abstractAnnotationComponent2.isActive() || abstractAnnotationComponent2.getAnnotation() instanceof ChoiceWidgetAnnotation && abstractAnnotationComponent2.isActive()) continue;
                    abstractAnnotationComponent2.getAnnotation().render(graphics2D, 1, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), abstractAnnotationComponent2.hasFocus() && bl);
                }
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            graphics2D.setTransform(affineTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDestinations(Graphics graphics) {
        Page page = this.getPage();
        if (page != null && this.documentViewController.getParentController().getViewModel().isAnnotationEditingMode() && this.destinationComponents != null && this.destinationComponents.size() > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            AffineTransform affineTransform2 = page.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            graphics2D.transform(affineTransform2);
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 0));
            Object object = this.annotationComponentsLock;
            synchronized (object) {
                for (DestinationComponent destinationComponent : this.destinationComponents) {
                    DestinationComponent destinationComponent2 = destinationComponent;
                    Destination destination = destinationComponent2.getDestination();
                    if (destination.getLeft() == null || destination.getTop() == null) continue;
                    DestinationComponent.paintDestination(destination, graphics2D);
                }
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        int n = this.documentViewModel.getViewCurrentPageIndex();
        this.documentViewModel.setViewCurrentPageIndex(this.pageIndex);
        this.documentViewController.firePropertyChange("documentCurrentPage", n, this.pageIndex);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView(String string, Object object, Object object2) {
        super.updateView(string, object, object2);
        if ("documentViewRotationChange".equals(string) || "documentViewZoomChange".equals(string)) {
            Object object3;
            if (this.annotationComponents != null) {
                object3 = this.annotationComponentsLock;
                synchronized (object3) {
                    for (AbstractAnnotationComponent jComponent : this.annotationComponents) {
                        jComponent.validate();
                    }
                }
            }
            if (this.destinationComponents != null) {
                object3 = this.annotationComponentsLock;
                synchronized (object3) {
                    for (DestinationComponent destinationComponent : this.destinationComponents) {
                        destinationComponent.validate();
                    }
                }
            }
        }
    }

    public void addAnnotation(AnnotationComponent annotationComponent) {
        if (this.annotationComponents == null) {
            this.annotationComponents = new ArrayList();
            this.annotationToComponent = new HashMap<Annotation, AnnotationComponent>();
        }
        this.annotationComponents.add((AbstractAnnotationComponent)annotationComponent);
        this.annotationToComponent.put(annotationComponent.getAnnotation(), annotationComponent);
        if (annotationComponent instanceof PopupAnnotationComponent) {
            this.addPopupAnnotationComponent((PopupAnnotationComponent)annotationComponent);
        } else if (annotationComponent instanceof MarkupAnnotationComponent) {
            MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)annotationComponent;
            PopupAnnotationComponent popupAnnotationComponent = markupAnnotationComponent.getPopupAnnotationComponent();
            this.addPopupAnnotationComponentGlue(markupAnnotationComponent, popupAnnotationComponent);
            this.setLayer((AbstractAnnotationComponent)annotationComponent, JLayeredPane.PALETTE_LAYER);
            this.add((AbstractAnnotationComponent)annotationComponent);
        } else {
            this.setLayer((AbstractAnnotationComponent)annotationComponent, JLayeredPane.PALETTE_LAYER);
            this.add((AbstractAnnotationComponent)annotationComponent);
        }
    }

    public void removeAnnotation(AnnotationComponent annotationComponent) {
        this.annotationComponents.remove(annotationComponent);
        if (annotationComponent.getAnnotation() != null) {
            this.annotationToComponent.remove(annotationComponent.getAnnotation());
        } else {
            this.annotationToComponent.entrySet().stream().filter(entry -> ((AnnotationComponent)entry.getValue()).equals(annotationComponent)).findFirst().ifPresent(entry -> this.annotationToComponent.remove(entry.getKey()));
        }
        if (annotationComponent instanceof PopupAnnotationComponent) {
            this.removePopupAnnotationComponent((PopupAnnotationComponent)annotationComponent);
        } else {
            this.remove((AbstractAnnotationComponent)annotationComponent);
        }
    }

    public void removeDestination(DestinationComponent destinationComponent) {
        this.destinationComponents.remove(destinationComponent);
        this.remove(destinationComponent);
    }

    @Override
    public void pageInitializedCallback(Page page) {
        this.refreshAnnotationComponents(page);
        this.refreshDestinationComponents(page);
    }

    @Override
    public void pageTeardownCallback() {
        SwingUtilities.invokeLater(() -> {
            ArrayList<PageViewAnnotationComponent> arrayList = this.documentViewModel.getDocumentViewAnnotationComponents(this);
            if (arrayList != null) {
                for (PageViewAnnotationComponent pageViewAnnotationComponent : arrayList) {
                    this.parentDocumentView.remove((JComponent)((Object)pageViewAnnotationComponent));
                    if (!(pageViewAnnotationComponent instanceof MarkupGlueComponent)) continue;
                    ((MarkupGlueComponent)pageViewAnnotationComponent).dispose();
                }
            }
            this.documentViewModel.removeAllFloatingAnnotationComponent(this);
            this.annotationComponents = null;
            this.annotationToComponent = null;
        });
    }

    public void refreshDestinationComponents(Page page) {
        this.refreshDestinationComponents(page, true);
    }

    public void refreshDestinationComponents(Page page, boolean bl) {
        if (page != null) {
            if (bl) {
                Page page2 = page;
                SwingUtilities.invokeLater(() -> this.initializeDestinationComponents(page2));
            } else {
                this.initializeDestinationComponents(page);
            }
        }
    }

    public void refreshAnnotationComponents(Page page) {
        this.refreshAnnotationComponents(page, true);
    }

    public void refreshAnnotationComponents(Page page, boolean bl) {
        if (page != null) {
            if (bl) {
                Page page2 = page;
                SwingUtilities.invokeLater(() -> this.initializeAnnotationsComponent(page2));
            } else {
                this.initializeAnnotationsComponent(page);
            }
        }
    }

    private void initializeAnnotationsComponent(Page page) {
        List list = page.getAnnotations();
        PageViewComponentImpl pageViewComponentImpl = this;
        if (this.documentViewController.getAnnotationCallback() != null) {
            this.documentViewController.getAnnotationCallback().pageAnnotationsInitialized(page);
        }
        if (list != null && !list.isEmpty() && this.annotationComponents == null) {
            this.annotationComponents = new ArrayList(list.size());
            this.annotationToComponent = new HashMap<Annotation, AnnotationComponent>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                AbstractAnnotationComponent abstractAnnotationComponent;
                AbstractAnnotationComponent abstractAnnotationComponent2;
                AbstractAnnotationComponent abstractAnnotationComponent3;
                Annotation annotation = (Annotation)list.get(i);
                if (annotation == null || (abstractAnnotationComponent3 = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, pageViewComponentImpl)) == null) continue;
                this.annotationComponents.add(abstractAnnotationComponent3);
                this.annotationToComponent.put(annotation, abstractAnnotationComponent3);
                if (abstractAnnotationComponent3 instanceof PopupAnnotationComponent) {
                    abstractAnnotationComponent2 = (PopupAnnotationComponent)abstractAnnotationComponent3;
                    abstractAnnotationComponent = ((PopupAnnotationComponent)abstractAnnotationComponent2).getMarkupAnnotationComponent();
                    if (abstractAnnotationComponent != null) {
                        this.addPopupAnnotationComponentGlue((MarkupAnnotationComponent)abstractAnnotationComponent, (PopupAnnotationComponent)abstractAnnotationComponent2);
                    }
                    this.addPopupAnnotationComponent((PopupAnnotationComponent)abstractAnnotationComponent2);
                } else if (abstractAnnotationComponent3 instanceof MarkupAnnotationComponent) {
                    abstractAnnotationComponent2 = (MarkupAnnotationComponent)abstractAnnotationComponent3;
                    abstractAnnotationComponent = ((MarkupAnnotationComponent)abstractAnnotationComponent2).getPopupAnnotationComponent();
                    if (abstractAnnotationComponent != null) {
                        this.addPopupAnnotationComponentGlue((MarkupAnnotationComponent)abstractAnnotationComponent2, (PopupAnnotationComponent)abstractAnnotationComponent);
                    }
                    pageViewComponentImpl.setLayer(abstractAnnotationComponent3, JLayeredPane.PALETTE_LAYER);
                    pageViewComponentImpl.add(abstractAnnotationComponent2);
                } else {
                    pageViewComponentImpl.setLayer(abstractAnnotationComponent3, JLayeredPane.PALETTE_LAYER);
                    pageViewComponentImpl.add(abstractAnnotationComponent3);
                }
                abstractAnnotationComponent3.revalidate();
                abstractAnnotationComponent3.repaint();
            }
        }
    }

    private void addPopupAnnotationComponent(PopupAnnotationComponent popupAnnotationComponent) {
        popupAnnotationComponent.setParentPageComponent(this);
        popupAnnotationComponent.refreshDirtyBounds();
        this.documentViewModel.addDocumentViewAnnotationComponent(this, popupAnnotationComponent);
        ((JLayeredPane)((Object)this.parentDocumentView)).setLayer(popupAnnotationComponent, JLayeredPane.POPUP_LAYER);
        this.parentDocumentView.add(popupAnnotationComponent);
    }

    private void addPopupAnnotationComponentGlue(MarkupAnnotationComponent markupAnnotationComponent, PopupAnnotationComponent popupAnnotationComponent) {
        MarkupGlueComponent markupGlueComponent = new MarkupGlueComponent(this.documentViewController, markupAnnotationComponent, popupAnnotationComponent);
        markupGlueComponent.setParentPageComponent(this);
        markupGlueComponent.refreshDirtyBounds();
        this.documentViewModel.addDocumentViewAnnotationComponent(this, markupGlueComponent);
        ((JLayeredPane)((Object)this.parentDocumentView)).setLayer(markupGlueComponent, JLayeredPane.MODAL_LAYER);
        this.parentDocumentView.add(markupGlueComponent);
    }

    private void removePopupAnnotationComponent(PopupAnnotationComponent popupAnnotationComponent) {
        this.parentDocumentView.remove(popupAnnotationComponent);
        this.documentViewModel.removeDocumentViewAnnotationComponent(this, popupAnnotationComponent);
        ArrayList<PageViewAnnotationComponent> arrayList = this.documentViewModel.getDocumentViewAnnotationComponents(this);
        for (PageViewAnnotationComponent pageViewAnnotationComponent : arrayList) {
            if (!(pageViewAnnotationComponent instanceof MarkupGlueComponent) || !((MarkupGlueComponent)pageViewAnnotationComponent).getPopupAnnotationComponent().equals(popupAnnotationComponent)) continue;
            this.parentDocumentView.remove((JComponent)((Object)pageViewAnnotationComponent));
        }
    }

    private void initializeDestinationComponents(Page page) {
        Catalog catalog;
        if (page != null && (catalog = this.documentViewController.getDocument().getCatalog()).getNames() != null && catalog.getNames().getDestsNameTree() != null) {
            NameTree nameTree = catalog.getNames().getDestsNameTree();
            ArrayList arrayList = nameTree.findDestinations(page.getPObjectReference());
            PageViewComponentImpl pageViewComponentImpl = this;
            if (arrayList != null && arrayList.size() > 0) {
                this.destinationComponents = new ArrayList(arrayList.size());
                for (Destination destination : arrayList) {
                    DestinationComponent destinationComponent = new DestinationComponent(destination, this.documentViewController, this);
                    pageViewComponentImpl.setLayer(destinationComponent, JLayeredPane.PALETTE_LAYER);
                    pageViewComponentImpl.add(destinationComponent);
                    this.destinationComponents.add(destinationComponent);
                    destinationComponent.revalidate();
                    destinationComponent.repaint();
                }
            }
        }
    }
}

