/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.signatures;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.acroform.InteractiveForm;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.common.AbstractTask;
import org.icepdf.ri.common.AbstractWorkerPanel;
import org.icepdf.ri.common.utility.signatures.SignaturesHandlerPanel;
import org.icepdf.ri.common.views.Controller;

public class VerifyAllSignaturesTask
extends AbstractTask<Void, Object> {
    private static final Logger logger = Logger.getLogger(VerifyAllSignaturesTask.class.toString());

    public VerifyAllSignaturesTask(Controller controller, AbstractWorkerPanel abstractWorkerPanel, ResourceBundle resourceBundle) {
        super(controller, abstractWorkerPanel, resourceBundle);
    }

    @Override
    protected Void doInBackground() {
        MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.verify.initializingMessage.label"));
        try {
            Document document = this.controller.getDocument();
            InteractiveForm interactiveForm = document.getCatalog().getInteractiveForm();
            interactiveForm.isSignaturesCoverDocumentLength();
            ArrayList arrayList = interactiveForm.getSignatureFields();
            boolean bl = false;
            if (arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n && !this.isCancelled(); ++i) {
                    this.taskStatusMessage = messageFormat.format(new Object[]{i + 1, arrayList.size()});
                    SignatureWidgetAnnotation signatureWidgetAnnotation = (SignatureWidgetAnnotation)arrayList.get(i);
                    SignatureDictionary signatureDictionary = signatureWidgetAnnotation.getSignatureDictionary();
                    if (signatureDictionary.getEntries().size() > 0) {
                        try {
                            signatureWidgetAnnotation.getSignatureValidator().validate();
                            signatureWidgetAnnotation.getSignatureValidator().isSignaturesCoverDocumentLength();
                        }
                        catch (SignatureIntegrityException signatureIntegrityException) {
                            logger.log(Level.WARNING, "Error verifying signature.", signatureIntegrityException);
                        }
                        this.publish(signatureWidgetAnnotation);
                    } else {
                        bl = true;
                    }
                    Thread.yield();
                }
                if (bl) {
                    this.publish(arrayList);
                }
            }
            this.taskStatusMessage = this.messageBundle.getString("viewer.utilityPane.signatures.verify.completeMessage.label");
        }
        catch (Exception exception) {
            logger.log(Level.FINER, "Error verifying signatures.", exception);
        }
        return null;
    }

    @Override
    protected void process(List<Object> list) {
        for (Object object : list) {
            if (object instanceof SignatureWidgetAnnotation) {
                ((SignaturesHandlerPanel)this.workerPanel).addSignature((SignatureWidgetAnnotation)object);
                continue;
            }
            if (!(object instanceof ArrayList)) continue;
            ((SignaturesHandlerPanel)this.workerPanel).addUnsignedSignatures((ArrayList)object);
        }
    }

    @Override
    protected void done() {
        this.workerPanel.validate();
    }
}

