/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.search.DestinationResult;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.search.SearchMode;
import org.icepdf.ri.common.utility.search.BaseSearchModel;
import org.icepdf.ri.common.views.Controller;

public class SearchTextTask
extends SwingWorker<Void, SearchResult> {
    private static final int WORD_PADDING = 6;
    private final int lengthOfTask;
    private int current;
    private String dialogMessage;
    private MessageFormat searchingMessageForm;
    private MessageFormat searchResultMessageForm;
    private MessageFormat searchCompletionMessageForm;
    private int totalHitCount;
    private final String pattern;
    private Pattern searchPattern;
    private final boolean wholeWord;
    private final boolean caseSensitive;
    private final boolean cumulative;
    private final boolean showPages;
    private final boolean regex;
    private final boolean text;
    private final boolean forms;
    private final boolean comments;
    private final boolean outlines;
    private final boolean destinations;
    private final SearchMode searchMode;
    private final Controller controller;
    private final BaseSearchModel searchModel;
    private final Container viewContainer;

    private SearchTextTask(Builder builder) {
        this.controller = builder.controller;
        this.pattern = builder.pattern;
        if (this.pattern != null && !this.pattern.isEmpty()) {
            this.searchPattern = Pattern.compile(this.isCaseSensitive() ? this.pattern : this.pattern.toLowerCase());
        }
        this.searchMode = builder.wholePage ? SearchMode.PAGE : SearchMode.WORD;
        this.wholeWord = builder.wholeWord;
        this.caseSensitive = builder.caseSensitive;
        this.cumulative = builder.cumulative;
        this.regex = builder.regex;
        this.showPages = builder.showPages;
        boolean bl = builder.r2L;
        this.text = builder.text;
        this.forms = builder.forms;
        this.comments = builder.comments;
        this.outlines = builder.outlines;
        this.destinations = builder.destinations;
        this.viewContainer = this.controller.getDocumentViewController().getViewContainer();
        this.lengthOfTask = this.controller.getDocument().getNumberOfPages();
        this.searchModel = builder.searchModel;
        if (this.searchModel != null) {
            this.searchingMessageForm = this.searchModel.setupSearchingMessageForm();
            this.searchResultMessageForm = this.searchModel.setupSearchResultMessageForm();
            this.searchCompletionMessageForm = this.searchModel.setupSearchCompletionMessageForm();
        }
    }

    public int getCurrent() {
        return this.current;
    }

    @Override
    protected Void doInBackground() {
        if ("".equals(this.pattern) || " ".equals(this.pattern)) {
            return null;
        }
        this.totalHitCount = 0;
        this.current = 0;
        DocumentSearchController documentSearchController = this.controller.getDocumentSearchController();
        if (!this.cumulative) {
            documentSearchController.clearAllSearchHighlight();
        }
        documentSearchController.setSearchMode(this.searchMode);
        documentSearchController.addSearchTerm(this.pattern, this.caseSensitive, this.wholeWord, this.regex);
        Document document = this.controller.getDocument();
        if (this.text || this.comments || this.forms) {
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                String string;
                int n;
                List list;
                if (this.isCancelled()) {
                    this.setDialogMessage();
                    break;
                }
                this.current = i;
                Object[] objectArray = new Object[]{String.valueOf(this.current + 1), this.lengthOfTask, this.lengthOfTask};
                if (this.searchingMessageForm != null) {
                    this.dialogMessage = this.searchingMessageForm.format(objectArray);
                }
                if (this.text) {
                    list = documentSearchController.searchHighlightPage(this.current, 6);
                    n = list.size();
                    this.totalHitCount += n;
                    if (this.isCancelled()) break;
                    if (n > 0) {
                        objectArray = new Object[]{String.valueOf(this.current + 1), n, n};
                        String string2 = string = this.searchResultMessageForm != null ? this.searchResultMessageForm.format(objectArray) : "";
                        if (this.searchModel != null) {
                            this.publish(new TextResult(list, string, i));
                        }
                    } else {
                        this.publish(new SearchResult());
                    }
                }
                if (this.comments && (list = documentSearchController.searchComments(this.current)) != null && ((ArrayList)list).size() > 0) {
                    n = ((ArrayList)list).size();
                    objectArray = new Object[]{String.valueOf(this.current + 1), n, n};
                    string = this.searchResultMessageForm != null ? this.searchResultMessageForm.format(objectArray) : "";
                    this.publish(new CommentsResult(list, string, this.current));
                }
                if (!this.forms || (list = documentSearchController.searchForms(this.current)).isEmpty()) continue;
                n = list.size();
                objectArray = new Object[]{String.valueOf(this.current + 1), n, n};
                string = this.searchResultMessageForm != null ? this.searchResultMessageForm.format(objectArray) : "";
                this.publish(new FormsResult(list, string, this.current));
            }
        }
        if (this.outlines) {
            if (this.isCancelled()) {
                return null;
            }
            ArrayList arrayList = documentSearchController.searchOutlines();
            if (arrayList != null && arrayList.size() > 0) {
                this.publish(new OutlineResult(arrayList));
            }
        }
        if (this.destinations) {
            if (this.isCancelled()) {
                return null;
            }
            ArrayList arrayList = documentSearchController.searchDestinations();
            if (arrayList != null && arrayList.size() > 0) {
                this.publish(new DestinationsResult(arrayList));
            }
        }
        this.setDialogMessage();
        return null;
    }

    @Override
    protected void process(List<SearchResult> list) {
        if (this.searchModel != null) {
            for (SearchResult searchResult : list) {
                SearchResult searchResult2;
                if (this.isCancelled()) break;
                if (searchResult instanceof CommentsResult) {
                    searchResult2 = (CommentsResult)searchResult;
                    this.searchModel.addFoundCommentEntry((CommentsResult)searchResult2, this);
                    continue;
                }
                if (searchResult instanceof TextResult) {
                    searchResult2 = (TextResult)searchResult;
                    this.searchModel.addFoundTextEntry((TextResult)searchResult2, this);
                    continue;
                }
                if (searchResult instanceof FormsResult) {
                    searchResult2 = (FormsResult)searchResult;
                    this.searchModel.addFoundFormsEntry((FormsResult)searchResult2, this);
                    continue;
                }
                if (searchResult instanceof OutlineResult) {
                    searchResult2 = (OutlineResult)searchResult;
                    this.searchModel.addFoundOutlineEntry((OutlineResult)searchResult2, this);
                    continue;
                }
                if (!(searchResult instanceof DestinationsResult)) continue;
                searchResult2 = (DestinationsResult)searchResult;
                this.searchModel.addFoundDestinationEntry((DestinationsResult)searchResult2, this);
            }
            this.searchModel.updateProgressControls(this.dialogMessage);
        }
        this.viewContainer.repaint();
    }

    @Override
    protected void done() {
        if (this.searchModel != null) {
            this.searchModel.updateProgressControls(this.dialogMessage);
        }
        this.viewContainer.validate();
    }

    private void setDialogMessage() {
        Object[] objectArray = new Object[]{String.valueOf(this.current + 1), this.current + 1, this.totalHitCount};
        if (this.searchResultMessageForm != null) {
            this.dialogMessage = this.searchCompletionMessageForm.format(objectArray);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public boolean isWholeWord() {
        return this.wholeWord;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    public boolean isShowPages() {
        return this.showPages;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public boolean isText() {
        return this.text;
    }

    public boolean isForms() {
        return this.forms;
    }

    public boolean isComments() {
        return this.comments;
    }

    public boolean isOutlines() {
        return this.outlines;
    }

    public boolean isDestinations() {
        return this.destinations;
    }

    public static class Builder {
        private final Controller controller;
        private final String pattern;
        private BaseSearchModel searchModel;
        private boolean wholePage;
        private boolean wholeWord;
        private boolean caseSensitive;
        private boolean cumulative;
        private boolean showPages;
        private boolean r2L;
        private boolean regex;
        private boolean text;
        private boolean forms;
        private boolean comments;
        private boolean outlines;
        private boolean destinations;

        public Builder(Controller controller, String string) {
            this.controller = controller;
            this.pattern = string;
        }

        public Builder setSearchModel(BaseSearchModel baseSearchModel) {
            this.searchModel = baseSearchModel;
            return this;
        }

        public Builder setWholePage(boolean bl) {
            this.wholePage = bl;
            return this;
        }

        public Builder setWholeWord(boolean bl) {
            this.wholeWord = bl;
            return this;
        }

        public Builder setCaseSensitive(boolean bl) {
            this.caseSensitive = bl;
            return this;
        }

        public Builder setCumulative(boolean bl) {
            this.cumulative = bl;
            return this;
        }

        public Builder setShowPages(boolean bl) {
            this.showPages = bl;
            return this;
        }

        public Builder setR2L(boolean bl) {
            this.r2L = bl;
            return this;
        }

        public Builder setRegex(boolean bl) {
            this.regex = bl;
            return this;
        }

        public Builder setText(boolean bl) {
            this.text = bl;
            return this;
        }

        public Builder setForms(boolean bl) {
            this.forms = bl;
            return this;
        }

        public Builder setComments(boolean bl) {
            this.comments = bl;
            return this;
        }

        public Builder setOutlines(boolean bl) {
            this.outlines = bl;
            return this;
        }

        public Builder setDestinations(boolean bl) {
            this.destinations = bl;
            return this;
        }

        public SearchTextTask build() {
            return new SearchTextTask(this);
        }
    }

    public static class DestinationsResult
    extends SearchResult {
        private final List<DestinationResult> destinationsResult;

        public DestinationsResult(List<DestinationResult> list) {
            super(null);
            this.destinationsResult = list;
        }

        public List<DestinationResult> getDestinationsResult() {
            return this.destinationsResult;
        }
    }

    public static class OutlineResult
    extends SearchResult {
        private final List<OutlineItem> outlinesMatches;

        public OutlineResult(List<OutlineItem> list) {
            super(null);
            this.outlinesMatches = list;
        }

        public List<OutlineItem> getOutlinesMatches() {
            return this.outlinesMatches;
        }
    }

    public static class CommentsResult
    extends SearchResult {
        private final List<MarkupAnnotation> markupAnnotations;
        private final int currentPage;

        public CommentsResult(List<MarkupAnnotation> list, String string, int n) {
            super(string);
            this.markupAnnotations = list;
            this.currentPage = n;
        }

        public List<MarkupAnnotation> getMarkupAnnotations() {
            return this.markupAnnotations;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }
    }

    public static class FormsResult
    extends SearchResult {
        private final List<TextWidgetAnnotation> widgets;
        private final int currentPage;

        public FormsResult(List<TextWidgetAnnotation> list, String string, int n) {
            super(string);
            this.widgets = list;
            this.currentPage = n;
        }

        public List<TextWidgetAnnotation> getWidgets() {
            return this.widgets;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }
    }

    public static class TextResult
    extends SearchResult {
        private final List<LineText> lineItems;
        private final int currentPage;

        public TextResult(List<LineText> list, String string, int n) {
            super(string);
            this.lineItems = list;
            this.currentPage = n;
        }

        public List<LineText> getLineItems() {
            return this.lineItems;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }
    }

    public static class SearchResult {
        private final String nodeText;

        public SearchResult() {
            this.nodeText = null;
        }

        public SearchResult(String string) {
            this.nodeText = string;
        }

        public String getNodeText() {
            return this.nodeText;
        }
    }
}

