/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.outline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.icepdf.core.pobjects.OutlineItem;

public class OutlineItemTreeNode
extends DefaultMutableTreeNode {
    private OutlineItem item;
    private boolean loadedChildren;

    public OutlineItemTreeNode(OutlineItem outlineItem) {
        this.item = outlineItem;
        this.loadedChildren = false;
        this.setUserObject(outlineItem.getTitle());
    }

    public OutlineItemTreeNode(OutlineItem outlineItem, Pattern pattern, boolean bl) {
        this.item = outlineItem;
        this.loadedChildren = false;
        this.setUserObject(this.applyMessage(outlineItem.getTitle(), pattern, bl));
    }

    private String applyMessage(String string, Pattern pattern, boolean bl) {
        Matcher matcher = pattern.matcher(bl ? string : string.toLowerCase());
        StringBuilder stringBuilder = new StringBuilder("<html>");
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuilder.append(string, n, n2);
            stringBuilder.append("<b>");
            stringBuilder.append(string, n2, n3);
            stringBuilder.append("</b>");
            n = n3;
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    public OutlineItem getOutlineItem() {
        return this.item;
    }

    public void recursivelyClearOutlineItems() {
        this.item = null;
        if (this.loadedChildren) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)this.getChildAt(i);
                outlineItemTreeNode.recursivelyClearOutlineItems();
            }
        }
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenLoaded();
        return super.getChildCount();
    }

    private void ensureChildrenLoaded() {
        if (!this.loadedChildren) {
            this.loadedChildren = true;
            int n = this.item.getSubItemCount();
            for (int i = 0; i < n; ++i) {
                OutlineItem outlineItem = this.item.getSubItem(i);
                OutlineItemTreeNode outlineItemTreeNode = new OutlineItemTreeNode(outlineItem);
                this.add(outlineItemTreeNode);
            }
        }
    }
}

