/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.layers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import org.icepdf.ri.common.utility.layers.LayersTreeNode;

class CheckBoxRenderer
extends JPanel
implements TreeCellRenderer {
    protected final JCheckBox checkBox;
    protected final TreeLabel treeLabel;

    public CheckBoxRenderer() {
        this.setLayout(null);
        this.checkBox = new JCheckBox();
        this.add(this.checkBox);
        this.treeLabel = new TreeLabel();
        this.add(this.treeLabel);
        this.checkBox.setBackground(UIManager.getColor("Tree.textBackground"));
        this.treeLabel.setForeground(UIManager.getColor("Tree.textForeground"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setEnabled(jTree.isEnabled());
        if (object instanceof LayersTreeNode) {
            this.checkBox.setSelected(((LayersTreeNode)object).isSelected());
        }
        this.treeLabel.setFont(jTree.getFont());
        this.treeLabel.setText(string);
        this.treeLabel.setSelected(bl);
        this.treeLabel.setFocus(bl4);
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.checkBox.getPreferredSize();
        Dimension dimension2 = this.treeLabel.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.checkBox.getPreferredSize();
        Dimension dimension2 = this.treeLabel.getPreferredSize();
        int n = 0;
        int n2 = 0;
        if (dimension.height < dimension2.height) {
            n = (dimension2.height - dimension.height) / 2;
        } else {
            n2 = (dimension.height - dimension2.height) / 2;
        }
        this.checkBox.setLocation(0, n);
        this.checkBox.setBounds(0, n, dimension.width, dimension.height);
        this.treeLabel.setLocation(dimension.width, n2);
        this.treeLabel.setBounds(dimension.width, n2, dimension2.width, dimension2.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public static class TreeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics graphics) {
            String string = this.getText();
            if (string != null && 0 < string.length()) {
                if (this.isSelected) {
                    graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    graphics.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension dimension = this.getPreferredSize();
                int n = 0;
                Icon icon = this.getIcon();
                if (icon != null) {
                    n = icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                graphics.fillRect(n, 0, dimension.width - 1 - n, dimension.height);
                if (this.hasFocus) {
                    graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    graphics.drawRect(n, 0, dimension.width - 1 - n, dimension.height - 1);
                }
            }
            super.paint(graphics);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension = new Dimension(dimension.width + 3, dimension.height);
            }
            return dimension;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public void setFocus(boolean bl) {
            this.hasFocus = bl;
        }
    }
}

