/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.attachment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.DictionaryEntries;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.EmbeddedFileStream;
import org.icepdf.core.pobjects.FileSpecification;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.utility.attachment.FileTableModel;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.Resources;
import org.icepdf.ri.viewer.WindowManager;

public class AttachmentPanel
extends JPanel
implements MouseListener,
ActionListener,
MutableDocument {
    private static final Logger logger = Logger.getLogger(AttachmentPanel.class.toString());
    private static final String PDF_EXTENSION = ".pdf";
    private final Controller controller;
    private JTable fileTable;
    private FileTableModel fileTableModel;
    private JPopupMenu contextMenu;
    private JMenuItem saveAsMenuItem;
    private HashMap<String, FileSpecification> files;
    private final ResourceBundle messageBundle;

    public AttachmentPanel(SwingController swingController) {
        this.controller = swingController;
        this.setFocusable(true);
        this.messageBundle = this.controller.getMessageBundle();
    }

    private void buildUI() {
        this.fileTableModel = new FileTableModel(this.messageBundle, this.files);
        this.fileTable = new JTable(this.fileTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                if (n3 == 0) {
                    TableModel tableModel = this.getModel();
                    string = (String)tableModel.getValueAt(n, 0);
                } else if (n3 == 1) {
                    TableModel tableModel = this.getModel();
                    string = (String)tableModel.getValueAt(n, 1);
                } else if (n3 == 2) {
                    TableModel tableModel = this.getModel();
                    string = tableModel.getValueAt(n, 2).toString();
                } else if (n3 == 3) {
                    TableModel tableModel = this.getModel();
                    string = tableModel.getValueAt(n, 3).toString();
                } else if (n3 == 4) {
                    TableModel tableModel = this.getModel();
                    string = tableModel.getValueAt(n, 4).toString();
                } else {
                    string = super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
        this.fileTable.setSelectionMode(0);
        this.fileTable.getColumnModel().getColumn(0).setPreferredWidth(225);
        this.fileTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.fileTable.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.fileTable.getColumnModel().getColumn(3).setPreferredWidth(75);
        this.fileTable.getColumnModel().getColumn(4).setPreferredWidth(75);
        this.fileTable.addMouseListener(this);
        this.contextMenu = new JPopupMenu();
        this.saveAsMenuItem = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.attachments.menu.saveAs.label"), new ImageIcon(Images.get("save_a_24.png")));
        this.saveAsMenuItem.addActionListener(this);
        this.contextMenu.add(this.saveAsMenuItem);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.fileTable, 22, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public void refreshDocumentInstance() {
        NameTree nameTree;
        List list;
        Catalog catalog;
        this.disposeDocument();
        Document document = this.controller.getDocument();
        if (document != null && (catalog = document.getCatalog()).getEmbeddedFilesNameTree() != null && (list = (nameTree = catalog.getEmbeddedFilesNameTree()).getNamesAndValues()) != null) {
            Library library = catalog.getLibrary();
            int n = list.size();
            this.files = new HashMap(n / 2);
            for (int i = 0; i < n; i += 2) {
                Object object = library.getObject(list.get(i));
                Object object2 = library.getObject(list.get(i + 1));
                if (!(object instanceof LiteralStringObject) || !(object2 instanceof HashMap)) continue;
                String string = Utils.convertStringObject((Library)library, (StringObject)((LiteralStringObject)object));
                this.files.put(string, new FileSpecification(library, (DictionaryEntries)object2));
            }
            this.buildUI();
        }
    }

    @Override
    public void disposeDocument() {
        this.removeAll();
        this.files = null;
        this.fileTableModel = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        if (actionEvent.getSource().equals(this.saveAsMenuItem) && (object = this.fileTableModel.getValueAt(n = this.fileTable.getSelectedRow(), 5)) instanceof FileSpecification) {
            FileSpecification fileSpecification = (FileSpecification)object;
            EmbeddedFileStream embeddedFileStream = fileSpecification.getEmbeddedFileStream();
            String string = (String)this.fileTableModel.getValueAt(n, 0);
            Runnable runnable = () -> this.saveFile(string, embeddedFileStream);
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        Object object;
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && (object = this.fileTableModel.getValueAt(n = this.fileTable.getSelectedRow(), 5)) instanceof FileSpecification) {
            FileSpecification fileSpecification = (FileSpecification)object;
            EmbeddedFileStream embeddedFileStream = fileSpecification.getEmbeddedFileStream();
            String string = (String)this.fileTableModel.getValueAt(n, 0);
            if (string.toLowerCase().endsWith(PDF_EXTENSION)) {
                try {
                    InputStream inputStream = embeddedFileStream.getDecodedStreamData();
                    Document document = new Document();
                    document.setInputStream(inputStream, string);
                    WindowManager.getInstance().newWindow(document, string);
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "Error opening PDF file stream " + string, iOException);
                }
                catch (PDFSecurityException pDFSecurityException) {
                    logger.log(Level.WARNING, "Error opening PDF security exception " + string, pDFSecurityException);
                }
            }
        }
        if ((mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) && this.fileTable.isRowSelected(n = this.fileTable.rowAtPoint(mouseEvent.getPoint()))) {
            this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void saveFile(String string, EmbeddedFileStream embeddedFileStream) {
        FileDialog fileDialog = new FileDialog(this.controller.getViewerFrame());
        fileDialog.setTitle(this.messageBundle.getString("viewer.dialog.saveAs.title"));
        fileDialog.setMultipleMode(false);
        fileDialog.setMode(1);
        if (ViewModel.getDefaultFile() != null) {
            fileDialog.setDirectory(ViewModel.getDefaultFile().getAbsolutePath());
        }
        fileDialog.setFile(string);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getFile();
        String string3 = fileDialog.getDirectory();
        if (string2 != null && string3 != null) {
            boolean bl;
            File file = new File(string3 + string2);
            if (file.exists() && !(bl = Resources.showConfirmDialog(this.controller.getViewerFrame(), this.messageBundle, "viewer.utilityPane.attachments.saveAs.replace.title", "viewer.utilityPane.attachments.saveAs.replace.msg", string))) {
                this.saveFile(string, embeddedFileStream);
            }
            try {
                int n;
                InputStream inputStream = embeddedFileStream.getDecodedStreamData();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                fileOutputStream.flush();
                bufferedOutputStream.close();
                fileOutputStream.close();
                inputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.FINE, "Malformed URL Exception ", malformedURLException);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "IO Exception ", iOException);
            }
            ViewModel.setDefaultFile(file);
        }
    }
}

