/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.RgbColorChooser;

public class TextAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener,
ChangeListener {
    private static final int DEFAULT_ICON_NAME = 0;
    private static final Color DEFAULT_COLOR = new Color(1.0f, 1.0f, 0.0f);
    private static ValueLabelItem[] TEXT_ICON_LIST;
    private JComboBox<ValueLabelItem> iconNameBox;
    private JButton colorButton;
    private JSlider transparencySlider;
    private TextAnnotation annotation;

    public TextAnnotationPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        this.annotation = (TextAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.iconNameBox, this.annotation.getIconName());
        this.setButtonBackgroundColor(this.colorButton, this.annotation.getColor());
        this.transparencySlider.setValue(Math.round(this.annotation.getOpacity() * 255.0f));
        this.safeEnable(this.iconNameBox, true);
        this.safeEnable(this.colorButton, true);
        this.safeEnable(this.transparencySlider, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.iconNameBox) {
                this.annotation.setIconName((Name)valueLabelItem.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
            this.preferences.put("application.viewer.preference.annotation.text.icon", this.annotation.getIconName().toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.colorButton && (color = RgbColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.colorChooserTitle"), this.colorButton.getBackground())) != null) {
            this.colorButton.setBackground(color);
            this.annotation.setColor(color);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
            this.preferences.putInt("application.viewer.preference.annotation.text.color", color.getRGB());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.alphaSliderChange(changeEvent, (MarkupAnnotation)this.annotation, "application.viewer.preference.annotation.text.opacity");
    }

    private void createGUI() {
        if (TEXT_ICON_LIST == null) {
            TEXT_ICON_LIST = new ValueLabelItem[]{new ValueLabelItem(TextAnnotation.COMMENT_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.comment")), new ValueLabelItem(TextAnnotation.CHECK_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.check")), new ValueLabelItem(TextAnnotation.CHECK_MARK_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.checkMark")), new ValueLabelItem(TextAnnotation.CIRCLE_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.circle")), new ValueLabelItem(TextAnnotation.CROSS_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.cross")), new ValueLabelItem(TextAnnotation.CROSS_HAIRS_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.crossHairs")), new ValueLabelItem(TextAnnotation.HELP_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.help")), new ValueLabelItem(TextAnnotation.INSERT_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.insert")), new ValueLabelItem(TextAnnotation.KEY_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.key")), new ValueLabelItem(TextAnnotation.NEW_PARAGRAPH_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.newParagraph")), new ValueLabelItem(TextAnnotation.PARAGRAPH_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.paragraph")), new ValueLabelItem(TextAnnotation.RIGHT_ARROW_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.rightArrow")), new ValueLabelItem(TextAnnotation.RIGHT_POINTER_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.rightPointer")), new ValueLabelItem(TextAnnotation.STAR_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.star")), new ValueLabelItem(TextAnnotation.UP_LEFT_ARROW_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.upLeftArrow")), new ValueLabelItem(TextAnnotation.UP_ARROW_ICON, this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName.upArrow"))};
        }
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.text.appearance.title"), 1, 0));
        this.iconNameBox = new JComboBox<ValueLabelItem>(TEXT_ICON_LIST);
        this.iconNameBox.setSelectedIndex(0);
        this.iconNameBox.addItemListener(this);
        JLabel jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.text.iconName"));
        this.addGB(this, jLabel, 0, 0, 1, 1);
        this.addGB(this, this.iconNameBox, 1, 0, 1, 1);
        this.colorButton = new JButton(" ");
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.colorLabel"));
        this.addGB(this, jLabel, 0, 1, 1, 1);
        this.addGB(this, this.colorButton, 1, 1, 1, 1);
        this.transparencySlider = this.buildAlphaSlider();
        this.transparencySlider.setMajorTickSpacing(255);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.transparencyLabel"));
        this.addGB(this, jLabel, 0, 5, 1, 1);
        this.addGB(this, this.transparencySlider, 1, 5, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 6, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.iconNameBox, bl);
        this.safeEnable(this.colorButton, bl);
        this.safeEnable(this.transparencySlider, bl);
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

