/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.NameJTree;
import org.icepdf.ri.common.NameTreeNode;
import org.icepdf.ri.common.views.Controller;

public class NameTreeDialog
extends EscapeJDialog
implements ActionListener,
TreeSelectionListener {
    private final Controller controller;
    private final ResourceBundle messageBundle;
    private JTree nameJTree;
    private NameTreeNode selectedName;
    private String destinationName;
    private JButton okButton;
    private JButton cancelButton;
    private GridBagConstraints constraints;

    public NameTreeDialog(Controller controller, boolean bl, NameTree nameTree) throws HeadlessException {
        super(controller.getViewerFrame(), bl);
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.setGui(nameTree);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.selectedName != null) {
                this.destinationName = this.selectedName.getName().toString();
            }
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.nameJTree.getLastSelectedPathComponent() != null) {
            NameTreeNode nameTreeNode = (NameTreeNode)this.nameJTree.getLastSelectedPathComponent();
            if (nameTreeNode.getReference() != null) {
                this.selectedName = nameTreeNode;
            } else {
                this.nameJTree.setSelectionPath(null);
                this.selectedName = null;
            }
        }
    }

    private void setGui(NameTree nameTree) {
        this.setTitle(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.title"));
        this.nameJTree = new NameJTree();
        this.nameJTree.setModel(new DefaultTreeModel(new NameTreeNode(nameTree.getRoot(), this.messageBundle)));
        this.nameJTree.setRootVisible(!nameTree.getRoot().isEmpty());
        this.nameJTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.nameJTree);
        jScrollPane.setPreferredSize(new Dimension(325, 225));
        this.okButton = new JButton(this.messageBundle.getString("viewer.button.ok.label"));
        this.okButton.setMnemonic(this.messageBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.messageBundle.getString("viewer.button.cancel.label"));
        this.cancelButton.setMnemonic(this.messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        this.cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentY(0.0f);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        this.constraints.insets = new Insets(5, 15, 5, 15);
        this.addGB(jPanel2, jScrollPane, 0, 0, 1, 1);
        this.constraints.anchor = 10;
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.addGB(jPanel2, jPanel, 0, 1, 1, 1);
        this.getContentPane().add(jPanel2);
        this.setSize(new Dimension(375, 350));
        this.validate();
        this.setLocationRelativeTo(this.controller.getViewerFrame());
    }

    public void setDestinationName(String string) {
        this.destinationName = string;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

