/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.RgbColorChooser;

public class BorderPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_LINK_TYPE = 1;
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private static ValueLabelItem[] LINE_STYLE_LIST;
    private JComboBox<ValueLabelItem> borderVisibleBox;
    private JComboBox<ValueLabelItem> lineThicknessBox;
    private JComboBox<ValueLabelItem> lineStyleBox;
    private JButton colorButton;

    public BorderPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        if (annotation.getLineThickness() == 0.0f) {
            this.applySelectedValue(this.borderVisibleBox, false);
        } else {
            this.applySelectedValue(this.borderVisibleBox, true);
        }
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, annotation.getLineStyle());
        this.setButtonBackgroundColor(this.colorButton, annotation.getColor());
        this.enableAppearanceInputComponents(annotation.getBorderType() == 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.borderVisibleBox) {
                boolean bl = (Boolean)valueLabelItem.getValue();
                if (bl) {
                    annotation.getBorderStyle().setStrokeWidth(1.0f);
                    if (annotation.getColor() == null) {
                        annotation.setColor(Color.BLACK);
                    }
                } else {
                    annotation.getBorderStyle().setStrokeWidth(0.0f);
                }
                this.applySelectedValue(this.lineThicknessBox, Float.valueOf(annotation.getLineThickness()));
                this.enableAppearanceInputComponents(bl);
            } else if (itemEvent.getSource() == this.lineThicknessBox) {
                float f = ((Float)valueLabelItem.getValue()).floatValue();
                annotation.getBorderStyle().setStrokeWidth(f);
            } else if (itemEvent.getSource() == this.lineStyleBox) {
                Name name = (Name)valueLabelItem.getValue();
                annotation.getBorderStyle().setBorderStyle(name);
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        Annotation annotation = this.currentAnnotationComponent.getAnnotation();
        if (actionEvent.getSource() == this.colorButton && (color = RgbColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.border.colorChooserTitle"), this.colorButton.getBackground())) != null) {
            this.colorButton.setBackground(color);
            annotation.setColor(color);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        if (LINE_STYLE_LIST == null) {
            LINE_STYLE_LIST = new ValueLabelItem[]{new ValueLabelItem(BorderStyle.BORDER_STYLE_SOLID, this.messageBundle.getString("viewer.utilityPane.annotation.border.solid")), new ValueLabelItem(BorderStyle.BORDER_STYLE_DASHED, this.messageBundle.getString("viewer.utilityPane.annotation.border.dashed")), new ValueLabelItem(BorderStyle.BORDER_STYLE_BEVELED, this.messageBundle.getString("viewer.utilityPane.annotation.border.beveled")), new ValueLabelItem(BorderStyle.BORDER_STYLE_INSET, this.messageBundle.getString("viewer.utilityPane.annotation.border.inset")), new ValueLabelItem(BorderStyle.BORDER_STYLE_UNDERLINE, this.messageBundle.getString("viewer.utilityPane.annotation.border.underline"))};
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.border.title"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.borderVisibleBox = new JComboBox<ValueLabelItem>(VISIBLE_TYPE_LIST);
        this.borderVisibleBox.setSelectedIndex(1);
        this.borderVisibleBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.linkType")), 0, 0, 1, 1);
        this.addGB(this, this.borderVisibleBox, 1, 0, 1, 1);
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.lineThickness")), 0, 1, 1, 1);
        this.addGB(this, this.lineThicknessBox, 1, 1, 1, 1);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.lineStyle")), 0, 2, 1, 1);
        this.addGB(this, this.lineStyleBox, 1, 2, 1, 1);
        this.colorButton = new JButton(" ");
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_BORDER_COLOR);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.border.colorLabel")), 0, 3, 1, 1);
        this.addGB(this, this.colorButton, 1, 3, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 4, 0, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.borderVisibleBox, bl);
        this.safeEnable(this.lineThicknessBox, bl);
        this.safeEnable(this.lineStyleBox, bl);
        this.safeEnable(this.colorButton, bl);
    }

    private void enableAppearanceInputComponents(boolean bl) {
        if (!bl) {
            this.safeEnable(this.borderVisibleBox, true);
            this.safeEnable(this.lineThicknessBox, false);
            this.safeEnable(this.lineStyleBox, false);
            this.safeEnable(this.colorButton, false);
        } else {
            this.safeEnable(this.borderVisibleBox, true);
            this.safeEnable(this.lineThicknessBox, true);
            this.safeEnable(this.lineStyleBox, true);
            this.safeEnable(this.colorButton, true);
        }
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

