/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.ActionsPanel;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.BorderPanel;
import org.icepdf.ri.common.utility.annotation.properties.CircleAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.FlagsPanel;
import org.icepdf.ri.common.utility.annotation.properties.FreeTextAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.InkAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.LineAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.LinkAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.SquareAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.TextAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.TextMarkupAnnotationPanel;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationPanel
extends AnnotationPanelAdapter {
    private final ViewerPropertiesManager propertiesManager;
    private JPanel annotationPanel;
    private AnnotationPanelAdapter annotationPropertyPanel;
    private ActionsPanel actionsPanel;
    private BorderPanel borderPanel;
    private FlagsPanel flagsPanel;

    public AnnotationPanel(Controller controller) {
        this(controller, null);
    }

    public AnnotationPanel(Controller controller, ViewerPropertiesManager viewerPropertiesManager) {
        super(controller);
        this.setLayout(new BorderLayout());
        this.propertiesManager = viewerPropertiesManager;
        this.setFocusable(true);
        this.setGUI();
        this.setEnabled(false);
    }

    public void setAnnotationUtilityToolbar(JToolBar jToolBar) {
        this.addGB(this.annotationPanel, jToolBar, 0, 0, 1, 1);
    }

    public static AnnotationPanelAdapter buildAnnotationPropertyPanel(AnnotationComponent annotationComponent, Controller controller) {
        if (annotationComponent != null) {
            Annotation annotation = annotationComponent.getAnnotation();
            if (annotation instanceof LinkAnnotation) {
                return new LinkAnnotationPanel(controller);
            }
            if (annotation instanceof TextMarkupAnnotation) {
                return new TextMarkupAnnotationPanel(controller);
            }
            if (annotation instanceof LineAnnotation) {
                return new LineAnnotationPanel(controller);
            }
            if (annotation instanceof SquareAnnotation) {
                return new SquareAnnotationPanel(controller);
            }
            if (annotation instanceof CircleAnnotation) {
                return new CircleAnnotationPanel(controller);
            }
            if (annotation instanceof InkAnnotation) {
                return new InkAnnotationPanel(controller);
            }
            if (annotation instanceof TextAnnotation) {
                return new TextAnnotationPanel(controller);
            }
            if (annotation instanceof FreeTextAnnotation) {
                return new FreeTextAnnotationPanel(controller);
            }
        }
        return null;
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (this.annotationPropertyPanel != null) {
            this.annotationPanel.remove(this.annotationPropertyPanel);
        }
        this.annotationPropertyPanel = AnnotationPanel.buildAnnotationPropertyPanel(annotationComponent, this.controller);
        if (this.annotationPropertyPanel != null) {
            this.annotationPropertyPanel.setAnnotationComponent(annotationComponent);
            this.addGB(this.annotationPanel, this.annotationPropertyPanel, 0, 1, 1, 1);
        }
        this.actionsPanel.setAnnotationComponent(annotationComponent);
        if (this.flagsPanel != null) {
            this.flagsPanel.setAnnotationComponent(annotationComponent);
        }
        this.borderPanel.setAnnotationComponent(annotationComponent);
        this.borderPanel.setVisible(!(this.annotationPropertyPanel instanceof LineAnnotationPanel) && !(this.annotationPropertyPanel instanceof SquareAnnotationPanel) && !(this.annotationPropertyPanel instanceof CircleAnnotationPanel) && !(this.annotationPropertyPanel instanceof InkAnnotationPanel) && !(this.annotationPropertyPanel instanceof FreeTextAnnotationPanel) && !(annotationComponent instanceof PopupAnnotationComponent));
        if (annotationComponent instanceof PopupAnnotationComponent) {
            this.actionsPanel.setVisible(false);
            this.flagsPanel.setVisible(false);
        } else {
            this.actionsPanel.setVisible(true);
            this.flagsPanel.setVisible(true);
        }
        if (!annotationComponent.isEditable()) {
            this.setEnabled(annotationComponent.isEditable());
        }
        this.revalidate();
    }

    private void setGUI() {
        this.annotationPanel = new JPanel(new GridBagLayout());
        this.add((Component)this.annotationPanel, "North");
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 1, 5, 1);
        this.actionsPanel = new ActionsPanel(this.controller);
        this.borderPanel = new BorderPanel(this.controller);
        if (this.propertiesManager == null || this.propertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.annotation.flags")) {
            this.flagsPanel = new FlagsPanel(this.controller);
        }
        if (this.annotationPropertyPanel != null) {
            this.addGB(this.annotationPanel, this.annotationPropertyPanel, 0, 1, 1, 1);
        }
        this.addGB(this.annotationPanel, this.borderPanel, 0, 2, 1, 1);
        if (this.flagsPanel != null) {
            this.addGB(this.annotationPanel, this.flagsPanel, 0, 3, 1, 1);
        }
        this.addGB(this.annotationPanel, this.actionsPanel, 0, 4, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.annotationPropertyPanel != null && this.actionsPanel != null) {
            this.annotationPropertyPanel.setEnabled(bl);
            this.actionsPanel.setEnabled(bl);
            this.flagsPanel.setEnabled(bl);
            this.borderPanel.setEnabled(bl);
        }
    }
}

