/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.markup;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.DropDownButton;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.utility.annotation.AnnotationPanel;
import org.icepdf.ri.common.utility.annotation.markup.MarkupAnnotationHandlerPanel;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.widgets.ColorIcon;
import org.icepdf.ri.common.widgets.DragDropColorList;
import org.icepdf.ri.common.widgets.annotations.QuickPaintAnnotationButton;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class MarkupAnnotationPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
MutableDocument,
DocumentListener {
    private static final Logger logger = Logger.getLogger(MarkupAnnotationPanel.class.toString());
    public static final String COLUMN_PROPERTY = "Column";
    protected GridBagConstraints constraints;
    private Preferences preferences;
    private final Controller controller;
    protected final ResourceBundle messageBundle;
    private AnnotationPanel parentPanel;
    private JPanel markupAnnotationPanel;
    private JTextField searchTextField;
    private JButton searchButton;
    private JButton clearSearchButton;
    private DropDownButton filterDropDownButton;
    private JMenu colorFilterMenuItem;
    private final ArrayList<Action> sortActions;
    private Action sortAction;
    private final ArrayList<Action> filterAuthorActions;
    private Action filterAuthorAction;
    private final ArrayList<Action> filterVisibilityActions;
    private Action filterVisibilityAction;
    private final ArrayList<Action> filterTypeActions;
    private Action filterTypeAction;
    private Action filterColorAction;
    private JCheckBoxMenuItem regexMenuItem;
    private JCheckBoxMenuItem caseSensitiveMenutItem;
    private QuickPaintAnnotationButton quickPaintAnnotationButton;
    private MarkupAnnotationHandlerPanel markupAnnotationHandlerPanel;

    public MarkupAnnotationPanel(SwingController swingController) {
        this.messageBundle = swingController.getMessageBundle();
        this.preferences = ViewerPropertiesManager.getInstance().getPreferences();
        this.controller = swingController;
        this.setLayout(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.setFocusable(true);
        ((DocumentViewControllerImpl)swingController.getDocumentViewController()).addPropertyChangeListener(this);
        this.addPropertyChangeListener("annotationPropertyPanelChange", this);
        this.sortActions = new ArrayList(5);
        this.sortActions.add(new SortAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.sort.option.byPage.label"), SortColumn.PAGE));
        this.sortActions.add(new SortAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.sort.option.byAuthor.label"), SortColumn.AUTHOR));
        this.sortActions.add(new SortAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.sort.option.byDate.label"), SortColumn.DATE));
        this.sortActions.add(new SortAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.sort.option.byType.label"), SortColumn.TYPE));
        this.sortActions.add(new SortAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.sort.option.byColor.label"), SortColumn.COLOR));
        this.filterAuthorActions = new ArrayList(3);
        this.filterAuthorActions.add(new FilterAuthorAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byAuthor.all.label"), FilterAuthorColumn.ALL));
        this.filterAuthorActions.add(new FilterAuthorAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byAuthor.current.label"), FilterAuthorColumn.AUTHOR_CURRENT));
        this.filterAuthorActions.add(new FilterAuthorAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byAuthor.others.label"), FilterAuthorColumn.AUTHOR_OTHER));
        this.filterVisibilityActions = new ArrayList(3);
        this.filterVisibilityActions.add(new FilterVisibilityAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byVisibility.all.label"), FilterVisibilityColumn.ALL));
        this.filterVisibilityActions.add(new FilterVisibilityAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byVisibility.public.label"), FilterVisibilityColumn.PUBLIC));
        this.filterVisibilityActions.add(new FilterVisibilityAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byVisibility.private.label"), FilterVisibilityColumn.PRIVATE));
        this.filterTypeActions = new ArrayList(10);
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.all.label"), FilterSubTypeColumn.ALL));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.text.label"), FilterSubTypeColumn.TEXT));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.highlight.label"), FilterSubTypeColumn.HIGHLIGHT));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.underline.label"), FilterSubTypeColumn.UNDERLINE));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.strikeout.label"), FilterSubTypeColumn.STRIKEOUT));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.line.label"), FilterSubTypeColumn.LINE));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.square.label"), FilterSubTypeColumn.SQUARE));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.circle.label"), FilterSubTypeColumn.CIRCLE));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.ink.label"), FilterSubTypeColumn.INK));
        this.filterTypeActions.add(new FilterTypeAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.freeText.label"), FilterSubTypeColumn.FREETEXT));
        this.preferences = swingController.getPropertiesManager().getPreferences();
        this.buildGUI();
        this.setEnabled(false);
    }

    public void setParentPanel(AnnotationPanel annotationPanel) {
        this.parentPanel = annotationPanel;
    }

    public void setAnnotationUtilityToolbar(JToolBar jToolBar) {
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.addGB(this, jToolBar, 0, 0, 1, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        switch (string = propertyChangeEvent.getPropertyName()) {
            case "annotationQuikcColorPropertyChange": {
                AnnotationComponent annotationComponent = this.markupAnnotationHandlerPanel.getSelectedAnnotation();
                if (annotationComponent == null || !(object instanceof Color)) return;
                Annotation annotation = annotationComponent.getAnnotation();
                annotation.setColor((Color)object);
                this.controller.getDocumentViewController().updateAnnotation(annotationComponent);
                annotationComponent.resetAppearanceShapes();
                annotationComponent.repaint();
                if (this.filterColorAction != null) {
                    this.markupAnnotationHandlerPanel.refreshMarkupTree();
                } else {
                    this.markupAnnotationHandlerPanel.repaint();
                }
                if (annotation instanceof TextMarkupAnnotation) {
                    TextMarkupAnnotation textMarkupAnnotation = (TextMarkupAnnotation)annotation;
                    if (textMarkupAnnotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_UNDERLINE)) {
                        this.preferences.putInt("application.viewer.preference.annotation.underline.color", ((Color)object).getRGB());
                        return;
                    }
                    if (!textMarkupAnnotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT)) return;
                    this.preferences.putInt("application.viewer.preference.annotation.strikeout.color", ((Color)object).getRGB());
                    return;
                }
                if (annotation instanceof LineAnnotation) {
                    this.preferences.putInt("application.viewer.preference.annotation.line.color", ((Color)object).getRGB());
                    return;
                }
                if (annotation instanceof SquareAnnotation) {
                    this.preferences.putInt("application.viewer.preference.annotation.square.color", ((Color)object).getRGB());
                    return;
                }
                if (annotation instanceof CircleAnnotation) {
                    this.preferences.putInt("application.viewer.preference.annotation.circle.color", ((Color)object).getRGB());
                    return;
                }
                if (annotation instanceof InkAnnotation) {
                    this.preferences.putInt("application.viewer.preference.annotation.ink.color", ((Color)object).getRGB());
                    return;
                }
                if (!(annotation instanceof FreeTextAnnotation)) return;
            }
            case "annotationSelected": 
            case "annotationFocusGained": {
                AnnotationComponent annotationComponent = (AnnotationComponent)object;
                if (annotationComponent == null || !(annotationComponent.getAnnotation() instanceof MarkupAnnotation)) return;
                this.parentPanel.setSelectedTab("application.utilitypane.show.annotation.markup");
                this.quickPaintAnnotationButton.setColor(annotationComponent.getAnnotation().getColor(), false);
                this.quickPaintAnnotationButton.setEnabled(true);
                this.applyAnnotationStatusLabel(annotationComponent.getAnnotation());
                return;
            }
            case "annotationUpdated": 
            case "annotationSummaryUpdated": {
                AnnotationComponent annotationComponent = (AnnotationComponent)object;
                if (annotationComponent != null && annotationComponent.getAnnotation() instanceof MarkupAnnotation) {
                    this.applyAnnotationStatusLabel(annotationComponent.getAnnotation());
                    return;
                }
                if (annotationComponent == null || !(annotationComponent.getAnnotation() instanceof PopupAnnotation)) return;
                this.applyAnnotationStatusLabel((Annotation)((PopupAnnotation)annotationComponent.getAnnotation()).getParent());
                return;
            }
        }
    }

    protected void applyAnnotationStatusLabel(Annotation annotation) {
        ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        String string = null;
        if (arrayList != null) {
            for (DragDropColorList.ColorLabel colorLabel : arrayList) {
                if (annotation.getColor() == null || !colorLabel.getColor().equals(annotation.getColor())) continue;
                string = colorLabel.getLabel();
                break;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (SystemProperties.PRIVATE_PROPERTY_ENABLED) {
            if (annotation.getFlagPrivateContents()) {
                stringBuilder.append(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.privateToggleButton.label"));
            } else {
                stringBuilder.append(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.publicToggleButton.label"));
            }
        }
        if (string != null) {
            if (SystemProperties.PRIVATE_PROPERTY_ENABLED) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            this.markupAnnotationHandlerPanel.setProgressLabel(stringBuilder.toString());
        }
    }

    public QuickPaintAnnotationButton getQuickPaintAnnotationButton() {
        return this.quickPaintAnnotationButton;
    }

    private void buildGUI() {
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.markupAnnotationPanel = new JPanel(new GridBagLayout());
        this.addGB(this, this.markupAnnotationPanel, 0, 1, 1, 1);
        this.buildSearchBar();
        this.buildMarkupAnnotationCommentView();
        this.buildSortFilterToolBar();
    }

    protected void buildSearchBar() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.searchTextField = new JTextField();
        this.searchTextField.addActionListener(this);
        this.searchTextField.getDocument().addDocumentListener(this);
        this.searchButton = new JButton(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.search.searchButton.label"));
        this.searchButton.setToolTipText(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.search.searchButton.tooltip"));
        this.searchButton.addActionListener(this);
        this.clearSearchButton = new JButton(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.search.clearButton.label"));
        this.clearSearchButton.setToolTipText(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.search.clearButton.tooltip"));
        this.clearSearchButton.addActionListener(this);
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 0, 0, 1);
        this.constraints.weighty = 0.0;
        this.constraints.weightx = 0.9;
        this.addGB(jPanel, this.searchTextField, 0, 0, 1, 1);
        this.constraints.weightx = 0.05;
        this.addGB(jPanel, this.searchButton, 1, 0, 1, 1);
        this.constraints.weightx = 0.05;
        this.addGB(jPanel, this.clearSearchButton, 2, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.01;
        this.addGB(this.markupAnnotationPanel, jPanel, 0, 0, 1, 1);
    }

    protected void buildSortFilterToolBar() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = this.preferences.get("application.icon.default.size", "_32");
        DropDownButton dropDownButton = new DropDownButton(this.controller, "", this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.sort.sortButton.tooltip"), "sort", string, SwingViewBuilder.buildButtonFont());
        String string2 = this.preferences.get("application.viewer.utility.annotation.sort.column", SortColumn.PAGE.toString());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Action object2 : this.sortActions) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            jCheckBoxMenuItem.setAction(object2);
            dropDownButton.add(jCheckBoxMenuItem);
            buttonGroup.add(jCheckBoxMenuItem);
            if (!string2.equals(object2.getValue(COLUMN_PROPERTY).toString())) continue;
            jCheckBoxMenuItem.setSelected(true);
            this.sortAction = object2;
        }
        this.filterDropDownButton = new DropDownButton(this.controller, "", this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.filterButton.tooltip"), "filter", string, SwingViewBuilder.buildButtonFont());
        JMenu jMenu = new JMenu(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byAuthor.label"));
        JMenu jMenu2 = new JMenu(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byType.label"));
        this.colorFilterMenuItem = new JMenu(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byColor.label"));
        string2 = this.preferences.get("application.viewer.utility.annotation.filter.author.column", FilterAuthorColumn.ALL.toString());
        this.filterAuthorAction = this.buildMenuItemGroup(jMenu, this.filterAuthorActions, string2, this.filterAuthorAction);
        JMenu jMenu3 = new JMenu(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byVisibility.label"));
        string2 = this.preferences.get("application.viewer.utility.annotation.filter.visibility.column", FilterVisibilityColumn.ALL.toString());
        this.filterVisibilityAction = this.buildMenuItemGroup(jMenu3, this.filterVisibilityActions, string2, this.filterVisibilityAction);
        string2 = this.preferences.get("application.viewer.utility.annotation.filter.type.column", FilterSubTypeColumn.ALL.toString());
        this.filterTypeAction = this.buildMenuItemGroup(jMenu2, this.filterTypeActions, string2, this.filterTypeAction);
        this.refreshColorPanel();
        boolean bl = this.preferences.getBoolean("application.viewer.utility.search.markup.regex.enabled", true);
        boolean bl2 = this.preferences.getBoolean("application.viewer.utility.search.markup.case.sensitive.enabled", false);
        this.regexMenuItem = new JCheckBoxMenuItem(this.messageBundle.getString("viewer.utilityPane.search.regexCheckbox.label"), bl);
        this.regexMenuItem.addActionListener(this);
        this.caseSensitiveMenutItem = new JCheckBoxMenuItem(this.messageBundle.getString("viewer.utilityPane.search.caseSenstiveCheckbox.label"), bl2);
        this.caseSensitiveMenutItem.addActionListener(this);
        if (bl || bl2) {
            this.regexMenuItem.setEnabled(bl);
            this.caseSensitiveMenutItem.setEnabled(bl2);
        }
        this.filterDropDownButton.add(jMenu);
        this.filterDropDownButton.add(this.colorFilterMenuItem);
        this.filterDropDownButton.add(jMenu2);
        if (SystemProperties.PRIVATE_PROPERTY_ENABLED) {
            this.filterDropDownButton.add(jMenu3);
        }
        this.filterDropDownButton.addSeparator();
        this.filterDropDownButton.add(this.regexMenuItem);
        this.filterDropDownButton.add(this.caseSensitiveMenutItem);
        this.quickPaintAnnotationButton = new QuickPaintAnnotationButton(this.controller, this.messageBundle, this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.quickColorButton.label"), this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.quickColorButton.tooltip"), "paint_bucket", string, SwingViewBuilder.buildButtonFont());
        this.quickPaintAnnotationButton.setEnabled(false);
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 0, 1, 1);
        this.constraints.weightx = 0.05;
        this.constraints.weighty = 0.0;
        this.addGB(jPanel, dropDownButton, 0, 0, 1, 1);
        this.addGB(jPanel, this.filterDropDownButton, 1, 0, 1, 1);
        this.constraints.weightx = 0.9;
        this.addGB(jPanel, new JLabel(" "), 2, 0, 1, 1);
        this.constraints.anchor = 13;
        this.constraints.weightx = 0.05;
        this.addGB(jPanel, this.quickPaintAnnotationButton, 3, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.01;
        this.addGB(this.markupAnnotationPanel, jPanel, 0, 1, 1, 1);
        this.sortAndFilterAnnotationData();
    }

    public void refreshColorPanel() {
        if (this.quickPaintAnnotationButton != null) {
            this.quickPaintAnnotationButton.refreshColorPanel();
        }
        this.colorFilterMenuItem.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setAction(new FilterColorAction(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.toolbar.filter.option.byColor.all.label"), null));
        this.colorFilterMenuItem.add(jCheckBoxMenuItem);
        buttonGroup.add(jCheckBoxMenuItem);
        ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        int n = this.preferences.getInt("application.viewer.utility.annotation.filter.color.column", -1);
        if (arrayList.size() > 0) {
            for (DragDropColorList.ColorLabel colorLabel : arrayList) {
                JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
                FilterColorAction filterColorAction = new FilterColorAction(colorLabel.getLabel(), colorLabel.getColor());
                jCheckBoxMenuItem2.setAction(filterColorAction);
                this.colorFilterMenuItem.add(jCheckBoxMenuItem2);
                buttonGroup.add(jCheckBoxMenuItem2);
                if (n == -1 || n != filterColorAction.getColorRGB()) continue;
                jCheckBoxMenuItem2.setSelected(true);
                this.filterColorAction = filterColorAction;
            }
        }
        if (n == -1) {
            jCheckBoxMenuItem.setSelected(true);
            this.filterColorAction = jCheckBoxMenuItem.getAction();
        }
    }

    private Action buildMenuItemGroup(JMenuItem jMenuItem, ArrayList<Action> arrayList, String string, Action action) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Action action2 : arrayList) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            jCheckBoxMenuItem.setAction(action2);
            jMenuItem.add(jCheckBoxMenuItem);
            buttonGroup.add(jCheckBoxMenuItem);
            if (!string.equals(action2.getValue(COLUMN_PROPERTY).toString())) continue;
            jCheckBoxMenuItem.setSelected(true);
            action = action2;
        }
        return action;
    }

    protected void buildMarkupAnnotationCommentView() {
        this.markupAnnotationHandlerPanel = new MarkupAnnotationHandlerPanel(this.controller, this);
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.9;
        this.addGB(this.markupAnnotationPanel, this.markupAnnotationHandlerPanel, 0, 2, 1, 1);
    }

    @Override
    public void refreshDocumentInstance() {
        this.markupAnnotationHandlerPanel.refreshDocumentInstance();
    }

    @Override
    public void disposeDocument() {
        this.markupAnnotationHandlerPanel.disposeDocument();
        this.quickPaintAnnotationButton.removePropertyChangeListener("annotationQuikcColorPropertyChange", this.controller);
    }

    protected void sortAndFilterAnnotationData() {
        SortColumn sortColumn = (SortColumn)((Object)this.sortAction.getValue(COLUMN_PROPERTY));
        FilterSubTypeColumn filterSubTypeColumn = (FilterSubTypeColumn)((Object)this.filterTypeAction.getValue(COLUMN_PROPERTY));
        FilterAuthorColumn filterAuthorColumn = (FilterAuthorColumn)((Object)this.filterAuthorAction.getValue(COLUMN_PROPERTY));
        Color color = (Color)this.filterColorAction.getValue(COLUMN_PROPERTY);
        FilterVisibilityColumn filterVisibilityColumn = (FilterVisibilityColumn)((Object)this.filterVisibilityAction.getValue(COLUMN_PROPERTY));
        this.filterDropDownButton.setSelected(!filterAuthorColumn.equals((Object)FilterAuthorColumn.ALL) || !filterSubTypeColumn.equals((Object)FilterSubTypeColumn.ALL) || color != null);
        Pattern pattern = null;
        String string = this.searchTextField.getText();
        boolean bl = this.caseSensitiveMenutItem.isSelected();
        if (string != null && !string.isEmpty()) {
            pattern = Pattern.compile(bl ? string : string.toLowerCase());
        }
        this.markupAnnotationHandlerPanel.sortAndFilterAnnotationData(pattern, sortColumn, filterSubTypeColumn, filterAuthorColumn, filterVisibilityColumn, color, this.regexMenuItem.isSelected(), bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            this.sortAndFilterAnnotationData();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Error processing search pattern syntax");
            this.markupAnnotationHandlerPanel.setProgressLabel(patternSyntaxException.getMessage());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            this.sortAndFilterAnnotationData();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Error processing search pattern syntax");
            this.markupAnnotationHandlerPanel.setProgressLabel(patternSyntaxException.getMessage());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        try {
            this.sortAndFilterAnnotationData();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            logger.warning("Error processing search pattern syntax");
            this.markupAnnotationHandlerPanel.setProgressLabel(patternSyntaxException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.searchButton || object == this.searchTextField) {
            try {
                this.sortAndFilterAnnotationData();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logger.warning("Error processing search pattern syntax");
                this.markupAnnotationHandlerPanel.setProgressLabel(patternSyntaxException.getMessage());
            }
        } else if (object == this.clearSearchButton) {
            this.searchTextField.setText("");
            this.sortAndFilterAnnotationData();
        } else if (object == this.regexMenuItem) {
            this.caseSensitiveMenutItem.setEnabled(!this.regexMenuItem.isSelected());
            this.preferences.putBoolean("application.viewer.utility.search.markup.regex.enabled", this.regexMenuItem.isSelected());
        } else if (object == this.caseSensitiveMenutItem) {
            this.regexMenuItem.setEnabled(!this.caseSensitiveMenutItem.isSelected());
            this.preferences.putBoolean("application.viewer.utility.search.markup.case.sensitive.enabled", this.caseSensitiveMenutItem.isSelected());
        }
    }

    protected void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    public class FilterColorAction
    extends AbstractAction {
        public FilterColorAction(String string, Color color) {
            this.putValue("Name", string);
            this.putValue(MarkupAnnotationPanel.COLUMN_PROPERTY, color);
            if (color != null) {
                this.putValue("SmallIcon", new ColorIcon(color));
            }
        }

        public Integer getColorRGB() {
            Object object = this.getValue("SmallIcon");
            if (object != null) {
                return ((ColorIcon)object).getColor().getRGB();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MarkupAnnotationPanel.this.filterColorAction = this;
            if (this.getValue(MarkupAnnotationPanel.COLUMN_PROPERTY) != null) {
                int n = ((Color)this.getValue(MarkupAnnotationPanel.COLUMN_PROPERTY)).getRGB();
                MarkupAnnotationPanel.this.preferences.putInt("application.viewer.utility.annotation.filter.color.column", n);
            } else {
                MarkupAnnotationPanel.this.preferences.putInt("application.viewer.utility.annotation.filter.color.column", -1);
            }
            MarkupAnnotationPanel.this.sortAndFilterAnnotationData();
        }
    }

    class FilterVisibilityAction
    extends AbstractAction {
        public FilterVisibilityAction(String string, FilterVisibilityColumn filterVisibilityColumn) {
            this.putValue("Name", string);
            this.putValue(MarkupAnnotationPanel.COLUMN_PROPERTY, (Object)filterVisibilityColumn);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MarkupAnnotationPanel.this.filterVisibilityAction = this;
            MarkupAnnotationPanel.this.preferences.put("application.viewer.utility.annotation.filter.visibility.column", this.getValue(MarkupAnnotationPanel.COLUMN_PROPERTY).toString());
            MarkupAnnotationPanel.this.sortAndFilterAnnotationData();
        }
    }

    class FilterAuthorAction
    extends AbstractAction {
        public FilterAuthorAction(String string, FilterAuthorColumn filterAuthorColumn) {
            this.putValue("Name", string);
            this.putValue(MarkupAnnotationPanel.COLUMN_PROPERTY, (Object)filterAuthorColumn);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MarkupAnnotationPanel.this.filterAuthorAction = this;
            MarkupAnnotationPanel.this.preferences.put("application.viewer.utility.annotation.filter.author.column", this.getValue(MarkupAnnotationPanel.COLUMN_PROPERTY).toString());
            MarkupAnnotationPanel.this.sortAndFilterAnnotationData();
        }
    }

    class FilterTypeAction
    extends AbstractAction {
        public FilterTypeAction(String string, FilterSubTypeColumn filterSubTypeColumn) {
            this.putValue("Name", string);
            this.putValue(MarkupAnnotationPanel.COLUMN_PROPERTY, (Object)filterSubTypeColumn);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MarkupAnnotationPanel.this.filterTypeAction = this;
            MarkupAnnotationPanel.this.preferences.put("application.viewer.utility.annotation.filter.type.column", this.getValue(MarkupAnnotationPanel.COLUMN_PROPERTY).toString());
            MarkupAnnotationPanel.this.sortAndFilterAnnotationData();
        }
    }

    class SortAction
    extends AbstractAction {
        public SortAction(String string, SortColumn sortColumn) {
            this.putValue("Name", string);
            this.putValue(MarkupAnnotationPanel.COLUMN_PROPERTY, (Object)sortColumn);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MarkupAnnotationPanel.this.sortAction = this;
            MarkupAnnotationPanel.this.preferences.put("application.viewer.utility.annotation.sort.column", this.getValue(MarkupAnnotationPanel.COLUMN_PROPERTY).toString());
            MarkupAnnotationPanel.this.sortAndFilterAnnotationData();
        }
    }

    public static enum FilterVisibilityColumn {
        ALL,
        PRIVATE,
        PUBLIC;

    }

    public static enum FilterSubTypeColumn {
        ALL,
        TEXT,
        HIGHLIGHT,
        STRIKEOUT,
        UNDERLINE,
        LINE,
        SQUARE,
        CIRCLE,
        INK,
        FREETEXT;

    }

    public static enum FilterAuthorColumn {
        ALL,
        AUTHOR_CURRENT,
        AUTHOR_OTHER;

    }

    public static enum SortColumn {
        PAGE,
        AUTHOR,
        DATE,
        TYPE,
        COLOR,
        VISIBILITY;

    }
}

