/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.markup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.FocusManager;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.AbstractWorkerPanel;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationCellRender;
import org.icepdf.ri.common.utility.annotation.AnnotationTreeNode;
import org.icepdf.ri.common.utility.annotation.markup.FindMarkupAnnotationTask;
import org.icepdf.ri.common.utility.annotation.markup.MarkupAnnotationPanel;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.PageComponentSelector;
import org.icepdf.ri.common.views.annotations.FreeTextAnnotationComponent;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationPopupMenu;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupListener;

public class MarkupAnnotationHandlerPanel
extends AbstractWorkerPanel
implements PropertyChangeListener,
TreeSelectionListener {
    private DefaultMutableTreeNode pageTreeNode;
    private final MarkupAnnotationPanel parentMarkupAnnotationPanel;
    private final Set<Annotation> annotationSet = new HashSet<Annotation>();
    private final Set<String> pageLabels = new HashSet<String>();
    private Pattern searchPattern;
    private MarkupAnnotationPanel.SortColumn sortType;
    private MarkupAnnotationPanel.FilterSubTypeColumn filterType;
    private MarkupAnnotationPanel.FilterAuthorColumn filterAuthor;
    private MarkupAnnotationPanel.FilterVisibilityColumn filterVisibility;
    private Color filterColor;
    private boolean isRegex;
    private boolean isCaseSensitive;

    MarkupAnnotationHandlerPanel(Controller controller, MarkupAnnotationPanel markupAnnotationPanel) {
        super(controller);
        this.parentMarkupAnnotationPanel = markupAnnotationPanel;
        this.nodeSelectionListener = new AnnotationNodeSelectionListener();
        this.cellRenderer = new AnnotationCellRender();
        this.rootNodeLabel = this.messageBundle.getString("viewer.utilityPane.markupAnnotation.title");
        ((DocumentViewControllerImpl)controller.getDocumentViewController()).addPropertyChangeListener(this);
        this.buildUI();
        this.tree.addTreeSelectionListener(this);
    }

    @Override
    public void refreshDocumentInstance() {
        this.annotationSet.clear();
        this.pageLabels.clear();
        super.refreshDocumentInstance();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("annotationDeleted".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getOldValue() instanceof MarkupAnnotationComponent) {
                MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)propertyChangeEvent.getOldValue();
                MarkupAnnotation markupAnnotation = (MarkupAnnotation)markupAnnotationComponent.getAnnotation();
                for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
                    TreePath treePath;
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    MutableTreeNode mutableTreeNode;
                    AnnotationTreeNode annotationTreeNode = this.findAnnotationTreeNode(this.rootTreeNode.getChildAt(i), markupAnnotation);
                    if (annotationTreeNode == null || (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)(treePath = new TreePath(annotationTreeNode.getPath())).getLastPathComponent()).getParent()) == null) continue;
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                    break;
                }
            }
        } else if ("annotationUpdated".equals(propertyChangeEvent.getPropertyName()) || "annotationSummaryUpdated".equals(propertyChangeEvent.getPropertyName())) {
            FreeTextAnnotationComponent freeTextAnnotationComponent;
            MarkupAnnotation markupAnnotation;
            if (propertyChangeEvent.getNewValue() instanceof PopupAnnotationComponent) {
                MarkupAnnotation markupAnnotation2;
                PopupAnnotationComponent popupAnnotationComponent = (PopupAnnotationComponent)propertyChangeEvent.getNewValue();
                PopupAnnotation popupAnnotation = (PopupAnnotation)popupAnnotationComponent.getAnnotation();
                if (popupAnnotation.getParent() != null && !(markupAnnotation2 = popupAnnotation.getParent()).isInReplyTo()) {
                    for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
                        AnnotationTreeNode annotationTreeNode = this.findAnnotationTreeNode(this.rootTreeNode.getChildAt(i), markupAnnotation2);
                        if (annotationTreeNode == null) continue;
                        annotationTreeNode.applyMessage((Annotation)markupAnnotation2, this.messageBundle);
                        ((DefaultTreeModel)this.tree.getModel()).nodeChanged(annotationTreeNode);
                        break;
                    }
                }
            } else if (propertyChangeEvent.getNewValue() instanceof FreeTextAnnotationComponent && !(markupAnnotation = (MarkupAnnotation)(freeTextAnnotationComponent = (FreeTextAnnotationComponent)propertyChangeEvent.getNewValue()).getAnnotation()).isInReplyTo()) {
                for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
                    AnnotationTreeNode annotationTreeNode = this.findAnnotationTreeNode(this.rootTreeNode.getChildAt(i), markupAnnotation);
                    if (annotationTreeNode == null) continue;
                    annotationTreeNode.applyMessage((Annotation)markupAnnotation, this.messageBundle);
                    ((DefaultTreeModel)this.tree.getModel()).nodeChanged(annotationTreeNode);
                    break;
                }
            }
            this.tree.repaint();
        } else if ("annotationAdded".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() instanceof MarkupAnnotationComponent) {
                this.refreshMarkupTree();
            }
        } else if ("annotationSelected".equals(propertyChangeEvent.getPropertyName()) || "annotationFocusGained".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() instanceof MarkupAnnotationComponent) {
                MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)propertyChangeEvent.getNewValue();
                MarkupAnnotation markupAnnotation = (MarkupAnnotation)markupAnnotationComponent.getAnnotation();
                for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
                    AnnotationTreeNode annotationTreeNode = this.findAnnotationTreeNode(this.rootTreeNode.getChildAt(i), markupAnnotation);
                    if (annotationTreeNode == null) continue;
                    TreePath treePath = new TreePath(annotationTreeNode.getPath());
                    this.tree.setSelectionPath(treePath);
                    this.tree.scrollPathToVisible(treePath);
                    break;
                }
            }
        } else if ("annotationDeselected".equals(propertyChangeEvent.getPropertyName()) || "annotationFocusLost".equals(propertyChangeEvent.getPropertyName())) {
            // empty if block
        }
    }

    AnnotationComponent getSelectedAnnotation() {
        Object object;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof AnnotationTreeNode) {
            AnnotationTreeNode annotationTreeNode = (AnnotationTreeNode)treePath.getLastPathComponent();
            return PageComponentSelector.SelectAnnotationComponent(this.controller, annotationTreeNode.getAnnotation());
        }
        return null;
    }

    private AnnotationTreeNode findAnnotationTreeNode(TreeNode treeNode, MarkupAnnotation markupAnnotation) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            AnnotationTreeNode annotationTreeNode;
            MarkupAnnotation markupAnnotation2;
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (!(treeNode2 instanceof AnnotationTreeNode) || !markupAnnotation.equals(markupAnnotation2 = (MarkupAnnotation)(annotationTreeNode = (AnnotationTreeNode)treeNode2).getAnnotation())) continue;
            return annotationTreeNode;
        }
        return null;
    }

    public void sortAndFilterAnnotationData(Pattern pattern, MarkupAnnotationPanel.SortColumn sortColumn, MarkupAnnotationPanel.FilterSubTypeColumn filterSubTypeColumn, MarkupAnnotationPanel.FilterAuthorColumn filterAuthorColumn, MarkupAnnotationPanel.FilterVisibilityColumn filterVisibilityColumn, Color color, boolean bl, boolean bl2) {
        this.searchPattern = pattern;
        this.sortType = sortColumn;
        this.filterType = filterSubTypeColumn;
        this.filterAuthor = filterAuthorColumn;
        this.filterVisibility = filterVisibilityColumn;
        this.filterColor = color;
        this.isRegex = bl;
        this.isCaseSensitive = bl2;
        this.refreshMarkupTree();
    }

    public void refreshMarkupTree() {
        this.pageLabels.clear();
        this.annotationSet.clear();
        this.resetTree();
        this.buildWorkerTaskUI();
    }

    @Override
    public void buildUI() {
        super.buildUI();
        this.buildProgressBar();
    }

    public void addAnnotation(Annotation annotation, Pattern pattern) {
        if (!this.annotationSet.contains(annotation)) {
            this.annotationSet.add(annotation);
            if (annotation instanceof MarkupAnnotation) {
                this.descendFormTree(this.pageTreeNode, annotation, pattern);
                this.expandAllNodes();
            }
        }
    }

    void setProgressLabel(String string) {
        this.progressLabel.setText(string);
    }

    @Override
    public void startProgressControls(int n) {
        this.progressBar.setVisible(true);
        this.progressLabel.setVisible(true);
        this.progressBar.setMaximum(n);
    }

    @Override
    public void updateProgressControls(int n) {
        this.progressBar.setValue(n);
    }

    @Override
    public void updateProgressControls(int n, String string) {
    }

    @Override
    public void updateProgressControls(String string) {
    }

    @Override
    public void endProgressControls() {
        this.progressBar.setVisible(false);
        this.progressLabel.setVisible(false);
        Component component = FocusManager.getCurrentManager().getFocusOwner();
        if (this.isMarkupAnnotationPanelFocused(component)) {
            ((SwingController)this.controller).changeAnnotationsVisibility(annotation -> this.annotationSet.contains(annotation) || annotation instanceof PopupAnnotation && this.annotationSet.contains(((PopupAnnotation)annotation).getParent()), true, true);
            PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Component) {
                    Component component = (Component)object;
                    Component component2 = this.controller.getViewerFrame().getComponent(0);
                    if (component2 != component && !this.isMarkupAnnotationPanelFocused(component)) {
                        ((SwingController)this.controller).changeAnnotationsVisibility(annotation -> true, true, false);
                        FocusManager.getCurrentManager().removePropertyChangeListener(this);
                    }
                }
            };
            FocusManager.getCurrentManager().addPropertyChangeListener(propertyChangeListener);
        }
    }

    private boolean isMarkupAnnotationPanelFocused(Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container != this.parentMarkupAnnotationPanel) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void buildWorkerTaskUI() {
        PageTree pageTree;
        int n;
        this.stopWorkerTask();
        Document document = this.controller.getDocument();
        if (document != null && (n = (pageTree = document.getCatalog().getPageTree()).getNumberOfPages()) > 0) {
            this.progressLabel.setVisible(true);
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(n);
            this.workerTask = new FindMarkupAnnotationTask.Builder(this, this.controller, this.messageBundle).setSearchPattern(this.searchPattern).setSortType(this.sortType).setFilterType(this.filterType).setFilterAuthor(this.filterAuthor).setFilterVisibility(this.filterVisibility).setFilterColor(this.filterColor).setRegex(this.isRegex).setCaseSensitive(this.isCaseSensitive).build();
            this.workerTask.execute();
        }
    }

    void addPageGroup(String string) {
        if (!this.pageLabels.contains(string)) {
            this.pageLabels.add(string);
            this.pageTreeNode = new DefaultMutableTreeNode(string);
            this.pageTreeNode.setAllowsChildren(true);
            this.treeModel.insertNodeInto(this.pageTreeNode, this.rootTreeNode, this.rootTreeNode.getChildCount());
        }
    }

    private void descendFormTree(DefaultMutableTreeNode defaultMutableTreeNode, Object object, Pattern pattern) {
        if (!(object instanceof AbstractWidgetAnnotation) && object instanceof Annotation) {
            AnnotationTreeNode annotationTreeNode = new AnnotationTreeNode((Annotation)object, this.messageBundle, pattern, this.isCaseSensitive);
            this.treeModel.insertNodeInto(annotationTreeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
    }

    @Override
    public void selectTreeNodeUserObject(Object object) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof AnnotationTreeNode) {
            AnnotationTreeNode annotationTreeNode = (AnnotationTreeNode)object;
            Annotation annotation = annotationTreeNode.getAnnotation();
            PageComponentSelector.SelectAnnotationComponent(this.controller, annotation, false, false);
        }
        this.tree.requestFocus();
    }

    private class AnnotationNodeSelectionListener
    extends AbstractWorkerPanel.NodeSelectionListener {
        private AnnotationNodeSelectionListener() {
        }

        @Override
        public void setTree(JTree jTree) {
            super.setTree(jTree);
            PopupListener popupListener = new PopupListener(this.contextMenu);
            MarkupAnnotationHandlerPanel.this.addMouseListener(popupListener);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof AnnotationTreeNode) {
                    AnnotationTreeNode annotationTreeNode = (AnnotationTreeNode)object;
                    Annotation annotation = annotationTreeNode.getAnnotation();
                    AnnotationComponent annotationComponent = PageComponentSelector.SelectAnnotationComponent(MarkupAnnotationHandlerPanel.this.controller, annotation, false);
                    if (annotationComponent instanceof MarkupAnnotationComponent) {
                        if (mouseEvent.getButton() == 1) {
                            DocumentViewController documentViewController = MarkupAnnotationHandlerPanel.this.controller.getDocumentViewController();
                            MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)annotationComponent;
                            if (mouseEvent.getClickCount() == 1) {
                                documentViewController.firePropertyChange("annotationSelected", null, markupAnnotationComponent);
                                MarkupAnnotationHandlerPanel.this.parentMarkupAnnotationPanel.getQuickPaintAnnotationButton().setColor(markupAnnotationComponent.getAnnotation().getColor(), false);
                            } else if (mouseEvent.getClickCount() == 2) {
                                markupAnnotationComponent.requestFocus();
                            }
                        }
                        if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
                            this.contextMenu = new MarkupAnnotationPopupMenu((MarkupAnnotationComponent)annotationComponent, MarkupAnnotationHandlerPanel.this.controller, null, true);
                            this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                        MarkupAnnotationHandlerPanel.this.parentMarkupAnnotationPanel.getQuickPaintAnnotationButton().setEnabled(true);
                    } else {
                        MarkupAnnotationHandlerPanel.this.parentMarkupAnnotationPanel.getQuickPaintAnnotationButton().setEnabled(false);
                    }
                } else {
                    MarkupAnnotationHandlerPanel.this.parentMarkupAnnotationPanel.getQuickPaintAnnotationButton().setEnabled(false);
                }
            }
        }
    }
}

