/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.destinations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Names;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.NameJTree;
import org.icepdf.ri.common.NameTreeNode;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanel;
import org.icepdf.ri.common.utility.annotation.destinations.NameTreeEditDialog;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.destinations.DestinationComponent;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class DestinationsPanel
extends JPanel
implements MutableDocument,
TreeSelectionListener,
MouseListener,
ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DestinationsPanel.class.toString());
    protected final GridBagConstraints constraints;
    private final Controller controller;
    private final ResourceBundle messageBundle;
    private final NameJTree nameJTree;
    private final JPopupMenu contextMenu;
    private final JMenuItem deleteNameTreeNode;
    private final JMenuItem editNameTreeNode;

    public DestinationsPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager) {
        this.messageBundle = swingController.getMessageBundle();
        Preferences preferences = viewerPropertiesManager.getPreferences();
        this.setLayout(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.controller = swingController;
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.nameJTree = new NameJTree();
        this.nameJTree.addTreeSelectionListener(this);
        this.nameJTree.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.nameJTree);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.contextMenu = new JPopupMenu();
        this.editNameTreeNode = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.destinations.view.contextMenu.edit.label"));
        this.editNameTreeNode.addActionListener(this);
        this.contextMenu.add(this.editNameTreeNode);
        this.contextMenu.addSeparator();
        this.deleteNameTreeNode = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.destinations.view.contextMenu.delete.label"));
        this.deleteNameTreeNode.addActionListener(this);
        this.contextMenu.add(this.deleteNameTreeNode);
        this.addGB(this, jScrollPane, 0, 0, 1, 1);
        this.setFocusable(true);
        this.addPropertyChangeListener("destinationUpdated", swingController);
        ((DocumentViewControllerImpl)swingController.getDocumentViewController()).addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DestinationComponent destinationComponent;
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        String string = propertyChangeEvent.getPropertyName();
        if ((string.equals("destinationSelected") || string.equals("destinationFocusGained")) && (destinationComponent = (DestinationComponent)object) != null && destinationComponent.getDestination() != null) {
            this.selectedDestinationComponentPath(destinationComponent);
        }
    }

    public void setParentPanel(AnnotationPanel annotationPanel) {
    }

    public void removeNameTreeNode(Destination destination) {
        Enumeration<TreeNode> enumeration = ((NameTreeNode)this.nameJTree.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            NameTreeNode nameTreeNode = (NameTreeNode)enumeration.nextElement();
            if (nameTreeNode.getName() == null || !nameTreeNode.getName().toString().equals(destination.getNamedDestination())) continue;
            ((DefaultTreeModel)this.nameJTree.getModel()).removeNodeFromParent(nameTreeNode);
        }
    }

    public void refreshNameTree(Object object) {
        Names names = this.controller.getDocument().getCatalog().getNames();
        if (names != null && names.getDestsNameTree() != null) {
            NameTree nameTree = names.getDestsNameTree();
            if (nameTree != null) {
                this.nameJTree.setModel(new DefaultTreeModel(new NameTreeNode(nameTree.getRoot(), this.messageBundle)));
                this.nameJTree.setRootVisible(true);
                this.nameJTree.setShowsRootHandles(true);
                if (object instanceof NameTreeNode) {
                    NameTreeNode nameTreeNode = (NameTreeNode)object;
                    Enumeration<TreeNode> enumeration = ((NameTreeNode)this.nameJTree.getModel().getRoot()).depthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        NameTreeNode nameTreeNode2 = (NameTreeNode)enumeration.nextElement();
                        if (nameTreeNode2.getName() == null || !nameTreeNode2.getName().toString().equals(nameTreeNode.getName().toString())) continue;
                        this.nameJTree.setSelectionPath(new TreePath(nameTreeNode2.getPath()));
                    }
                }
            }
        } else {
            this.nameJTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.root.label"))));
            this.nameJTree.setRootVisible(true);
            this.nameJTree.setShowsRootHandles(true);
        }
    }

    public void selectedDestinationComponentPath(DestinationComponent destinationComponent) {
        Names names = this.controller.getDocument().getCatalog().getNames();
        if (names != null && names.getDestsNameTree() != null) {
            Enumeration<TreeNode> enumeration = ((NameTreeNode)this.nameJTree.getModel().getRoot()).depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                NameTreeNode nameTreeNode = (NameTreeNode)enumeration.nextElement();
                if (nameTreeNode.getName() == null || !nameTreeNode.getName().toString().equals(destinationComponent.getDestination().getNamedDestination())) continue;
                this.selectDestinationPath(new TreePath(nameTreeNode.getPath()));
            }
        }
    }

    public void selectDestinationPath(TreePath treePath) {
        this.nameJTree.setSelectionPath(treePath);
        this.nameJTree.scrollPathToVisible(treePath);
    }

    @Override
    public void refreshDocumentInstance() {
        this.refreshNameTree(null);
    }

    @Override
    public void disposeDocument() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        TreePath treePath = this.nameJTree.getSelectionPath();
        if (treePath != null) {
            NameTreeNode nameTreeNode = (NameTreeNode)treePath.getLastPathComponent();
            if (object == this.editNameTreeNode) {
                NameTreeEditDialog nameTreeEditDialog = new NameTreeEditDialog(this.controller, nameTreeNode);
                nameTreeEditDialog.setVisible(true);
            } else if (object == this.deleteNameTreeNode) {
                Destination destination = new Destination(this.controller.getDocument().getCatalog().getLibrary(), nameTreeNode.getReference());
                destination.setNamedDestination(nameTreeNode.getName().toString());
                this.controller.getDocumentViewController().firePropertyChange("destinationDeleted", destination, null);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.nameJTree == null) {
            return;
        }
        TreePath treePath = this.nameJTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof NameTreeNode) {
            this.controller.followDestinationItem((NameTreeNode)object);
        }
        this.nameJTree.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = this.nameJTree.getRowForLocation(n2, n = mouseEvent.getY());
        TreePath treePath = this.nameJTree.getPathForRow(n3);
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof NameTreeNode) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                NameTreeNode nameTreeNode = (NameTreeNode)object;
                if (nameTreeNode.getReference() != null && nameTreeNode.isLeaf()) {
                    this.controller.followDestinationItem((NameTreeNode)object);
                }
            } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
                NameTreeNode nameTreeNode = (NameTreeNode)object;
                this.nameJTree.setSelectionPath(new TreePath(nameTreeNode.getPath()));
                if (nameTreeNode.getReference() != null && nameTreeNode.isLeaf()) {
                    this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

