/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.ri.common.utility.annotation.AbstractAnnotationTreeNode;

public class AnnotationTreeNode
extends AbstractAnnotationTreeNode<Annotation> {
    private static final Logger logger = Logger.getLogger(AnnotationTreeNode.class.toString());
    private Annotation annotation;
    private final Pattern searchPattern;
    private final boolean caseSensitive;

    public AnnotationTreeNode(Annotation annotation, ResourceBundle resourceBundle, Pattern pattern, boolean bl) {
        this.annotation = annotation;
        this.searchPattern = pattern;
        this.caseSensitive = bl;
        this.applyMessage(annotation, resourceBundle);
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void applyMessage(Annotation annotation, ResourceBundle resourceBundle) {
        Object object;
        String string = null;
        if (annotation instanceof TextWidgetAnnotation) {
            string = (String)((TextWidgetAnnotation)annotation).getFieldDictionary().getFieldValue();
        } else {
            object = annotation.getContents();
            if (object != null) {
                string = this.caseSensitive ? object : ((String)object).toLowerCase();
            }
        }
        this.annotation = annotation;
        if (string == null || string.isEmpty()) {
            string = this.getNullMessage(resourceBundle);
        } else if (this.searchPattern != null) {
            object = this.searchPattern.matcher(string);
            StringBuilder stringBuilder = new StringBuilder("<html>");
            int n = 0;
            while (((Matcher)object).find()) {
                int n2 = ((Matcher)object).start();
                int n3 = ((Matcher)object).end();
                stringBuilder.append(string, n, n2);
                stringBuilder.append("<b>");
                stringBuilder.append(string, n2, n3);
                stringBuilder.append("</b>");
                n = n3;
            }
            if (n < string.length()) {
                stringBuilder.append(string.substring(n));
            }
            string = stringBuilder.toString();
        }
        this.setUserObject(string);
    }

    protected String getNullMessage(ResourceBundle resourceBundle) {
        String string = null;
        if (this.annotation instanceof TextAnnotation) {
            string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.textComment.empty.label");
        } else if (this.annotation instanceof LinkAnnotation) {
            string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.link.empty.label");
        } else if (this.annotation instanceof FreeTextAnnotation) {
            string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.freeText.empty.label");
        } else if (this.annotation instanceof LineAnnotation) {
            string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.line.empty.label");
        } else if (this.annotation instanceof SquareAnnotation) {
            string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.square.empty.label");
        } else if (this.annotation instanceof CircleAnnotation) {
            string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.circle.empty.label");
        } else if (this.annotation instanceof TextMarkupAnnotation) {
            if (this.annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_HIGHLIGHT)) {
                string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.highlight.empty.label");
            } else if (this.annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_SQUIGGLY)) {
                string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.squiggly.empty.label");
            } else if (this.annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT)) {
                string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.strike.empty.label");
            } else if (this.annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_UNDERLINE)) {
                string = resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.underline.empty.label");
            }
        } else {
            string = this.annotation instanceof InkAnnotation ? resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.ink.empty.label") : (this.annotation instanceof PopupAnnotation ? resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.popup.empty.label") : (this.annotation instanceof TextWidgetAnnotation ? resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.form.empty.label") : resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.unknown.empty.label")));
        }
        return string;
    }
}

