/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.ZoomInPageHandler;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class ZoomInViewHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(ZoomInPageHandler.class.toString());
    private final AbstractDocumentView parentComponent;

    public ZoomInViewHandler(DocumentViewController documentViewController, AbstractDocumentView abstractDocumentView) {
        super(documentViewController, null);
        this.parentComponent = abstractDocumentView;
    }

    @Override
    protected void checkAndApplyPreferences() {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.parentComponent);
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            if (documentViewModel != null) {
                List<AbstractPageViewComponent> list = documentViewModel.getPageComponents();
                for (AbstractPageViewComponent abstractPageViewComponent : list) {
                    Rectangle rectangle = SwingUtilities.convertRectangle(this.parentComponent, this.getRectToDraw(), abstractPageViewComponent);
                    if (!abstractPageViewComponent.getBounds().intersects(rectangle)) continue;
                    Rectangle rectangle2 = SwingUtilities.convertRectangle(this.parentComponent, this.rectToDraw, abstractPageViewComponent);
                    abstractPageViewComponent.setSelectionRectangle(SwingUtilities.convertPoint(this.parentComponent, mouseEvent.getPoint(), abstractPageViewComponent), rectangle2);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x1F5) != 0 && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            this.documentViewController.setZoomIn(mouseEvent.getPoint());
        }
        if (this.parentComponent != null) {
            this.parentComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.resetRectangle(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.parentComponent);
            if (this.documentViewController.getViewPort() != null && this.rectToDraw.getWidth() > 0.0 && this.rectToDraw.getHeight() > 0.0) {
                float f = ZoomInPageHandler.calculateZoom(this.documentViewController, this.rectToDraw, this.documentViewController.getDocumentViewModel());
                Point point = new Point((int)this.rectToDraw.getCenterX(), (int)this.rectToDraw.getCenterY());
                this.documentViewController.setZoomCentered(f, point, true);
            }
            this.clearRectangle(this.parentComponent);
            List<AbstractPageViewComponent> list = this.documentViewController.getDocumentViewModel().getPageComponents();
            if (list != null && list.size() > 0) {
                for (AbstractPageViewComponent abstractPageViewComponent : list) {
                    if (abstractPageViewComponent == null || !abstractPageViewComponent.isVisible()) continue;
                    abstractPageViewComponent.clearSelectionRectangle();
                }
            }
        }
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    @Override
    public void paintTool(Graphics graphics) {
        ZoomInViewHandler.paintSelectionBox(graphics, this.rectToDraw);
    }
}

