/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class ZoomInPageHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(ZoomInPageHandler.class.toString());
    private final Point initialPoint = new Point();

    public ZoomInPageHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        selectionBoxColour = Color.DARK_GRAY;
    }

    @Override
    protected void checkAndApplyPreferences() {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiersEx() & 0x1F5) != 0 && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            Point point = this.documentViewController.getDocumentViewModel().getPageBounds(this.pageViewComponent.getPageIndex()).getLocation();
            Point point2 = mouseEvent.getPoint();
            point2.setLocation(point.x + point2.x, point.y + point2.y);
            this.documentViewController.setZoomIn(point2);
        }
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.resetRectangle(mouseEvent.getX(), mouseEvent.getY());
            this.initialPoint.setLocation(mouseEvent.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
            int n = this.pageViewComponent.getPageIndex();
            Rectangle rectangle = this.documentViewController.getDocumentViewModel().getPageBounds(n);
            Rectangle rectangle2 = new Rectangle(rectangle.x + this.rectToDraw.x, rectangle.y + this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
            if (this.documentViewController.getViewPort() != null && rectangle2.getWidth() > 0.0 && rectangle2.getHeight() > 0.0) {
                float f = ZoomInPageHandler.calculateZoom(this.documentViewController, rectangle2, this.documentViewController.getDocumentViewModel());
                Point point = new Point(rectangle2.x - rectangle.x, rectangle2.y - rectangle.y);
                this.documentViewController.setZoomToViewPort(f, point, n, true);
            }
            this.clearRectangle(this.pageViewComponent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
        this.setSelectionSize(rectangle, this.pageViewComponent);
    }

    @Override
    public void paintTool(Graphics graphics) {
        ZoomInPageHandler.paintSelectionBox(graphics, this.rectToDraw);
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    public static float calculateZoom(DocumentViewController documentViewController, Rectangle rectangle, DocumentViewModel documentViewModel) {
        Dimension dimension = documentViewController.getViewPort().getParent().getSize();
        int n = rectangle.width;
        int n2 = dimension.width;
        if ((double)n2 < dimension.getHeight()) {
            n2 = dimension.height;
        }
        if ((double)n < rectangle.getHeight()) {
            n = rectangle.height;
        }
        return (float)n2 / (float)n * documentViewModel.getViewZoom();
    }
}

