/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.CommonToolHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class TextAnnotationHandler
extends CommonToolHandler
implements ToolHandler {
    private static final Logger logger;
    protected static Color defaultFillColor;
    protected static String defaultIcon;
    protected static int defaultOpacity;
    protected static final Dimension ICON_SIZE;

    public TextAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.checkAndApplyPreferences();
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkAndApplyPreferences();
    }

    public static TextAnnotation createTextAnnotation(Library library, Rectangle rectangle, AffineTransform affineTransform) {
        TextAnnotation textAnnotation = (TextAnnotation)AnnotationFactory.buildAnnotation((Library)library, (Name)Annotation.SUBTYPE_TEXT, (Rectangle)rectangle);
        textAnnotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
        textAnnotation.setTitleText(SystemProperties.USER_NAME);
        textAnnotation.setContents("");
        textAnnotation.setIconName(new Name(defaultIcon));
        textAnnotation.setColor(defaultFillColor);
        textAnnotation.setOpacity(defaultOpacity);
        textAnnotation.setState("Unmarked");
        textAnnotation.setBBox(new Rectangle(0, 0, rectangle.width, rectangle.height));
        textAnnotation.resetAppearanceStream(affineTransform);
        return textAnnotation;
    }

    public TextAnnotation createTextAnnotationInstance(Library library, Rectangle rectangle, AffineTransform affineTransform) {
        TextAnnotation textAnnotation = TextAnnotationHandler.createTextAnnotation(library, rectangle, affineTransform);
        this.checkAndApplyPreferences();
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        textAnnotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        textAnnotation.setIconName(new Name(defaultIcon));
        textAnnotation.setColor(defaultFillColor);
        textAnnotation.setOpacity(defaultOpacity);
        textAnnotation.resetAppearanceStream(affineTransform);
        return textAnnotation;
    }

    public static PopupAnnotation createPopupAnnotation(Library library, Rectangle rectangle, MarkupAnnotation markupAnnotation, AffineTransform affineTransform, boolean bl) {
        PopupAnnotation popupAnnotation = (PopupAnnotation)AnnotationFactory.buildAnnotation((Library)library, (Name)Annotation.SUBTYPE_POPUP, (Rectangle)rectangle);
        StateManager stateManager = library.getStateManager();
        stateManager.addChange(new PObject((Object)popupAnnotation, popupAnnotation.getPObjectReference()), bl);
        library.addObject((Object)popupAnnotation, popupAnnotation.getPObjectReference());
        popupAnnotation.setOpen(true);
        popupAnnotation.setParent(markupAnnotation);
        markupAnnotation.setPopupAnnotation(popupAnnotation);
        popupAnnotation.resetAppearanceStream(0.0, 0.0, affineTransform, bl);
        return popupAnnotation;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        AffineTransform affineTransform = this.getToPageSpaceTransform();
        AffineTransform affineTransform2 = this.getPageTransform();
        Dimension dimension = new Dimension((int)Math.abs((double)TextAnnotationHandler.ICON_SIZE.width * affineTransform2.getScaleX()), (int)Math.abs((double)TextAnnotationHandler.ICON_SIZE.height * affineTransform2.getScaleY()));
        Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), dimension.width, dimension.height);
        Rectangle rectangle2 = this.convertToPageSpace(rectangle).getBounds();
        TextAnnotation textAnnotation = this.createTextAnnotationInstance(this.documentViewController.getDocument().getPageTree().getLibrary(), rectangle2, affineTransform);
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)textAnnotation, this.documentViewController, this.pageViewComponent);
        markupAnnotationComponent.setBounds(rectangle);
        markupAnnotationComponent.refreshAnnotationRect();
        this.documentViewController.addNewAnnotation(markupAnnotationComponent);
        PopupAnnotationComponent popupAnnotationComponent = markupAnnotationComponent.getPopupAnnotationComponent();
        popupAnnotationComponent.setBoundsRelativeToParent(mouseEvent.getX() + dimension.width / 2, mouseEvent.getY() + dimension.height / 2, affineTransform2);
        popupAnnotationComponent.setVisible(true);
        ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(true);
        popupAnnotationComponent.focusTextArea();
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.text.selection.type", 0));
    }

    @Override
    protected void checkAndApplyPreferences() {
        if (this.preferences.getInt("application.viewer.preference.annotation.text.color", -1) != -1) {
            defaultFillColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.text.color", -1));
        }
        defaultIcon = this.preferences.get("application.viewer.preference.annotation.text.icon", TextAnnotation.COMMENT_ICON.toString());
        defaultOpacity = this.preferences.getInt("application.viewer.preference.annotation.text.opacity", 255);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    static {
        block2: {
            logger = Logger.getLogger(TextAnnotationHandler.class.toString());
            try {
                String string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.text.fill.color", (String)"#ffff00");
                int n = ColorUtil.convertColor((String)string);
                defaultFillColor = new Color(n >= 0 ? n : Integer.parseInt("ffff00", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading text annotation fill colour");
            }
        }
        defaultOpacity = Defs.intProperty((String)"org.icepdf.core.views.page.annotation.text.fill.opacity", (int)255);
        defaultIcon = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.text.icon", (String)TextAnnotation.COMMENT_ICON.toString());
        ICON_SIZE = new Dimension(23, 23);
    }
}

