/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import org.icepdf.ri.common.tools.CommonToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.annotations.MarkupGlueComponent;

public abstract class SelectionBoxHandler
extends CommonToolHandler {
    protected static final float[] dash1 = new float[]{1.0f};
    protected static final BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash1, 0.0f);
    protected Rectangle currentRect = null;
    protected Rectangle rectToDraw = null;
    protected final Rectangle previousRectDrawn = new Rectangle();
    protected static Color selectionBoxColour = Color.lightGray;

    protected SelectionBoxHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
    }

    public abstract void setSelectionRectangle(Point var1, Rectangle var2);

    public static void paintSelectionBox(Graphics graphics, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        if (rectangle != null) {
            color = graphics.getColor();
            graphics2D.setColor(selectionBoxColour);
            graphics2D.setStroke(SelectionBoxHandler.stroke);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics2D.setColor(color);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public void resetRectangle(int n, int n2) {
        this.currentRect = new Rectangle(n, n2, 0, 0);
    }

    public Rectangle getCurrentRect() {
        return this.currentRect;
    }

    public void setCurrentRect(Rectangle rectangle) {
        this.currentRect = rectangle;
    }

    public Rectangle getRectToDraw() {
        return this.rectToDraw;
    }

    public void setRectToDraw(Rectangle rectangle) {
        this.rectToDraw = rectangle;
    }

    public void clearRectangle(Component component) {
        this.currentRect = new Rectangle(0, 0, 0, 0);
        this.updateDrawableRect(component.getWidth(), component.getHeight());
    }

    public void updateSelectionSize(int n, int n2, Component component) {
        if (this.currentRect == null) {
            this.currentRect = new Rectangle(n, n2, 0, 0);
        }
        this.currentRect.setSize(n - this.currentRect.x, n2 - this.currentRect.y);
        if (component != null) {
            this.updateDrawableRect(component.getWidth(), component.getHeight());
            Rectangle rectangle = this.rectToDraw.union(this.previousRectDrawn);
            component.repaint(rectangle.x, rectangle.y, rectangle.width + 10, rectangle.height + 10);
        }
    }

    public void setSelectionSize(Rectangle rectangle, Component component) {
        this.currentRect = rectangle;
        this.updateDrawableRect(component.getWidth(), component.getHeight());
        Rectangle rectangle2 = this.rectToDraw.union(this.previousRectDrawn);
        component.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public void updateDrawableRect(int n, int n2) {
        int n3 = this.currentRect.x;
        int n4 = this.currentRect.y;
        int n5 = this.currentRect.width;
        int n6 = this.currentRect.height;
        if (n5 < 0 && (n3 = n3 - (n5 = -n5) + 1) < 0) {
            n5 += n3;
            n3 = 0;
        }
        if (n6 < 0 && (n4 = n4 - (n6 = -n6) + 1) < 0) {
            n6 += n4;
            n4 = 0;
        }
        if (n3 + n5 > n) {
            n5 = n - n3;
        }
        if (n4 + n6 > n2) {
            n6 = n2 - n4;
        }
        if (this.rectToDraw != null) {
            this.previousRectDrawn.setBounds(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
            this.rectToDraw.setBounds(n3, n4, n5, n6);
        } else {
            this.rectToDraw = new Rectangle(n3, n4, n5, n6);
        }
    }

    protected PageViewComponentImpl isOverPageComponent(Container container, MouseEvent mouseEvent) {
        Component component = container.findComponentAt(mouseEvent.getPoint());
        if (component instanceof PageViewComponentImpl) {
            return (PageViewComponentImpl)component;
        }
        if (component instanceof MarkupGlueComponent && (component = component.getParent()) instanceof PageViewComponentImpl) {
            return (PageViewComponentImpl)component;
        }
        return null;
    }
}

