/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.views.DocumentViewController;

public class MouseWheelZoom
implements MouseWheelListener {
    protected final DocumentViewController documentViewController;
    protected final JScrollPane documentScrollPane;

    public MouseWheelZoom(DocumentViewController documentViewController, JScrollPane jScrollPane) {
        this.documentScrollPane = jScrollPane;
        this.documentViewController = documentViewController;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if ((mouseWheelEvent.getModifiersEx() & 0x80) == 128 || (mouseWheelEvent.getModifiersEx() & 0x100) == 256) {
            this.documentScrollPane.setWheelScrollingEnabled(false);
            Point point = this.documentScrollPane.getViewport().getViewPosition();
            int n2 = this.documentScrollPane.getViewport().getWidth() / 2;
            int n3 = this.documentScrollPane.getViewport().getHeight() / 2;
            point.setLocation(point.x + n2, point.y + n3);
            if (n > 0) {
                this.documentViewController.setZoomOut(point);
            } else {
                this.documentViewController.setZoomIn(point);
            }
        } else {
            this.documentScrollPane.setWheelScrollingEnabled(true);
        }
    }
}

