/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class LineAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger;
    protected static final BasicStroke stroke;
    protected static Color lineColor;
    protected static Color internalColor;
    protected static int opacity;
    protected static Name startLineEnding;
    protected static Name endLineEnding;
    protected Point startOfLine;
    protected Point endOfLine;
    protected final BorderStyle borderStyle = new BorderStyle();

    public LineAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        startLineEnding = LineAnnotation.LINE_END_NONE;
        endLineEnding = LineAnnotation.LINE_END_NONE;
        this.checkAndApplyPreferences();
    }

    @Override
    public void paintTool(Graphics graphics) {
        if (this.startOfLine != null && this.endOfLine != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics.setColor(lineColor);
            graphics2D.setStroke(LineAnnotationHandler.stroke);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)opacity / 255.0f));
            graphics.drawLine((int)this.startOfLine.getX(), (int)this.startOfLine.getY(), (int)this.endOfLine.getX(), (int)this.endOfLine.getY());
            graphics.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkAndApplyPreferences();
        Point point = mouseEvent.getPoint();
        this.startOfLine = new Point(point.x, point.y);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.currentRect = new Rectangle(n, n2, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        Point point = mouseEvent.getPoint();
        this.endOfLine = new Point(point.x, point.y);
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        this.rectToDraw.setRect(this.rectToDraw.getX() - 8.0, this.rectToDraw.getY() - 8.0, this.rectToDraw.getWidth() + 16.0, this.rectToDraw.getHeight() + 16.0);
        Rectangle rectangle = this.convertToPageSpace(this.rectToDraw).getBounds();
        Point2D[] point2DArray = this.convertToPageSpace(this.startOfLine, this.endOfLine);
        LineAnnotation lineAnnotation = (LineAnnotation)AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_LINE, (Rectangle)rectangle);
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        lineAnnotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        lineAnnotation.setStartArrow(startLineEnding);
        lineAnnotation.setEndArrow(endLineEnding);
        lineAnnotation.setStartOfLine(point2DArray[0]);
        lineAnnotation.setEndOfLine(point2DArray[1]);
        lineAnnotation.setBorderStyle(this.borderStyle);
        lineAnnotation.setColor(lineColor);
        lineAnnotation.setInteriorColor(internalColor);
        lineAnnotation.setOpacity(opacity);
        AffineTransform affineTransform = this.getToPageSpaceTransform();
        lineAnnotation.setContents(lineAnnotation.getSubType().toString());
        lineAnnotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
        lineAnnotation.setTitleText(SystemProperties.USER_NAME);
        lineAnnotation.setBBox(rectangle);
        lineAnnotation.resetAppearanceStream(affineTransform);
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)lineAnnotation, this.documentViewController, this.pageViewComponent);
        Rectangle rectangle2 = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        markupAnnotationComponent.setBounds(rectangle2);
        if (this.documentViewController.getAnnotationCallback() != null) {
            object = this.documentViewController.getAnnotationCallback();
            this.documentViewController.addNewAnnotation(markupAnnotationComponent);
        }
        object = markupAnnotationComponent.getPopupAnnotationComponent();
        ((PopupAnnotationComponent)object).setBoundsRelativeToParent(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2, affineTransform);
        ((PopupAnnotationComponent)object).setVisible(false);
        ((PopupAnnotation)((AbstractAnnotationComponent)object).getAnnotation()).setOpen(false);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.line.selection.type", 0));
        this.clearRectangle(this.pageViewComponent);
        this.endOfLine = null;
        this.startOfLine = null;
    }

    @Override
    protected void checkAndApplyPreferences() {
        lineColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.line.color", lineColor.getRGB()));
        internalColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.line.fill.color", internalColor.getRGB()));
        opacity = this.preferences.getInt("application.viewer.preference.annotation.line.fill.opcity", opacity);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        Point point = mouseEvent.getPoint();
        this.endOfLine = new Point(point.x, point.y);
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    static {
        block5: {
            int n;
            String string;
            block4: {
                logger = Logger.getLogger(LineAnnotationHandler.class.toString());
                stroke = new BasicStroke(1.0f, 0, 0, 1.0f);
                try {
                    string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.line.stroke.color", (String)"#ff0000");
                    n = ColorUtil.convertColor((String)string);
                    lineColor = new Color(n >= 0 ? n : Integer.parseInt("ff0000", 16));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading line Annotation stroke colour");
                }
            }
            try {
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.line.fill.color", (String)"#ff0000");
                n = ColorUtil.convertColor((String)string);
                internalColor = new Color(n >= 0 ? n : Integer.parseInt("ff0000", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading line Annotation fill colour");
            }
        }
        opacity = Defs.intProperty((String)"org.icepdf.core.views.page.annotation.line.fill.opacity", (int)255);
        startLineEnding = LineAnnotation.LINE_END_NONE;
        endLineEnding = LineAnnotation.LINE_END_NONE;
    }
}

