/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.CommonToolHandler;
import org.icepdf.ri.common.tools.LineAnnotationHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class InkAnnotationHandler
extends CommonToolHandler
implements ToolHandler,
ActionListener {
    private static final Logger logger;
    protected static final BasicStroke stroke;
    protected static Color inkColor;
    protected static int opacity;
    private static int createDelay;
    private final Timer creationTimer;
    protected GeneralPath inkPath;
    protected final BorderStyle borderStyle = new BorderStyle();

    public InkAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.creationTimer = new Timer(createDelay, this);
        this.checkAndApplyPreferences();
    }

    @Override
    public void paintTool(Graphics graphics) {
        if (this.inkPath != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(inkColor);
            graphics2D.setStroke(InkAnnotationHandler.stroke);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)opacity / 255.0f));
            graphics2D.draw(this.inkPath);
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    protected void checkAndApplyPreferences() {
        inkColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.ink.color", inkColor.getRGB()));
        opacity = this.preferences.getInt("application.viewer.preference.annotation.ink.opacity", opacity);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkAndApplyPreferences();
        if (this.inkPath == null) {
            this.inkPath = new GeneralPath();
        }
        this.inkPath.moveTo(mouseEvent.getX(), mouseEvent.getY());
        this.pageViewComponent.repaint();
        this.creationTimer.restart();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.creationTimer.restart();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.inkPath != null) {
            this.inkPath.lineTo(mouseEvent.getX(), mouseEvent.getY());
            this.pageViewComponent.repaint();
            this.creationTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.creationTimer.stop();
        this.buildInkAnnotation();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    protected void buildInkAnnotation() {
        Rectangle rectangle = this.inkPath.getBounds();
        rectangle.setRect(rectangle.getX() - 5.0, rectangle.getY() - 5.0, rectangle.getWidth() + 10.0, rectangle.getHeight() + 10.0);
        Rectangle rectangle2 = this.convertToPageSpace(rectangle).getBounds();
        Shape shape = this.convertToPageSpace(this.inkPath);
        InkAnnotation inkAnnotation = (InkAnnotation)AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_INK, (Rectangle)rectangle2);
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        inkAnnotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        inkAnnotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
        inkAnnotation.setTitleText(SystemProperties.USER_NAME);
        inkAnnotation.setColor(inkColor);
        inkAnnotation.setBorderStyle(this.borderStyle);
        inkAnnotation.setInkPath(shape);
        inkAnnotation.setOpacity(opacity);
        AffineTransform affineTransform = this.getToPageSpaceTransform();
        inkAnnotation.setBBox(rectangle2);
        inkAnnotation.resetAppearanceStream(affineTransform);
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)inkAnnotation, this.documentViewController, this.pageViewComponent);
        markupAnnotationComponent.setBounds(rectangle);
        this.documentViewController.addNewAnnotation(markupAnnotationComponent);
        PopupAnnotationComponent popupAnnotationComponent = markupAnnotationComponent.getPopupAnnotationComponent();
        popupAnnotationComponent.setBoundsRelativeToParent(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, affineTransform);
        popupAnnotationComponent.setVisible(false);
        ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(false);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.ink.selection.type", 0));
        this.inkPath = null;
    }

    static {
        block2: {
            logger = Logger.getLogger(LineAnnotationHandler.class.toString());
            stroke = new BasicStroke(1.0f, 0, 0, 1.0f);
            try {
                String string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.ink.line.color", (String)"#00ff00");
                int n = ColorUtil.convertColor((String)string);
                inkColor = new Color(n >= 0 ? n : Integer.parseInt("00ff00", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading Ink Annotation line colour");
            }
        }
        opacity = Defs.intProperty((String)"org.icepdf.core.views.page.annotation.ink.line.opacity", (int)255);
        createDelay = Defs.intProperty((String)"org.icepdf.core.views.page.annotation.ink.line.create.delay", (int)2000);
    }
}

